/*
 * Decompiled with CFR 0.152.
 */
package com.provinceofmusic.midi.examples;

import com.provinceofmusic.midi.MidiFile;
import com.provinceofmusic.midi.MidiTrack;
import com.provinceofmusic.midi.event.MidiEvent;
import com.provinceofmusic.midi.event.NoteOff;
import com.provinceofmusic.midi.event.NoteOn;
import com.provinceofmusic.midi.event.meta.Tempo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class MidiManipulation {
    public static void main(String[] args) {
        MidiFile mf = null;
        File input = new File("example.mid");
        try {
            mf = new MidiFile(input);
        }
        catch (IOException e) {
            System.err.println("Error parsing MIDI file:");
            e.printStackTrace();
            return;
        }
        MidiTrack T = mf.getTracks().get(1);
        Iterator<MidiEvent> it = T.getEvents().iterator();
        ArrayList<MidiEvent> eventsToRemove = new ArrayList<MidiEvent>();
        while (it.hasNext()) {
            MidiEvent midiEvent = it.next();
            if (midiEvent.getClass().equals(NoteOn.class) || midiEvent.getClass().equals(NoteOff.class)) continue;
            eventsToRemove.add(midiEvent);
        }
        for (MidiEvent midiEvent : eventsToRemove) {
            T.removeEvent(midiEvent);
        }
        mf.removeTrack(2);
        T = mf.getTracks().get(0);
        for (MidiEvent midiEvent : T.getEvents()) {
            if (!midiEvent.getClass().equals(Tempo.class)) continue;
            Tempo tempo = (Tempo)midiEvent;
            tempo.setBpm(tempo.getBpm() / 2.0f);
        }
        try {
            mf.writeToFile(input);
        }
        catch (IOException iOException) {
            System.err.println("Error writing MIDI file:");
            iOException.printStackTrace();
        }
    }
}

