/*
 * Decompiled with CFR 0.152.
 */
package com.provinceofmusic.midi.util;

import com.provinceofmusic.midi.event.MidiEvent;
import com.provinceofmusic.midi.event.meta.TimeSignature;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class MetronomeTick
extends MidiEvent {
    private int mResolution;
    private TimeSignature mSignature;
    private int mCurrentMeasure;
    private int mCurrentBeat;
    private double mMetronomeProgress;
    private int mMetronomeFrequency;

    public MetronomeTick(TimeSignature sig, int resolution) {
        super(0L, 0L);
        this.mResolution = resolution;
        this.setTimeSignature(sig);
        this.mCurrentMeasure = 1;
    }

    public void setTimeSignature(TimeSignature sig) {
        this.mSignature = sig;
        this.mCurrentBeat = 0;
        this.setMetronomeFrequency(sig.getMeter());
    }

    public boolean update(double ticksElapsed) {
        this.mMetronomeProgress += ticksElapsed;
        if (this.mMetronomeProgress >= (double)this.mMetronomeFrequency) {
            this.mMetronomeProgress %= (double)this.mMetronomeFrequency;
            this.mCurrentBeat = (this.mCurrentBeat + 1) % this.mSignature.getNumerator();
            if (this.mCurrentBeat == 0) {
                ++this.mCurrentMeasure;
            }
            return true;
        }
        return false;
    }

    public void setMetronomeFrequency(int meter) {
        switch (meter) {
            case 12: {
                this.mMetronomeFrequency = this.mResolution / 2;
                break;
            }
            case 24: {
                this.mMetronomeFrequency = this.mResolution;
                break;
            }
            case 48: {
                this.mMetronomeFrequency = this.mResolution * 2;
                break;
            }
            case 96: {
                this.mMetronomeFrequency = this.mResolution * 4;
            }
        }
    }

    public int getBeatNumber() {
        return this.mCurrentBeat + 1;
    }

    public int getMeasure() {
        return this.mCurrentMeasure;
    }

    @Override
    public String toString() {
        return "Metronome: " + this.mCurrentMeasure + "\t" + this.getBeatNumber();
    }

    @Override
    public int compareTo(MidiEvent o) {
        return 0;
    }

    @Override
    protected int getEventSize() {
        return 0;
    }

    @Override
    public int getSize() {
        return 0;
    }
}

