/*
 * Decompiled with CFR 0.152.
 */
package com.provinceofmusic.midi.util;

import com.provinceofmusic.midi.MidiFile;
import com.provinceofmusic.midi.MidiTrack;
import com.provinceofmusic.midi.event.MidiEvent;
import com.provinceofmusic.midi.event.meta.Tempo;
import com.provinceofmusic.midi.event.meta.TimeSignature;
import com.provinceofmusic.midi.util.MetronomeTick;
import com.provinceofmusic.midi.util.MidiEventListener;
import com.provinceofmusic.midi.util.MidiUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class MidiProcessor {
    private static final int PROCESS_RATE_MS = 8;
    private HashMap<Class<? extends MidiEvent>, List<MidiEventListener>> mEventsToListeners;
    private HashMap<MidiEventListener, List<Class<? extends MidiEvent>>> mListenersToEvents;
    private MidiFile mMidiFile;
    private boolean mRunning;
    private double mTicksElapsed;
    private long mMsElapsed;
    private int mMPQN;
    private int mPPQ;
    private MetronomeTick mMetronome;
    private MidiTrackEventQueue[] mEventQueues;

    public MidiProcessor(MidiFile input) {
        this.mMidiFile = input;
        this.mMPQN = 500000;
        this.mPPQ = this.mMidiFile.getResolution();
        this.mEventsToListeners = new HashMap();
        this.mListenersToEvents = new HashMap();
        this.mMetronome = new MetronomeTick(new TimeSignature(), this.mPPQ);
        this.reset();
    }

    public synchronized void start() {
        if (this.mRunning) {
            return;
        }
        this.mRunning = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                MidiProcessor.this.process();
            }
        }).start();
    }

    public void stop() {
        this.mRunning = false;
    }

    public void reset() {
        this.mRunning = false;
        this.mTicksElapsed = 0.0;
        this.mMsElapsed = 0L;
        this.mMetronome.setTimeSignature(new TimeSignature());
        List<MidiTrack> tracks = this.mMidiFile.getTracks();
        if (this.mEventQueues == null) {
            this.mEventQueues = new MidiTrackEventQueue[tracks.size()];
        }
        for (int i = 0; i < tracks.size(); ++i) {
            this.mEventQueues[i] = new MidiTrackEventQueue(this, tracks.get(i));
        }
    }

    public boolean isStarted() {
        return this.mTicksElapsed > 0.0;
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    protected void onStart(boolean fromBeginning) {
        for (MidiEventListener mel : this.mListenersToEvents.keySet()) {
            mel.onStart(fromBeginning);
        }
    }

    protected void onStop(boolean finished) {
        for (MidiEventListener mel : this.mListenersToEvents.keySet()) {
            mel.onStop(finished);
        }
    }

    public void registerEventListener(MidiEventListener mel, Class<? extends MidiEvent> event) {
        List<MidiEventListener> listeners = this.mEventsToListeners.get(event);
        if (listeners == null) {
            listeners = new ArrayList<MidiEventListener>();
            listeners.add(mel);
            this.mEventsToListeners.put(event, listeners);
        } else {
            listeners.add(mel);
        }
        List<Class<? extends MidiEvent>> events = this.mListenersToEvents.get(mel);
        if (events == null) {
            events = new ArrayList<Class<? extends MidiEvent>>();
            events.add(event);
            this.mListenersToEvents.put(mel, events);
        } else {
            events.add(event);
        }
    }

    public void unregisterEventListener(MidiEventListener mel) {
        List<Class<? extends MidiEvent>> events = this.mListenersToEvents.get(mel);
        if (events == null) {
            return;
        }
        for (Class<? extends MidiEvent> event : events) {
            List<MidiEventListener> listeners = this.mEventsToListeners.get(event);
            listeners.remove(mel);
        }
        this.mListenersToEvents.remove(mel);
    }

    public void unregisterEventListener(MidiEventListener mel, Class<? extends MidiEvent> event) {
        List<Class<? extends MidiEvent>> events;
        List<MidiEventListener> listeners = this.mEventsToListeners.get(event);
        if (listeners != null) {
            listeners.remove(mel);
        }
        if ((events = this.mListenersToEvents.get(mel)) != null) {
            events.remove(event);
        }
    }

    public void unregisterAllEventListeners() {
        this.mEventsToListeners.clear();
        this.mListenersToEvents.clear();
    }

    protected void dispatch(MidiEvent event) {
        if (event.getClass().equals(Tempo.class)) {
            this.mMPQN = ((Tempo)event).getMpqn();
        } else if (event.getClass().equals(TimeSignature.class)) {
            boolean shouldDispatch = this.mMetronome.getBeatNumber() != 1;
            this.mMetronome.setTimeSignature((TimeSignature)event);
            if (shouldDispatch) {
                this.dispatch(this.mMetronome);
            }
        }
        this.sendOnEventForClass(event, event.getClass());
        this.sendOnEventForClass(event, MidiEvent.class);
    }

    private void sendOnEventForClass(MidiEvent event, Class<? extends MidiEvent> eventClass) {
        List<MidiEventListener> listeners = this.mEventsToListeners.get(eventClass);
        if (listeners == null) {
            return;
        }
        for (MidiEventListener mel : listeners) {
            mel.onEvent(event, this.mMsElapsed);
        }
    }

    private void process() {
        this.onStart(this.mTicksElapsed < 1.0);
        long lastMs = System.currentTimeMillis();
        boolean finished = false;
        while (this.mRunning) {
            long now = System.currentTimeMillis();
            long msElapsed = now - lastMs;
            if (msElapsed < 8L) {
                try {
                    Thread.sleep(8L - msElapsed);
                }
                catch (Exception exception) {}
                continue;
            }
            double ticksElapsed = MidiUtil.msToTicks(msElapsed, this.mMPQN, this.mPPQ);
            if (ticksElapsed < 1.0) continue;
            if (this.mMetronome.update(ticksElapsed)) {
                this.dispatch(this.mMetronome);
            }
            lastMs = now;
            this.mMsElapsed += msElapsed;
            this.mTicksElapsed += ticksElapsed;
            boolean more = false;
            for (int i = 0; i < this.mEventQueues.length; ++i) {
                MidiTrackEventQueue queue = this.mEventQueues[i];
                if (!queue.hasMoreEvents()) continue;
                ArrayList<MidiEvent> events = queue.getNextEventsUpToTick(this.mTicksElapsed);
                for (MidiEvent event : events) {
                    this.dispatch(event);
                }
                if (!queue.hasMoreEvents()) continue;
                more = true;
            }
            if (more) continue;
            finished = true;
            break;
        }
        this.mRunning = false;
        this.onStop(finished);
    }

    @Environment(value=EnvType.CLIENT)
    private class MidiTrackEventQueue {
        private MidiTrack mTrack;
        private Iterator<MidiEvent> mIterator;
        private ArrayList<MidiEvent> mEventsToDispatch;
        private MidiEvent mNext;

        public MidiTrackEventQueue(MidiProcessor midiProcessor, MidiTrack track) {
            this.mTrack = track;
            this.mIterator = this.mTrack.getEvents().iterator();
            this.mEventsToDispatch = new ArrayList();
            if (this.mIterator.hasNext()) {
                this.mNext = this.mIterator.next();
            }
        }

        public ArrayList<MidiEvent> getNextEventsUpToTick(double tick) {
            this.mEventsToDispatch.clear();
            while (this.mNext != null && (double)this.mNext.getTick() <= tick) {
                this.mEventsToDispatch.add(this.mNext);
                if (this.mIterator.hasNext()) {
                    this.mNext = this.mIterator.next();
                    continue;
                }
                this.mNext = null;
            }
            return this.mEventsToDispatch;
        }

        public boolean hasMoreEvents() {
            return this.mNext != null;
        }
    }
}

