/*
 * Decompiled with CFR 0.152.
 */
package com.provinceofmusic.midi.util;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class MidiUtil {
    private static final String HEX = "0123456789ABCDEF";

    public static long ticksToMs(long ticks, int mpqn, int resolution) {
        return ticks * (long)mpqn / (long)resolution / 1000L;
    }

    public static long ticksToMs(long ticks, float bpm, int resolution) {
        return MidiUtil.ticksToMs(ticks, MidiUtil.bpmToMpqn(bpm), resolution);
    }

    public static double msToTicks(long ms, int mpqn, int ppq) {
        return (double)ms * 1000.0 * (double)ppq / (double)mpqn;
    }

    public static double msToTicks(long ms, float bpm, int ppq) {
        return MidiUtil.msToTicks(ms, MidiUtil.bpmToMpqn(bpm), ppq);
    }

    public static int bpmToMpqn(float bpm) {
        return (int)(bpm * 6.0E7f);
    }

    public static float mpqnToBpm(int mpqn) {
        return (float)mpqn / 6.0E7f;
    }

    public static int bytesToInt(byte[] buff, int off, int len) {
        int num = 0;
        int shift = 0;
        for (int i = off + len - 1; i >= off; --i) {
            num += (buff[i] & 0xFF) << shift;
            shift += 8;
        }
        return num;
    }

    public static byte[] intToBytes(int val, int byteCount) {
        byte[] buffer = new byte[byteCount];
        int[] ints = new int[byteCount];
        for (int i = 0; i < byteCount; ++i) {
            ints[i] = val & 0xFF;
            buffer[byteCount - i - 1] = (byte)ints[i];
            if ((val >>= 8) == 0) break;
        }
        return buffer;
    }

    public static boolean bytesEqual(byte[] buf1, byte[] buf2, int off, int len) {
        for (int i = off; i < off + len; ++i) {
            if (i >= buf1.length || i >= buf2.length) {
                return false;
            }
            if (buf1[i] == buf2[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] extractBytes(byte[] buffer, int off, int len) {
        byte[] ret = new byte[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = buffer[off + i];
        }
        return ret;
    }

    public static String byteToHex(byte b) {
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        return "" + HEX.charAt(high) + HEX.charAt(low);
    }

    public static String bytesToHex(byte[] b) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            sb.append(MidiUtil.byteToHex(b[i])).append(" ");
        }
        return sb.toString();
    }
}

