/*
 * Decompiled with CFR 0.152.
 */
package com.provinceofmusic.midi.util;

import com.provinceofmusic.midi.util.MidiUtil;
import java.io.IOException;
import java.io.InputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class VariableLengthInt {
    private int mValue;
    private byte[] mBytes;
    private int mSizeInBytes;

    public VariableLengthInt(int value) {
        this.setValue(value);
    }

    public VariableLengthInt(InputStream in) throws IOException {
        this.parseBytes(in);
    }

    public void setValue(int value) {
        this.mValue = value;
        this.buildBytes();
    }

    public int getValue() {
        return this.mValue;
    }

    public int getByteCount() {
        return this.mSizeInBytes;
    }

    public byte[] getBytes() {
        return this.mBytes;
    }

    private void parseBytes(InputStream in) throws IOException {
        int i;
        int[] ints = new int[4];
        this.mSizeInBytes = 0;
        this.mValue = 0;
        int shift = 0;
        int b = in.read();
        while (this.mSizeInBytes < 4) {
            boolean variable;
            ++this.mSizeInBytes;
            boolean bl = variable = (b & 0x80) > 0;
            if (!variable) {
                ints[this.mSizeInBytes - 1] = b & 0x7F;
                break;
            }
            ints[this.mSizeInBytes - 1] = b & 0x7F;
            b = in.read();
        }
        for (i = 1; i < this.mSizeInBytes; ++i) {
            shift += 7;
        }
        this.mBytes = new byte[this.mSizeInBytes];
        for (i = 0; i < this.mSizeInBytes; ++i) {
            this.mBytes[i] = (byte)ints[i];
            this.mValue += ints[i] << shift;
            shift -= 7;
        }
    }

    private void buildBytes() {
        if (this.mValue == 0) {
            this.mBytes = new byte[1];
            this.mBytes[0] = 0;
            this.mSizeInBytes = 1;
            return;
        }
        this.mSizeInBytes = 0;
        int[] vals = new int[4];
        for (int tmpVal = this.mValue; this.mSizeInBytes < 4 && tmpVal > 0; tmpVal >>= 7) {
            vals[this.mSizeInBytes] = tmpVal & 0x7F;
            ++this.mSizeInBytes;
        }
        int i = 1;
        while (i < this.mSizeInBytes) {
            int n = i++;
            vals[n] = vals[n] | 0x80;
        }
        this.mBytes = new byte[this.mSizeInBytes];
        for (i = 0; i < this.mSizeInBytes; ++i) {
            this.mBytes[i] = (byte)vals[this.mSizeInBytes - i - 1];
        }
    }

    public String toString() {
        return MidiUtil.bytesToHex(this.mBytes) + " (" + this.mValue + ")";
    }
}

