/*
 * Decompiled with CFR 0.152.
 */
package com.provinceofmusic.recorder;

import com.provinceofmusic.jukebox.NoteSoundMidi;
import com.provinceofmusic.jukebox.NoteSoundMinecraft;
import com.provinceofmusic.midi.MidiFile;
import com.provinceofmusic.midi.MidiTrack;
import com.provinceofmusic.midi.event.meta.Tempo;
import com.provinceofmusic.midi.event.meta.TimeSignature;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ConvertToMidi {
    public static void convert(File inputFile, String outputPath) {
        ArrayList<String> types = new ArrayList<String>();
        ArrayList<String> ticks = new ArrayList<String>();
        ArrayList<String> pitches = new ArrayList<String>();
        ArrayList<String> volumes = new ArrayList<String>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(inputFile));
            while ((line = reader.readLine()) != null) {
                String[] values = line.split(",");
                types.add(values[0]);
                ticks.add(values[1]);
                pitches.add(values[2]);
                volumes.add(values[3]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        MidiTrack tempoTrack = new MidiTrack();
        MidiTrack noteTrack = new MidiTrack();
        TimeSignature ts = new TimeSignature();
        ts.setTimeSignature(4, 4, 24, 8);
        Tempo tempo = new Tempo();
        tempo.setBpm(100.0f);
        tempoTrack.insertEvent(ts);
        tempoTrack.insertEvent(tempo);
        int currentTick = 0;
        for (int i = 0; i < types.size(); ++i) {
            NoteSoundMinecraft noteSoundMinecraft = new NoteSoundMinecraft((String)types.get(i), Integer.parseInt((String)ticks.get(i)), Float.parseFloat((String)pitches.get(i)), Float.parseFloat((String)volumes.get(i)));
            NoteSoundMidi noteSoundMidi = new NoteSoundMidi(noteSoundMinecraft);
            currentTick += noteSoundMidi.ticksPassed;
            assert (noteSoundMidi.instrument != null);
            int insertNoteChannel = noteSoundMidi.instrument.exportChannel;
            int insertNotePitch = Math.round(noteSoundMidi.pitch);
            int insertNoteVelocity = noteSoundMidi.volume;
            int insertNoteTick = currentTick * 40;
            int insertNoteDuration = 120;
            noteTrack.insertNote(insertNoteChannel, insertNotePitch, insertNoteVelocity, insertNoteTick, insertNoteDuration);
        }
        ArrayList<MidiTrack> tracks = new ArrayList<MidiTrack>();
        tracks.add(tempoTrack);
        tracks.add(noteTrack);
        MidiFile midi = new MidiFile(480, tracks);
        File output = new File(outputPath + ".mid");
        try {
            midi.writeToFile(output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

