/*
 * Decompiled with CFR 0.152.
 */
package com.provinceofmusic.recorder;

import com.provinceofmusic.ProvinceOfMusicClient;
import com.provinceofmusic.jukebox.NoteSoundMinecraft;
import com.provinceofmusic.listeners.NoteListener;
import com.provinceofmusic.listeners.NoteListenerHelper;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_2561;
import net.minecraft.class_304;

@Environment(value=EnvType.CLIENT)
public class MusicRecorder
implements NoteListener {
    private static int time_passed = 0;
    private static boolean is_writing_to_file = false;
    private static Path file_to_write;
    public static class_304 recordBinding;

    @Override
    public void onNotePlayed(NoteSoundMinecraft note) {
        if (!is_writing_to_file) {
            return;
        }
        try {
            FileWriter myWriter = new FileWriter(file_to_write.toString(), true);
            myWriter.append(note.instrument + "," + time_passed + "," + note.pitch + "," + note.volume + "\n");
            myWriter.close();
        }
        catch (IOException e) {
            ProvinceOfMusicClient.LOGGER.error("Error writing to file " + String.valueOf(file_to_write) + ".");
            throw new RuntimeException(e);
        }
        time_passed = 0;
    }

    public void PassTime() {
        if (is_writing_to_file) {
            ++time_passed;
        }
    }

    public void main() {
        NoteListenerHelper.addListener(this);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (recordBinding.method_1436()) {
                boolean bl = is_writing_to_file = !is_writing_to_file;
                assert (client.field_1724 != null);
                if (is_writing_to_file) {
                    file_to_write = Path.of(String.valueOf(ProvinceOfMusicClient.recordedmusicdir) + "/" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss")) + ".csv", new String[0]);
                    ProvinceOfMusicClient.LOGGER.info("Started recording to file " + String.valueOf(file_to_write) + ".");
                    client.field_1724.method_7353(class_2561.method_30163((String)("Started recording to file " + String.valueOf(file_to_write) + ".")), false);
                    continue;
                }
                time_passed = 0;
                ProvinceOfMusicClient.LOGGER.info("Stopped recording to file " + String.valueOf(file_to_write) + ".");
                client.field_1724.method_7353(class_2561.method_30163((String)("Stopped recording to file " + String.valueOf(file_to_write) + ".")), false);
            }
        });
    }
}

