/*
 * Decompiled with CFR 0.152.
 */
package com.provinceofmusic.screen;

import com.provinceofmusic.ProvinceOfMusicClient;
import com.provinceofmusic.jukebox.InstrumentDef;
import com.provinceofmusic.jukebox.SamplePack;
import com.provinceofmusic.screen.SamplePackConfig;
import com.provinceofmusic.ui.InstrumentWidget;
import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.client.CottonClientScreen;
import io.github.cottonmc.cotton.gui.client.LightweightGuiDescription;
import io.github.cottonmc.cotton.gui.widget.WButton;
import io.github.cottonmc.cotton.gui.widget.WGridPanel;
import io.github.cottonmc.cotton.gui.widget.WLabel;
import io.github.cottonmc.cotton.gui.widget.WListPanel;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WTextField;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.Insets;
import java.awt.Desktop;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class SamplePackEditor
extends LightweightGuiDescription {
    public SamplePack thisPack;
    WListPanel instrumentList;
    public ArrayList<InstrumentWidget> instrumentWidgets = new ArrayList();
    WTextField nameField;
    WTextField authorField;

    public SamplePackEditor(SamplePack inPack) {
        this.thisPack = inPack;
        WGridPanel root = new WGridPanel();
        this.setRootPanel((WPanel)root);
        root.setSize(356, 200 * (4 - ProvinceOfMusicClient.guiSize));
        root.setInsets(Insets.ROOT_PANEL);
        WLabel title = new WLabel((class_2561)class_2561.method_43470((String)"Sample Pack Editor"), 0);
        root.add((WWidget)title, 0, 0, 9, 3);
        WButton deletePackButton = new WButton((class_2561)class_2561.method_43470((String)"Delete Pack").method_54663(0xFF0000).method_27694(style -> style.method_10982(Boolean.valueOf(true))));
        Runnable deletePackButtonRunnable = () -> {
            this.SaveChanges();
            if (ProvinceOfMusicClient.configSettings.activeSamplePack != null && ProvinceOfMusicClient.configSettings.activeSamplePack.equals(this.thisPack.name)) {
                ProvinceOfMusicClient.configSettings.activeSamplePack = null;
                ProvinceOfMusicClient.saveConfigSettings();
            }
            SamplePack.DeletePack(this.thisPack.name);
            this.BackOutToPreviousScreen();
        };
        root.add((WWidget)deletePackButton, 8, 0, 5, 1);
        deletePackButton.setOnClick(deletePackButtonRunnable);
        WButton openFolderButton = new WButton((class_2561)class_2561.method_43470((String)"Open Folder \ud83d\uddc1"));
        root.add((WWidget)openFolderButton, 14, 1, 5, 1);
        Runnable openFolderButtonRunnable = () -> {
            try {
                Desktop.getDesktop().open(new File(Path.of(String.valueOf(ProvinceOfMusicClient.samplepacksdir) + "/" + this.thisPack.name, new String[0]).toString()).getAbsoluteFile());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        openFolderButton.setOnClick(openFolderButtonRunnable);
        WButton backButton = new WButton((class_2561)class_2561.method_43470((String)"Back \u21b6"));
        Runnable backButtonRunnable = () -> this.BackOutToPreviousScreen();
        root.add((WWidget)backButton, 1, 3, 3, 1);
        backButton.setOnClick(backButtonRunnable);
        WButton changeImageButton = new WButton((class_2561)class_2561.method_43470((String)"Change Img"));
        root.add((WWidget)changeImageButton, 4, 3, 4, 1);
        Runnable changeImageButtonRunnable = () -> {
            FileDialog dialog = new FileDialog((Frame)null, "Select File to Open");
            dialog.setFile("*.png");
            dialog.setMode(0);
            dialog.setVisible(true);
            if (dialog.getFiles()[0] != null && dialog.getFiles()[0].exists()) {
                File file = dialog.getFiles()[0];
                try {
                    if (new File(Path.of(String.valueOf(SamplePack.getSamplePackAsFile(this.thisPack.name).toPath()) + "/icon.png", new String[0]).toString()).exists()) {
                        Files.delete(Path.of(String.valueOf(SamplePack.getSamplePackAsFile(this.thisPack.name).toPath()) + "/icon.png", new String[0]));
                    }
                    Files.copy(file.toPath(), Path.of(String.valueOf(SamplePack.getSamplePackAsFile(this.thisPack.name).toPath()) + "/icon.png", new String[0]), new CopyOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                dialog.dispose();
            }
        };
        changeImageButton.setOnClick(changeImageButtonRunnable);
        WLabel nameLabel = new WLabel((class_2561)class_2561.method_43470((String)"Name"), 0);
        root.add((WWidget)nameLabel, 1, 1, 5, 1);
        this.nameField = new WTextField();
        this.nameField.setMaxLength(1000);
        this.nameField.setText(this.thisPack.name);
        root.add((WWidget)this.nameField, 1, 2, 5, 1);
        WLabel authorLabel = new WLabel((class_2561)class_2561.method_43470((String)"Author"), 0);
        root.add((WWidget)authorLabel, 7, 1, 5, 1);
        this.authorField = new WTextField();
        this.authorField.setMaxLength(1000);
        this.authorField.setText(this.thisPack.author);
        root.add((WWidget)this.authorField, 7, 2, 5, 1);
        ArrayList<InstrumentDef> data = new ArrayList<InstrumentDef>();
        for (int i = 0; i < this.thisPack.instrumentDefs.size(); ++i) {
            data.add(this.thisPack.instrumentDefs.get(i));
        }
        BiConsumer<InstrumentDef, InstrumentWidget> configurator = (s, destination) -> {
            destination.instrumentDirectory.setText(s.dir);
            destination.volume.setText("" + s.volume);
            destination.noteType.setText(s.noteType);
            destination.transpose.setText("" + s.transpose);
            destination.screen = this;
            destination.instrument = s;
            destination.index = data.indexOf(s);
            destination.singlePitchToggle.setToggle(s.singlePitch);
            this.instrumentWidgets.add((InstrumentWidget)((Object)destination));
        };
        this.instrumentList = new WListPanel(data, InstrumentWidget::new, configurator);
        this.instrumentList.setListItemHeight(66);
        if (ProvinceOfMusicClient.guiSize == 3) {
            root.add((WWidget)this.instrumentList, 0, 4, 19, 8);
        } else {
            root.add((WWidget)this.instrumentList, 0, 5, 19, 17);
        }
        WButton saveChangesButton = new WButton((class_2561)class_2561.method_43470((String)"Save Changes \ud83d\uddab").method_27694(style -> style.method_10982(Boolean.valueOf(true))));
        Runnable saveChangesButtonRunnable = () -> {
            this.SaveChanges();
            WLabel savedPopup = new WLabel((class_2561)class_2561.method_43470((String)"Changes Saved").method_27694(style -> style.method_10978(Boolean.valueOf(true))), 0);
            root.add((WWidget)savedPopup, 13, 2, 2, 1);
            Thread t = new Thread(() -> {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                root.remove((WWidget)savedPopup);
            });
            t.start();
        };
        saveChangesButton.setOnClick(saveChangesButtonRunnable);
        root.add((WWidget)saveChangesButton, 8, 3, 6, 1);
        WButton addNewButton = new WButton((class_2561)class_2561.method_43470((String)"+"));
        root.add((WWidget)addNewButton, 0, 3, 1, 1);
        Runnable addNewButtonRunnable = () -> {
            this.copyChangesToCache();
            InstrumentDef temp = new InstrumentDef("null", "null", 0, 1.0f, false);
            this.thisPack.instrumentDefs.add(temp);
            class_310.method_1551().method_1507((class_437)new CottonClientScreen((GuiDescription)new SamplePackEditor(this.thisPack)));
        };
        addNewButton.setOnClick(addNewButtonRunnable);
    }

    public void copyChangesToCache() {
        for (InstrumentWidget ins : this.instrumentWidgets) {
            InstrumentDef temp = new InstrumentDef(ins.instrumentDirectory.getText(), ins.noteType.getText(), ins.transpose.getInt(), ins.volume.getFloat(), ins.singlePitchToggle.getToggle());
            this.thisPack.instrumentDefs.set(ins.index, temp);
        }
    }

    public void SaveChanges() {
        this.copyChangesToCache();
        String nameCache = this.thisPack.name;
        SamplePack.RenameSamplePack(this.thisPack, this.nameField.getText());
        this.thisPack.author = this.authorField.getText();
        this.thisPack.name = this.nameField.getText();
        this.thisPack.WriteSamplePack();
        if (ProvinceOfMusicClient.configSettings.activeSamplePack != null && (ProvinceOfMusicClient.configSettings.activeSamplePack.equals(this.thisPack.name) || ProvinceOfMusicClient.configSettings.activeSamplePack.equals(nameCache))) {
            ProvinceOfMusicClient.configSettings.activeSamplePack = this.thisPack.name;
            ProvinceOfMusicClient.saveConfigSettings();
        }
    }

    public void BackOutToPreviousScreen() {
        class_310.method_1551().method_1507((class_437)new CottonClientScreen((GuiDescription)new SamplePackConfig()));
    }
}

