/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker;

import dev.rosewood.rosestacker.config.SettingKey;
import dev.rosewood.rosestacker.hook.RoseStackerPlaceholderExpansion;
import dev.rosewood.rosestacker.hook.ShopGuiPlusHook;
import dev.rosewood.rosestacker.hook.WildChestsStackerProvider;
import dev.rosewood.rosestacker.hook.WorldGuardHook;
import dev.rosewood.rosestacker.lib.rosegarden.RosePlugin;
import dev.rosewood.rosestacker.lib.rosegarden.config.SettingHolder;
import dev.rosewood.rosestacker.lib.rosegarden.manager.Manager;
import dev.rosewood.rosestacker.lib.rosegarden.utils.NMSUtil;
import dev.rosewood.rosestacker.listener.BeeListener;
import dev.rosewood.rosestacker.listener.BlockListener;
import dev.rosewood.rosestacker.listener.BreedingListener;
import dev.rosewood.rosestacker.listener.EntitiesLoadListener;
import dev.rosewood.rosestacker.listener.EntityListener;
import dev.rosewood.rosestacker.listener.InteractListener;
import dev.rosewood.rosestacker.listener.ItemListener;
import dev.rosewood.rosestacker.listener.SkyblockHookListener;
import dev.rosewood.rosestacker.listener.StackToolListener;
import dev.rosewood.rosestacker.listener.WorldListener;
import dev.rosewood.rosestacker.manager.CommandManager;
import dev.rosewood.rosestacker.manager.EntityCacheManager;
import dev.rosewood.rosestacker.manager.HologramManager;
import dev.rosewood.rosestacker.manager.LocaleManager;
import dev.rosewood.rosestacker.manager.StackManager;
import dev.rosewood.rosestacker.manager.StackSettingManager;
import dev.rosewood.rosestacker.nms.NMSAdapter;
import dev.rosewood.rosestacker.utils.StackerUtils;
import dev.rosewood.rosestacker.utils.ThreadUtils;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class RoseStacker
extends RosePlugin {
    private static RoseStacker instance;

    public static RoseStacker getInstance() {
        return instance;
    }

    public RoseStacker() {
        super(82729, 5517, null, LocaleManager.class, CommandManager.class);
        instance = this;
    }

    @Override
    public void onLoad() {
        if (!NMSAdapter.isValidVersion()) {
            this.getLogger().severe(String.format("RoseStacker only supports %s through %s. The plugin has been disabled.", "1.16.5", "1.21.10"));
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        WorldGuardHook.registerFlag();
    }

    @Override
    public void enable() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        pluginManager.registerEvents((Listener)new BlockListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new WorldListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new EntityListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new InteractListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new ItemListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new StackToolListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new BreedingListener(this), (Plugin)this);
        pluginManager.registerEvents((Listener)new BeeListener(this), (Plugin)this);
        if (NMSUtil.getVersionNumber() >= 17) {
            try {
                Class.forName("org.bukkit.event.world.EntitiesLoadEvent");
                pluginManager.registerEvents((Listener)new EntitiesLoadListener(this), (Plugin)this);
            }
            catch (ClassNotFoundException e) {
                this.getLogger().severe("Your version of 1.17 is VERY OUTDATED! Stacked entities and items WILL NOT LOAD until you update!");
            }
        }
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new RoseStackerPlaceholderExpansion(this).register();
        }
        ThreadUtils.runSync(() -> {
            SkyblockHookListener skyblockHookListener;
            if (Bukkit.getPluginManager().isPluginEnabled("ShopGUIPlus")) {
                ShopGuiPlusHook.setupSpawners(this);
            }
            if ((skyblockHookListener = new SkyblockHookListener()).isEnabled()) {
                pluginManager.registerEvents((Listener)skyblockHookListener, (Plugin)this);
            }
        });
        if (Bukkit.getPluginManager().isPluginEnabled("WildChests")) {
            WildChestsStackerProvider.register();
        }
    }

    @Override
    public void reload() {
        super.reload();
        StackerUtils.clearCache();
    }

    @Override
    public void disable() {
        this.getScheduler().cancelAllTasks();
    }

    @Override
    protected List<Class<? extends Manager>> getManagerLoadPriority() {
        return List.of(HologramManager.class, StackSettingManager.class, CommandManager.class, EntityCacheManager.class, StackManager.class);
    }

    @Override
    protected SettingHolder getRoseConfigSettingHolder() {
        return SettingKey.INSTANCE;
    }

    @Override
    protected String[] getRoseConfigHeader() {
        return new String[]{"     __________                      _________ __                 __                 ", "     \\______   \\ ____  ______ ____  /   _____//  |______    ____ |  | __ ___________ ", "      |       _//  _ \\/  ___// __ \\ \\_____  \\\\   __\\__  \\ _/ ___\\|  |/ // __ \\_  __ \\", "      |    |   (  <_> )___ \\\\  ___/ /        \\|  |  / __ \\\\  \\___|    <\\  ___/|  | \\/", "      |____|_  /\\____/____  >\\___  >_______  /|__| (____  /\\___  >__|_ \\\\___  >__|   ", "             \\/           \\/     \\/        \\/           \\/     \\/     \\/    \\/       "};
    }
}

