/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.api;

import com.google.common.base.Preconditions;
import dev.rosewood.rosestacker.RoseStacker;
import dev.rosewood.rosestacker.config.SettingKey;
import dev.rosewood.rosestacker.event.EntityStackMultipleDeathEvent;
import dev.rosewood.rosestacker.manager.StackManager;
import dev.rosewood.rosestacker.manager.StackSettingManager;
import dev.rosewood.rosestacker.stack.StackedBlock;
import dev.rosewood.rosestacker.stack.StackedEntity;
import dev.rosewood.rosestacker.stack.StackedItem;
import dev.rosewood.rosestacker.stack.StackedSpawner;
import dev.rosewood.rosestacker.stack.StackingThread;
import dev.rosewood.rosestacker.stack.settings.BlockStackSettings;
import dev.rosewood.rosestacker.stack.settings.EntityStackSettings;
import dev.rosewood.rosestacker.stack.settings.ItemStackSettings;
import dev.rosewood.rosestacker.stack.settings.SpawnerStackSettings;
import dev.rosewood.rosestacker.utils.EntityUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RoseStackerAPI {
    private static RoseStackerAPI instance;
    private final RoseStacker roseStacker = RoseStacker.getInstance();

    private RoseStackerAPI() {
    }

    @NotNull
    public static RoseStackerAPI getInstance() {
        if (instance == null) {
            instance = new RoseStackerAPI();
        }
        return instance;
    }

    @NotNull
    public String getVersion() {
        return this.roseStacker.getDescription().getVersion();
    }

    public boolean isEntityStackMultipleDeathEventCalled() {
        return SettingKey.ENTITY_TRIGGER_DEATH_EVENT_FOR_ENTIRE_STACK_KILL.get() == false;
    }

    @Nullable
    public StackingThread getStackingThread(@NotNull World world) {
        Objects.requireNonNull(world);
        return this.roseStacker.getManager(StackManager.class).getStackingThread(world);
    }

    @NotNull
    public Map<UUID, StackingThread> getStackingThreads() {
        return Collections.unmodifiableMap(this.roseStacker.getManager(StackManager.class).getStackingThreads());
    }

    @NotNull
    public Map<UUID, StackedEntity> getStackedEntities() {
        return Collections.unmodifiableMap(this.roseStacker.getManager(StackManager.class).getStackedEntities());
    }

    @NotNull
    public Map<UUID, StackedItem> getStackedItems() {
        return Collections.unmodifiableMap(this.roseStacker.getManager(StackManager.class).getStackedItems());
    }

    @NotNull
    public Map<Block, StackedBlock> getStackedBlocks() {
        return Collections.unmodifiableMap(this.roseStacker.getManager(StackManager.class).getStackedBlocks());
    }

    @NotNull
    public Map<Block, StackedSpawner> getStackedSpawners() {
        return Collections.unmodifiableMap(this.roseStacker.getManager(StackManager.class).getStackedSpawners());
    }

    @Nullable
    public StackedEntity getStackedEntity(@NotNull LivingEntity livingEntity) {
        Objects.requireNonNull(livingEntity);
        return this.roseStacker.getManager(StackManager.class).getStackedEntity(livingEntity);
    }

    @Nullable
    public StackedItem getStackedItem(@NotNull Item item) {
        Objects.requireNonNull(item);
        return this.roseStacker.getManager(StackManager.class).getStackedItem(item);
    }

    @Nullable
    public StackedBlock getStackedBlock(@NotNull Block block) {
        Objects.requireNonNull(block);
        return this.roseStacker.getManager(StackManager.class).getStackedBlock(block);
    }

    @Nullable
    public StackedSpawner getStackedSpawner(@NotNull Block block) {
        Objects.requireNonNull(block);
        return this.roseStacker.getManager(StackManager.class).getStackedSpawner(block);
    }

    public boolean isEntityStacked(@NotNull LivingEntity livingEntity) {
        Objects.requireNonNull(livingEntity);
        return this.roseStacker.getManager(StackManager.class).isEntityStacked(livingEntity);
    }

    public boolean isItemStacked(@NotNull Item item) {
        Objects.requireNonNull(item);
        return this.roseStacker.getManager(StackManager.class).isItemStacked(item);
    }

    public boolean isBlockStacked(@NotNull Block block) {
        Objects.requireNonNull(block);
        return this.roseStacker.getManager(StackManager.class).isBlockStacked(block);
    }

    public boolean isSpawnerStacked(@NotNull Block block) {
        Objects.requireNonNull(block);
        return this.roseStacker.getManager(StackManager.class).isSpawnerStacked(block);
    }

    public void removeEntityStack(@NotNull StackedEntity stackedEntity) {
        Objects.requireNonNull(stackedEntity);
        this.roseStacker.getManager(StackManager.class).removeEntityStack(stackedEntity);
    }

    public void removeItemStack(@NotNull StackedItem stackedItem) {
        Objects.requireNonNull(stackedItem);
        this.roseStacker.getManager(StackManager.class).removeItemStack(stackedItem);
    }

    public void removeBlockStack(@NotNull StackedBlock stackedBlock) {
        Objects.requireNonNull(stackedBlock);
        this.roseStacker.getManager(StackManager.class).removeBlockStack(stackedBlock);
    }

    public void removeSpawnerStack(@NotNull StackedSpawner stackedSpawner) {
        Objects.requireNonNull(stackedSpawner);
        this.roseStacker.getManager(StackManager.class).removeSpawnerStack(stackedSpawner);
    }

    public int removeAllEntityStacks() {
        return this.roseStacker.getManager(StackManager.class).removeAllEntityStacks();
    }

    public int removeAllItemStacks() {
        return this.roseStacker.getManager(StackManager.class).removeAllItemStacks();
    }

    @Nullable
    public StackedEntity createEntityStack(@NotNull LivingEntity livingEntity, boolean tryStack) {
        Objects.requireNonNull(livingEntity);
        return this.roseStacker.getManager(StackManager.class).createEntityStack(livingEntity, tryStack);
    }

    @Nullable
    public StackedItem createItemStack(@NotNull Item item, boolean tryStack) {
        Objects.requireNonNull(item);
        return this.roseStacker.getManager(StackManager.class).createItemStack(item, tryStack);
    }

    @Nullable
    public StackedBlock createBlockStack(@NotNull Block block, int amount) {
        Objects.requireNonNull(block);
        return this.roseStacker.getManager(StackManager.class).createBlockStack(block, amount);
    }

    @Nullable
    public StackedSpawner createSpawnerStack(@NotNull Block block, int amount, boolean placedByPlayer) {
        Objects.requireNonNull(block);
        return this.roseStacker.getManager(StackManager.class).createSpawnerStack(block, amount, placedByPlayer);
    }

    @Nullable
    public StackedSpawner createSpawnerStack(@NotNull Block block, int amount) {
        return this.createSpawnerStack(block, amount, false);
    }

    public void preStackEntities(@NotNull EntityType entityType, int amount, @NotNull Location location, @NotNull CreatureSpawnEvent.SpawnReason spawnReason) {
        Objects.requireNonNull(entityType);
        Objects.requireNonNull(location);
        Objects.requireNonNull(spawnReason);
        this.roseStacker.getManager(StackManager.class).preStackEntities(entityType, amount, location, spawnReason);
    }

    public void preStackEntities(@NotNull EntityType entityType, int amount, @NotNull Location location) {
        Objects.requireNonNull(entityType);
        Objects.requireNonNull(location);
        this.roseStacker.getManager(StackManager.class).preStackEntities(entityType, amount, location);
    }

    public void preStackItems(@NotNull Collection<ItemStack> items, Location location) {
        Objects.requireNonNull(items);
        this.roseStacker.getManager(StackManager.class).preStackItems(items, location);
    }

    @Nullable
    public StackedItem dropItemStack(@NotNull ItemStack itemStack, int amount, @NotNull Location location, boolean dropNaturally) {
        Objects.requireNonNull(itemStack);
        Objects.requireNonNull(location);
        return this.roseStacker.getManager(StackManager.class).dropItemStack(itemStack, amount, location, dropNaturally);
    }

    @NotNull
    public EntityStackSettings getEntityStackSettings(@NotNull LivingEntity entity) {
        Objects.requireNonNull(entity);
        return this.getEntityStackSettings(entity.getType());
    }

    @NotNull
    public EntityStackSettings getEntityStackSettings(@NotNull EntityType entityType) {
        Objects.requireNonNull(entityType);
        return this.roseStacker.getManager(StackSettingManager.class).getEntityStackSettings(entityType);
    }

    @Nullable
    public EntityStackSettings getEntityStackSettings(@NotNull Material material) {
        Objects.requireNonNull(material);
        return this.roseStacker.getManager(StackSettingManager.class).getEntityStackSettings(material);
    }

    @NotNull
    public ItemStackSettings getItemStackSettings(@NotNull Item item) {
        Objects.requireNonNull(item);
        return this.getItemStackSettings(item.getItemStack().getType());
    }

    @NotNull
    public ItemStackSettings getItemStackSettings(@NotNull Material material) {
        Objects.requireNonNull(material);
        return this.roseStacker.getManager(StackSettingManager.class).getItemStackSettings(material);
    }

    @Nullable
    public BlockStackSettings getBlockStackSettings(@NotNull Block block) {
        Objects.requireNonNull(block);
        return this.getBlockStackSettings(block.getType());
    }

    @Nullable
    public BlockStackSettings getBlockStackSettings(@NotNull Material material) {
        Objects.requireNonNull(material);
        return this.roseStacker.getManager(StackSettingManager.class).getBlockStackSettings(material);
    }

    @Nullable
    public SpawnerStackSettings getSpawnerStackSettings(@NotNull CreatureSpawner creatureSpawner) {
        Objects.requireNonNull(creatureSpawner);
        return this.roseStacker.getManager(StackSettingManager.class).getSpawnerStackSettings(creatureSpawner);
    }

    @Nullable
    public SpawnerStackSettings getSpawnerStackSettings(@NotNull EntityType entityType) {
        Objects.requireNonNull(entityType);
        return this.roseStacker.getManager(StackSettingManager.class).getSpawnerStackSettings(entityType);
    }

    @Deprecated
    @NotNull
    public CompletableFuture<Set<StackedEntity>> getChunkEntityStacks(@NotNull Collection<Chunk> chunks) {
        return CompletableFuture.completedFuture(new HashSet<StackedEntity>(this.getStackedEntities(chunks)));
    }

    @Deprecated
    @NotNull
    public CompletableFuture<Set<StackedItem>> getChunkItemStacks(@NotNull Collection<Chunk> chunks) {
        return CompletableFuture.completedFuture(new HashSet<StackedItem>(this.getStackedItems(chunks)));
    }

    @Deprecated
    @NotNull
    public CompletableFuture<Set<StackedBlock>> getChunkBlockStacks(@NotNull Collection<Chunk> chunks) {
        return CompletableFuture.completedFuture(new HashSet<StackedBlock>(this.getStackedBlocks(chunks)));
    }

    @Deprecated
    @NotNull
    public CompletableFuture<Set<StackedSpawner>> getChunkSpawnerStacks(@NotNull Collection<Chunk> chunks) {
        return CompletableFuture.completedFuture(new HashSet<StackedSpawner>(this.getStackedSpawners(chunks)));
    }

    @NotNull
    public List<StackedEntity> getStackedEntities(@NotNull Collection<Chunk> chunks) {
        Objects.requireNonNull(chunks);
        return this.roseStacker.getManager(StackManager.class).getStackedEntities().values().stream().filter(x -> chunks.contains(x.getLocation().getChunk())).toList();
    }

    @NotNull
    public List<StackedItem> getStackedItems(@NotNull Collection<Chunk> chunks) {
        Objects.requireNonNull(chunks);
        return this.roseStacker.getManager(StackManager.class).getStackedItems().values().stream().filter(x -> chunks.contains(x.getLocation().getChunk())).toList();
    }

    @NotNull
    public List<StackedBlock> getStackedBlocks(@NotNull Collection<Chunk> chunks) {
        Objects.requireNonNull(chunks);
        return this.roseStacker.getManager(StackManager.class).getStackedBlocks().values().stream().filter(x -> chunks.contains(x.getLocation().getChunk())).toList();
    }

    @NotNull
    public List<StackedSpawner> getStackedSpawners(@NotNull Collection<Chunk> chunks) {
        Objects.requireNonNull(chunks);
        return this.roseStacker.getManager(StackManager.class).getStackedSpawners().values().stream().filter(x -> chunks.contains(x.getLocation().getChunk())).toList();
    }

    public EntityStackMultipleDeathEvent.EntityDrops getStackedEntityLoot(@NotNull StackedEntity stackedEntity) {
        Objects.requireNonNull(stackedEntity);
        return stackedEntity.calculateEntityDrops(stackedEntity.getStackSize(), true, EntityUtils.getApproximateExperience(stackedEntity.getEntity()));
    }

    public EntityStackMultipleDeathEvent.EntityDrops getStackedEntityLoot(@NotNull StackedEntity stackedEntity, int count, boolean includeMainEntity) {
        Objects.requireNonNull(stackedEntity);
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"count must be greater than 0");
        return stackedEntity.calculateEntityDrops(count, includeMainEntity, EntityUtils.getApproximateExperience(stackedEntity.getEntity()));
    }

    public EntityStackMultipleDeathEvent.EntityDrops getStackedEntityLoot(@NotNull StackedEntity stackedEntity, int count, boolean includeMainEntity, int lootingModifier) {
        Objects.requireNonNull(stackedEntity);
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"count must be greater than 0");
        return stackedEntity.calculateEntityDrops(count, includeMainEntity, EntityUtils.getApproximateExperience(stackedEntity.getEntity()), lootingModifier);
    }
}

