/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.command;

import dev.rosewood.rosestacker.lib.rosegarden.RosePlugin;
import dev.rosewood.rosestacker.lib.rosegarden.command.argument.ArgumentHandlers;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.ArgumentsDefinition;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.BaseRoseCommand;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.CommandContext;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.CommandInfo;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.annotation.RoseExecutable;
import dev.rosewood.rosestacker.lib.rosegarden.utils.StringPlaceholders;
import dev.rosewood.rosestacker.manager.LocaleManager;
import dev.rosewood.rosestacker.utils.ItemUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class StackToolCommand
extends BaseRoseCommand {
    private final RosePlugin rosePlugin;

    public StackToolCommand(RosePlugin rosePlugin) {
        super(rosePlugin);
        this.rosePlugin = rosePlugin;
    }

    @RoseExecutable
    public void execute(CommandContext context, Player target) {
        LocaleManager localeManager = this.rosePlugin.getManager(LocaleManager.class);
        if (target == null) {
            CommandSender commandSender = context.getSender();
            if (!(commandSender instanceof Player)) {
                localeManager.sendCommandMessage(context.getSender(), "command-stacktool-no-console");
                return;
            }
            Player player = (Player)commandSender;
            player.getInventory().addItem(new ItemStack[]{ItemUtils.getStackingTool()});
            localeManager.sendCommandMessage((CommandSender)player, "command-stacktool-given");
        } else {
            target.getInventory().addItem(new ItemStack[]{ItemUtils.getStackingTool()});
            localeManager.sendCommandMessage(context.getSender(), "command-stacktool-given-other", StringPlaceholders.of("player", target.getName()));
        }
    }

    @Override
    protected CommandInfo createCommandInfo() {
        return CommandInfo.builder("stacktool").descriptionKey("command-stacktool-description").permission("rosestacker.stacktool").arguments(ArgumentsDefinition.builder().optional("target", ArgumentHandlers.PLAYER).build()).build();
    }
}

