/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.command.argument;

import dev.rosewood.rosestacker.lib.rosegarden.RosePlugin;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.Argument;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.ArgumentHandler;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.CommandContext;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.InputIterator;
import dev.rosewood.rosestacker.lib.rosegarden.utils.StringPlaceholders;
import dev.rosewood.rosestacker.manager.StackSettingManager;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;

public class StackedBlockTypeArgumentHandler
extends ArgumentHandler<Material> {
    private final RosePlugin rosePlugin;

    public StackedBlockTypeArgumentHandler(RosePlugin rosePlugin) {
        super(Material.class);
        this.rosePlugin = rosePlugin;
    }

    @Override
    public Material handle(CommandContext context, Argument argument, InputIterator inputIterator) throws ArgumentHandler.HandledArgumentException {
        String input = inputIterator.next();
        return Arrays.stream(Material.values()).filter(x -> x.name().equalsIgnoreCase(input)).findFirst().orElseThrow(() -> new ArgumentHandler.HandledArgumentException("argument-handler-material", StringPlaceholders.of("input", input)));
    }

    @Override
    public List<String> suggest(CommandContext context, Argument argument, String[] args) {
        return this.rosePlugin.getManager(StackSettingManager.class).getStackableBlockTypes().stream().map(Enum::name).map(String::toLowerCase).collect(Collectors.toList());
    }
}

