/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.config;

import dev.rosewood.rosestacker.RoseStacker;
import dev.rosewood.rosestacker.lib.rosegarden.config.RoseSetting;
import dev.rosewood.rosestacker.lib.rosegarden.config.SettingHolder;
import dev.rosewood.rosestacker.lib.rosegarden.config.SettingSerializer;
import dev.rosewood.rosestacker.lib.rosegarden.config.SettingSerializers;
import dev.rosewood.rosestacker.nms.storage.StackedEntityDataStorageType;
import dev.rosewood.rosestacker.utils.VersionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;

public final class SettingKey
implements SettingHolder {
    public static final SettingHolder INSTANCE = new SettingKey();
    private static final List<RoseSetting<?>> KEYS = new ArrayList();
    public static final RoseSetting<List<String>> DISABLED_WORLDS = SettingKey.create("disabled-worlds", SettingSerializers.STRING_LIST, List.of("disabled_world_name"), "A list of worlds that the plugin is disabled in");
    public static final RoseSetting<Long> STACK_FREQUENCY = SettingKey.create("stack-frequency", SettingSerializers.LONG, 100L, "How often should we try to stack nearby entities?", "Higher values mean longer times between checks, but also less lag", "Values are in ticks, do not set lower than 1");
    public static final RoseSetting<Long> UNSTACK_FREQUENCY = SettingKey.create("unstack-frequency", SettingSerializers.LONG, 50L, "How often should we try to unstack entities that are no longer compatible with their stack?", "Values are in ticks, set to -1 to disable");
    public static final RoseSetting<Long> ITEM_STACK_FREQUENCY = SettingKey.create("item-stack-frequency", SettingSerializers.LONG, 20L, "How often should we try to stack nearby items?", "Values are in ticks, do not set lower than 1");
    public static final RoseSetting<Long> NAMETAG_UPDATE_FREQUENCY = SettingKey.create("nametag-update-frequency", SettingSerializers.LONG, 30L, "How often should we update stacked entity nametags?", "Values are in ticks, do not set lower than 1");
    public static final RoseSetting<Long> HOLOGRAM_UPDATE_FREQUENCY = SettingKey.create("hologram-update-frequency", SettingSerializers.LONG, 20L, "How often should we update stacked block/spawner holograms?");
    public static final RoseSetting<Long> AUTOSAVE_FREQUENCY = SettingKey.create("autosave-frequency", SettingSerializers.LONG, 15L, "How often should we autosave all loaded stack data?", "Value is measured in minutes, set to -1 to disable");
    public static final RoseSetting<Long> ENTITY_RESCAN_FREQUENCY = SettingKey.create("entity-rescan-frequency", SettingSerializers.LONG, 1000L, "How often should we scan the world for missed entities?", "Sometimes entities can spawn and be missed by the plugin for unknown reasons, this fixes that", "Values are in ticks, set to -1 to disable");
    public static final RoseSetting<ConfigurationSection> GLOBAL_ENTITY_SETTINGS = SettingKey.create("global-entity-settings", "Global entity settings", "Changed values in entity_settings.yml will override these values");
    public static final RoseSetting<Boolean> ENTITY_STACKING_ENABLED = SettingKey.create("global-entity-settings.stacking-enabled", SettingSerializers.BOOLEAN, true, "Should entity stacking be enabled at all?");
    public static final RoseSetting<String> ENTITY_DATA_STORAGE_TYPE = SettingKey.create("global-entity-settings.data-storage-type", SettingSerializers.STRING, StackedEntityDataStorageType.NBT.name(), (String[])Stream.concat(Arrays.stream(new String[]{"What type of data storage should be used for stacked entities?", "Valid Values:"}), Arrays.stream(StackedEntityDataStorageType.values()).map(x -> "  " + x.name() + " - " + x.getDescription())).toArray(String[]::new));
    public static final RoseSetting<Boolean> ENTITY_INSTANT_STACK = SettingKey.create("global-entity-settings.instant-stack", SettingSerializers.BOOLEAN, true, "Should entities try to be stacked instantly upon spawning?", "Setting this to false may yield better performance at the cost of entities being visible before stacking");
    public static final RoseSetting<Integer> ENTITY_MIN_STACK_SIZE = SettingKey.create("global-entity-settings.min-stack-size", SettingSerializers.INTEGER, 2, "The minimum number of nearby entities required to form a stack", "Do not set this lower than 2");
    public static final RoseSetting<Integer> ENTITY_MAX_STACK_SIZE = SettingKey.create("global-entity-settings.max-stack-size", SettingSerializers.INTEGER, 128, "The maximum number of entities that can be in a single stack");
    public static final RoseSetting<Integer> ENTITY_MERGE_RADIUS = SettingKey.create("global-entity-settings.merge-radius", SettingSerializers.INTEGER, 5, "How close do entities need to be to merge with each other?");
    public static final RoseSetting<Boolean> ENTITY_MERGE_ENTIRE_CHUNK = SettingKey.create("global-entity-settings.merge-entire-chunk", SettingSerializers.BOOLEAN, false, "Should we merge all similar entities into a single stack per chunk?", "This setting overrides the above");
    public static final RoseSetting<Boolean> ENTITY_MIN_STACK_COUNT_ONLY_INDIVIDUALS = SettingKey.create("global-entity-settings.min-stack-count-only-individuals", SettingSerializers.BOOLEAN, false, "Should only individual entities be counted for the min-stack-size requirement?", "When false, an existing stack larger than min-stack-size can have other mobs stack into it");
    public static final RoseSetting<Boolean> ENTITY_MIN_SPLIT_IF_LOWER = SettingKey.create("global-entity-settings.min-split-if-lower", SettingSerializers.BOOLEAN, false, "Should entity stacks split into individual mobs if the stack size goes below the min-stack-size setting?");
    public static final RoseSetting<Boolean> ENTITY_DISPLAY_TAGS = SettingKey.create("global-entity-settings.display-tags", SettingSerializers.BOOLEAN, true, "Should tags be displayed above stacks to show their amount and type?");
    public static final RoseSetting<Boolean> ENTITY_DISPLAY_TAGS_SINGLE = SettingKey.create("global-entity-settings.display-tags-single", SettingSerializers.BOOLEAN, false, "Should tags be displayed if the stack only has one entity?");
    public static final RoseSetting<Boolean> ENTITY_DISPLAY_TAGS_HOVER = SettingKey.create("global-entity-settings.display-tags-hover", SettingSerializers.BOOLEAN, false, "Do stacks need to be hovered over for their tags to be visible?");
    public static final RoseSetting<Boolean> ENTITY_DISPLAY_TAGS_CUSTOM_NAME = SettingKey.create("global-entity-settings.display-tags-custom-name", SettingSerializers.BOOLEAN, true, "Should the entity custom name be visible with the stack size?");
    public static final RoseSetting<Boolean> ENTITY_KILL_ENTIRE_STACK_ON_DEATH = SettingKey.create("global-entity-settings.kill-entire-stack-on-death", SettingSerializers.BOOLEAN, false, "Should the entire stack of entities always be killed when the main entity dies?");
    public static final RoseSetting<Boolean> ENTITY_KILL_ENTIRE_STACK_ON_DEATH_PERMISSION = SettingKey.create("global-entity-settings.kill-entire-stack-on-death-permission", SettingSerializers.BOOLEAN, false, "Enabling this will cause players with the permission rosestacker.killentirestack to kill an entire stack at once");
    public static final RoseSetting<List<String>> ENTITY_KILL_ENTIRE_STACK_CONDITIONS = SettingKey.create("global-entity-settings.kill-entire-stack-on-death-conditions", SettingSerializers.STRING_LIST, List.of("FALL"), "Under what conditions should the entire stack be killed when the main entity dies?", "If kill-entire-stack-on-death is true, this setting will not be used", "Valid conditions can be found here:", "https://hub.spigotmc.org/javadocs/spigot/org/bukkit/event/entity/EntityDamageEvent.DamageCause.html");
    public static final RoseSetting<ConfigurationSection> ENTITY_MULTIKILL_OPTIONS = SettingKey.create("global-entity-settings.multikill-options", "Allows killing multiple mobs at once, does not work with kill-entire-stack-on-death settings");
    public static final RoseSetting<Boolean> ENTITY_MULTIKILL_ENABLED = SettingKey.create("global-entity-settings.multikill-options.multikill-enabled", SettingSerializers.BOOLEAN, false, "Should multikill be enabled?");
    public static final RoseSetting<String> ENTITY_MULTIKILL_AMOUNT = SettingKey.create("global-entity-settings.multikill-options.multikill-amount", SettingSerializers.STRING, "5", "The amount of mobs in the stack to kill at a time", "If using the multikill enchantment, this will be the number of mobs killed per enchantment level", "You can add a % to the end of the number to kill a percentage of the stack, for example '5%'", "You can also define a random range for the multikill, for example '5-50%', you can add % to either side");
    public static final RoseSetting<Boolean> ENTITY_MULTIKILL_PLAYER_ONLY = SettingKey.create("global-entity-settings.multikill-options.multikill-player-only", SettingSerializers.BOOLEAN, false, "Should the multikill only apply when done directly by a player?");
    public static final RoseSetting<Boolean> ENTITY_MULTIKILL_ENCHANTMENT_ENABLED = SettingKey.create("global-entity-settings.multikill-options.multikill-enchantment-enabled", SettingSerializers.BOOLEAN, false, "Should an enchantment on the tool be required to be able to use the multikill features?");
    public static final RoseSetting<String> ENTITY_MULTIKILL_ENCHANTMENT_TYPE = SettingKey.create("global-entity-settings.multikill-options.multikill-enchantment-type", SettingSerializers.STRING, VersionUtils.SWEEPING_EDGE.getKey().getKey(), "The enchantment required to be able to use the multikill features", "Only used if the above setting is enabled");
    public static final RoseSetting<Boolean> ENTITY_KILL_TRANSFER_VELOCITY = SettingKey.create("global-entity-settings.kill-transfer-velocity", SettingSerializers.BOOLEAN, true, "Should knockback be transferred to the next entity in the stack?");
    public static final RoseSetting<Boolean> ENTITY_KILL_TRANSFER_FIRE = SettingKey.create("global-entity-settings.kill-transfer-fire", SettingSerializers.BOOLEAN, true, "Should fire be transferred to the next entity in the stack?");
    public static final RoseSetting<Boolean> ENTITY_KILL_TRANSFER_TARGET = SettingKey.create("global-entity-settings.kill-transfer-target", SettingSerializers.BOOLEAN, true, "Should the entity's target be transferred to the next entity in the stack?");
    public static final RoseSetting<Boolean> ENTITY_KILL_DELAY_NEXT_SPAWN = SettingKey.create("global-entity-settings.kill-delay-next-spawn", SettingSerializers.BOOLEAN, false, "Should the next entity in the stack be delayed from spawning by one tick after the previous mob dies?", "Enabling this can prevent the newly spawned entity from taking the same damage as the previous one.", "May result in not being able to kill the entities as fast");
    public static final RoseSetting<Boolean> ENTITY_DISPLAY_CORPSE = SettingKey.create("global-entity-settings.display-corpse", SettingSerializers.BOOLEAN, true, "Should a corpse appear when a mob in the stack dies?", "This is the red death animation that appears when a mob dies");
    public static final RoseSetting<Boolean> ENTITY_CUMULATIVE_BREEDING = SettingKey.create("global-entity-settings.cumulative-breeding", SettingSerializers.BOOLEAN, true, "Should all animals in a stack be bred together with as much food as they can?", "Please note that this setting is not perfect, it is here to make breeding more simple for players", "For best baby animal support, set dont-stack-if-baby to true for each breedable entity type in entity_settings.yml");
    public static final RoseSetting<Boolean> ENTITY_CUMULATIVE_BREEDING_TRIGGER_BREED_EVENT = SettingKey.create("global-entity-settings.cumulative-breeding-trigger-breed-event", SettingSerializers.BOOLEAN, false, "Should an EntityBreedEvent be called for each child entity produced by breeding?", "Enabling may allow better compatibility with other plugins");
    public static final RoseSetting<List<String>> ENTITY_SHARE_DAMAGE_CONDITIONS = SettingKey.create("global-entity-settings.share-damage-conditions", SettingSerializers.STRING_LIST, List.of(), "Under what conditions will the damage be propagated through the whole stack?", "Valid conditions can be found here:", "https://hub.spigotmc.org/javadocs/spigot/org/bukkit/event/entity/EntityDamageEvent.DamageCause.html", "Note: This setting is not recommended as it can be intensive for larger stack sizes", "      This setting will not work if using data-storage-type: SIMPLE");
    public static final RoseSetting<Boolean> ENTITY_DROP_ACCURATE_ITEMS = SettingKey.create("global-entity-settings.drop-accurate-items", SettingSerializers.BOOLEAN, true, "Should items be dropped for all entities when an entire stack is killed at once?");
    public static final RoseSetting<Boolean> ENTITY_DROP_ACCURATE_EXP = SettingKey.create("global-entity-settings.drop-accurate-exp", SettingSerializers.BOOLEAN, true, "Should exp be dropped for all entities when an entire stack is killed at once?");
    public static final RoseSetting<ConfigurationSection> ENTITY_LOOT_APPROXIMATION_OPTIONS = SettingKey.create("global-entity-settings.loot-approximation-options", "Allows approximating loot for killing an entire stack of entities at once", "Can greatly reduce lag and improve performance at the cost of some loot accuracy");
    public static final RoseSetting<Boolean> ENTITY_LOOT_APPROXIMATION_ENABLED = SettingKey.create("global-entity-settings.loot-approximation-options.approximation-enabled", SettingSerializers.BOOLEAN, true, "Should loot be approximated to reduce lag for killing large stack sizes at once?");
    public static final RoseSetting<Integer> ENTITY_LOOT_APPROXIMATION_THRESHOLD = SettingKey.create("global-entity-settings.loot-approximation-options.approximation-threshold", SettingSerializers.INTEGER, 2048, "The threshold at which loot drops will be approximated");
    public static final RoseSetting<Integer> ENTITY_LOOT_APPROXIMATION_AMOUNT = SettingKey.create("global-entity-settings.loot-approximation-options.approximation-amount", SettingSerializers.INTEGER, 256, "The number of times the entity loot tables will be run");
    public static final RoseSetting<Boolean> ENTITY_LOOT_PROPAGATE_KILLER = SettingKey.create("global-entity-settings.loot-propagate-killer", SettingSerializers.BOOLEAN, true, "Should the stack killer be propagated to other entities in the stack?", "This mainly affects the looting enchantment applying to all mobs in the stack instead of just the main entity");
    public static final RoseSetting<Boolean> ENTITY_REQUIRE_LINE_OF_SIGHT = SettingKey.create("global-entity-settings.require-line-of-sight", SettingSerializers.BOOLEAN, true, "Do entities need to be able to see each other to be able to stack?", "Setting this to true will prevent entities from stacking through walls");
    public static final RoseSetting<Boolean> ENTITY_TRANSFORM_ENTIRE_STACK = SettingKey.create("global-entity-settings.transform-entire-stack", SettingSerializers.BOOLEAN, true, "Should the entire stack of entities be transformed when the main entity is transformed?", "This applies to pigs getting struck by lightning, zombies drowning, etc");
    public static final RoseSetting<Boolean> ENTITY_ONLY_STACK_ON_GROUND = SettingKey.create("global-entity-settings.only-stack-on-ground", SettingSerializers.BOOLEAN, false, "Do entities have to be on the ground in order to stack?", "This does not apply if the mobs can fly or live in the water");
    public static final RoseSetting<Boolean> ENTITY_DONT_STACK_IF_IN_WATER = SettingKey.create("global-entity-settings.dont-stack-if-in-water", SettingSerializers.BOOLEAN, false, "Should we stack entities if they are in the water?", "This does not apply if the mobs can fly or live in the water");
    public static final RoseSetting<Boolean> ENTITY_DONT_STACK_IF_LEASHED = SettingKey.create("global-entity-settings.dont-stack-if-leashed", SettingSerializers.BOOLEAN, true, "Should we stack entities if they are leashed?", "You will still be able to leash stacks, it will just prevent them from stacking into other stacks", "This can cause some weird effects if disabled");
    public static final RoseSetting<Boolean> ENTITY_DONT_STACK_IF_INVULNERABLE = SettingKey.create("global-entity-settings.dont-stack-if-invulnerable", SettingSerializers.BOOLEAN, true, "Should we stack entities if they are invulnerable?");
    public static final RoseSetting<Boolean> ENTITY_DONT_STACK_CUSTOM_NAMED = SettingKey.create("global-entity-settings.dont-stack-custom-named", SettingSerializers.BOOLEAN, false, "Should we stack entities with custom names?");
    public static final RoseSetting<Boolean> ENTITY_DONT_STACK_IF_HAS_EQUIPMENT = SettingKey.create("global-entity-settings.dont-stack-if-has-equipment", SettingSerializers.BOOLEAN, true, "Should we stack entities that have equipment?", "This will ignore mobs that have standard equipment such as skeletons with unenchanted bows", "This is recommended to keep enabled to prevent item duplication when using loot-approximation");
    public static final RoseSetting<Boolean> ENTITY_DONT_STACK_IF_ACTIVE_RAIDER = SettingKey.create("global-entity-settings.dont-stack-if-active-raider", SettingSerializers.BOOLEAN, true, "Should we stack entities that are part of an active raid?");
    public static final RoseSetting<Boolean> ENTITY_STACK_FLYING_DOWNWARDS = SettingKey.create("global-entity-settings.stack-flying-downwards", SettingSerializers.BOOLEAN, false, "Should flying mobs always be stacked downwards?", "This is useful for mob grinders");
    public static final RoseSetting<Boolean> ENTITY_ONLY_STACK_FROM_SPAWNERS = SettingKey.create("global-entity-settings.only-stack-from-spawners", SettingSerializers.BOOLEAN, false, "Should we only stack entities spawned from spawners?");
    public static final RoseSetting<Boolean> ENTITY_DONT_STACK_FROM_TRIAL_SPAWNERS = SettingKey.create("global-entity-settings.dont-stack-from-trial-spawners", SettingSerializers.BOOLEAN, true, "Should we only avoid stacking entities spawned from trial spawners?");
    public static final RoseSetting<Boolean> ENTITY_TRIGGER_DEATH_EVENT_FOR_ENTIRE_STACK_KILL = SettingKey.create("global-entity-settings.trigger-death-event-for-entire-stack-kill", SettingSerializers.BOOLEAN, false, "Should an entity death event be triggered for each mob in a stack?", "If you use custom drops plugins, make sure to enable this", "Note to developers: The death events are asynchronous based on the below setting");
    public static final RoseSetting<Boolean> ENTITY_DEATH_EVENT_RUN_ASYNC = SettingKey.create("global-entity-settings.death-event-trigger-async", SettingSerializers.BOOLEAN, true, "Should the entity loot be calculated asynchronously?", "If you try enabling this and you get errors that say something like '<SomeEvent> may only be triggered synchronously'", "and has RoseStacker in the stacktrace, you should keep this as false.", "Set this as true for optimal performance if you are not having issues.");
    public static final RoseSetting<Boolean> ENTITY_INSTANT_KILL_DISABLED_AI = SettingKey.create("global-entity-settings.instant-kill-disabled-ai", SettingSerializers.BOOLEAN, false, "Should entities with disabled AI be killed instantly when receiving damage from a player?");
    public static final RoseSetting<Boolean> ENTITY_DISABLE_ALL_MOB_AI = SettingKey.create("global-entity-settings.disable-all-mob-ai", SettingSerializers.BOOLEAN, false, "Should the AI of ALL MOBS on the server be disabled?", "The parts of the AI that are disabled can be further customized in the global-spawner-settings section");
    public static final RoseSetting<Integer> ENTITY_SAVE_MAX_STACK_SIZE = SettingKey.create("global-entity-settings.save-max-stack-size", SettingSerializers.INTEGER, -1, "The maximum amount of entities that will be stored when entities are saved to chunk data", "Useful for when you have a very high max stack size, set to -1 to disable");
    public static final RoseSetting<ConfigurationSection> GLOBAL_ITEM_SETTINGS = SettingKey.create("global-item-settings", "Global item settings", "Changed values in item_settings.yml will override these values");
    public static final RoseSetting<Boolean> ITEM_STACKING_ENABLED = SettingKey.create("global-item-settings.stacking-enabled", SettingSerializers.BOOLEAN, true, "Should item stacking be enabled at all?");
    public static final RoseSetting<Boolean> ITEM_INSTANT_STACK = SettingKey.create("global-item-settings.instant-stack", SettingSerializers.BOOLEAN, true, "Should items try to be stacked instantly upon spawning?", "Setting this to false may yield better performance at the cost of items being visible before stacking");
    public static final RoseSetting<Integer> ITEM_MAX_STACK_SIZE = SettingKey.create("global-item-settings.max-stack-size", SettingSerializers.INTEGER, 1024, "The maximum number of items that can be in a single stack");
    public static final RoseSetting<Double> ITEM_MERGE_RADIUS = SettingKey.create("global-item-settings.merge-radius", SettingSerializers.DOUBLE, 2.5, "How close do items need to be to merge with each other?");
    public static final RoseSetting<Boolean> ITEM_DISPLAY_TAGS = SettingKey.create("global-item-settings.display-tags", SettingSerializers.BOOLEAN, true, "Should tags be displayed above stacks to show their amount and type?");
    public static final RoseSetting<Boolean> ITEM_DISPLAY_TAGS_SINGLE = SettingKey.create("global-item-settings.display-tags-single", SettingSerializers.BOOLEAN, false, "Should tags be displayed if the stack only has one item?");
    public static final RoseSetting<Boolean> ITEM_DISPLAY_TAGS_ABOVE_VANILLA_STACK_SIZE = SettingKey.create("global-item-settings.display-tags-above-vanilla-stack-size", SettingSerializers.BOOLEAN, false, "Should tags only be displayed if the stack size goes above the vanilla value?");
    public static final RoseSetting<Boolean> ITEM_DISPLAY_CUSTOM_NAMES = SettingKey.create("global-item-settings.display-custom-names", SettingSerializers.BOOLEAN, true, "Should items with custom names be shown on their tags?");
    public static final RoseSetting<Boolean> ITEM_DISPLAY_CUSTOM_NAMES_COLOR = SettingKey.create("global-item-settings.display-custom-names-color", SettingSerializers.BOOLEAN, true, "Should the color of custom names be shown on their tags?");
    public static final RoseSetting<Boolean> ITEM_DISPLAY_CUSTOM_NAMES_ALWAYS = SettingKey.create("global-item-settings.display-custom-names-always", SettingSerializers.BOOLEAN, true, "Should items with a custom name always display their tags?", "This mirrors vanilla behavior");
    public static final RoseSetting<Boolean> ITEM_DISPLAY_DESPAWN_TIMER_PLACEHOLDER = SettingKey.create("global-item-settings.display-despawn-timer-placeholder", SettingSerializers.BOOLEAN, false, "Should the %timer% placeholder be available in item display tags?", "You will need to add the %timer% placeholder to the item display tag in your locale file manually", "Placeholder updates will occur at the same frequency as item-stack-frequency");
    public static final RoseSetting<Boolean> ITEM_RESET_DESPAWN_TIMER_ON_MERGE = SettingKey.create("global-item-settings.reset-despawn-timer-on-merge", SettingSerializers.BOOLEAN, true, "Should the item despawn timer be reset when an item is merged into it?");
    public static final RoseSetting<Boolean> ITEM_MERGE_INTO_NEWEST = SettingKey.create("global-item-settings.merge-into-newest", SettingSerializers.BOOLEAN, false, "Should items be merged into the newest stack?");
    public static final RoseSetting<Boolean> ITEM_DISABLE_PICKUP_IF_VANISHED = SettingKey.create("global-item-settings.disable-pickup-if-vanished", SettingSerializers.BOOLEAN, true, "Should items be prevented from being picked up while vanished?", "This is for compatibility with external vanish plugins");
    public static final RoseSetting<ConfigurationSection> GLOBAL_BLOCK_SETTINGS = SettingKey.create("global-block-settings", "Global block settings", "Changed values in block_settings.yml will override these values");
    public static final RoseSetting<Boolean> BLOCK_STACKING_ENABLED = SettingKey.create("global-block-settings.stacking-enabled", SettingSerializers.BOOLEAN, true, "Should block stacking be enabled at all?");
    public static final RoseSetting<Integer> BLOCK_MAX_STACK_SIZE = SettingKey.create("global-block-settings.max-stack-size", SettingSerializers.INTEGER, 2048, "The maximum number of blocks that can be in a single stack");
    public static final RoseSetting<Boolean> BLOCK_DISPLAY_TAGS = SettingKey.create("global-block-settings.display-tags", SettingSerializers.BOOLEAN, true, "Should tags be displayed above stacks to show their amount and type?");
    public static final RoseSetting<Double> BLOCK_DISPLAY_TAGS_HEIGHT_OFFSET = SettingKey.create("global-block-settings.display-tags-height-offset", SettingSerializers.DOUBLE, 0.75, "The height offset of the hologram relative to the stacked block");
    public static final RoseSetting<Boolean> BLOCK_EXPLOSION_PROTECTION = SettingKey.create("global-block-settings.explosion-protection", SettingSerializers.BOOLEAN, true, "Should stacked blocks be protected from explosions?");
    public static final RoseSetting<Boolean> BLOCK_EXPLOSION_DECREASE_STACK_SIZE_ONLY = SettingKey.create("global-block-settings.explosion-decrease-stack-size-only", SettingSerializers.BOOLEAN, false, "If true, the stack size will decrease without dropping any items. Set to false to drop items.");
    public static final RoseSetting<Double> BLOCK_EXPLOSION_DESTROY_CHANCE = SettingKey.create("global-block-settings.explosion-destroy-chance", SettingSerializers.DOUBLE, 100.0, "The chance that the stack will be affected by an explosion. (0-100)");
    public static final RoseSetting<Double> BLOCK_EXPLOSION_DESTROY_AMOUNT_PERCENTAGE = SettingKey.create("global-block-settings.explosion-amount-percentage", SettingSerializers.DOUBLE, 100.0, "The percentage of the stack to either destroy or drop as items. (0-100)");
    public static final RoseSetting<Integer> BLOCK_EXPLOSION_DESTROY_AMOUNT_FIXED = SettingKey.create("global-block-settings.explosion-amount-fixed", SettingSerializers.INTEGER, -1, "The amount of the stack to either destroy or drop as items.", "If this is set to 1 or greater, overrides explosion-amount-percentage");
    public static final RoseSetting<Boolean> BLOCK_EXPLOSION_DESTROY_REMAINING = SettingKey.create("global-block-settings.explosion-destroy-remaining", SettingSerializers.BOOLEAN, false, "If this is set to true and explosion-decrease-stack-size-only is set to false, the remainder of the stack not dropped as items will be destroyed");
    public static final RoseSetting<Boolean> BLOCK_DROP_TO_INVENTORY = SettingKey.create("global-block-settings.drop-to-inventory", SettingSerializers.BOOLEAN, false, "Should blocks be dropped directly into the player's inventory when broken?");
    public static final RoseSetting<Boolean> BLOCK_BREAK_ENTIRE_STACK_WHILE_SNEAKING = SettingKey.create("global-block-settings.break-entire-stack-while-sneaking", SettingSerializers.BOOLEAN, true, "Should the entire stack be broken if the player is sneaking?");
    public static final RoseSetting<Boolean> BLOCK_BREAK_ENTIRE_STACK_INTO_SEPARATE = SettingKey.create("global-block-settings.break-entire-stack-into-separate", SettingSerializers.BOOLEAN, true, "Should the entire stack be broken into individual blocks?");
    public static final RoseSetting<Boolean> BLOCK_GUI_ENABLED = SettingKey.create("global-block-settings.gui-enabled", SettingSerializers.BOOLEAN, true, "Should a GUI to edit the stack open when the player shift-right-clicks the stack?");
    public static final RoseSetting<String> BLOCK_GUI_BORDER_MATERIAL = SettingKey.create("global-block-settings.gui-border-material", SettingSerializers.STRING, Material.BLUE_STAINED_GLASS_PANE.name(), "What material should be used for the border of the GUI?");
    public static final RoseSetting<Boolean> BLOCK_GUI_ONLY_ONE_PLAYER_ALLOWED = SettingKey.create("global-block-settings.gui-only-one-player-allowed", SettingSerializers.BOOLEAN, false, "Should only one player be allowed to use the stack GUIs at a time?");
    public static final RoseSetting<ConfigurationSection> GLOBAL_SPAWNER_SETTINGS = SettingKey.create("global-spawner-settings", "Global spawner settings", "Changed values in spawner_settings.yml will override these values");
    public static final RoseSetting<Boolean> SPAWNER_STACKING_ENABLED = SettingKey.create("global-spawner-settings.stacking-enabled", SettingSerializers.BOOLEAN, true, "Should RoseStacker handle spawners?", "Disabling this will prevent spawners from stacking and being handled entirely.", "If you don't want spawners to stack but still want them handled", "by RoseStacker, set the max-stack-size to 1 instead.", "Changing this setting will require a full server restart to fully take effect.");
    public static final RoseSetting<Integer> SPAWNER_MAX_STACK_SIZE = SettingKey.create("global-spawner-settings.max-stack-size", SettingSerializers.INTEGER, 32, "The maximum number of spawners that can be in a single stack");
    public static final RoseSetting<Boolean> SPAWNER_SPAWN_ASYNC = SettingKey.create("global-spawner-settings.spawn-async", SettingSerializers.BOOLEAN, true, "Should spawners try to spawn mobs asynchronously?", "Block spawn condition checks and entity creation will be performed async if enabled");
    public static final RoseSetting<Boolean> SPAWNER_DISPLAY_TAGS = SettingKey.create("global-spawner-settings.display-tags", SettingSerializers.BOOLEAN, true, "Should tags be displayed above stacks to show their amount and type?");
    public static final RoseSetting<Boolean> SPAWNER_DISPLAY_TAGS_SINGLE = SettingKey.create("global-spawner-settings.display-tags-single", SettingSerializers.BOOLEAN, false, "Should tags be displayed if the stack only has one spawner?");
    public static final RoseSetting<Boolean> SPAWNER_DISPLAY_TAGS_SINGLE_AMOUNT = SettingKey.create("global-spawner-settings.display-tags-single-amount", SettingSerializers.BOOLEAN, false, "Should stacks of size one show the amount on their tags if enabled?");
    public static final RoseSetting<Double> SPAWNER_DISPLAY_TAGS_HEIGHT_OFFSET = SettingKey.create("global-spawner-settings.display-tags-height-offset", SettingSerializers.DOUBLE, 0.75, "The height offset of the hologram relative to the spawner");
    public static final RoseSetting<Boolean> SPAWNER_DISABLE_MOB_AI = SettingKey.create("global-spawner-settings.disable-mob-ai", SettingSerializers.BOOLEAN, false, "Should mob AI be disabled for mobs spawned by spawners?");
    public static final RoseSetting<ConfigurationSection> SPAWNER_DISABLE_MOB_AI_OPTIONS = SettingKey.create("global-spawner-settings.disable-mob-ai-options", "Options to apply to mobs with disabled AI");
    public static final RoseSetting<Boolean> SPAWNER_DISABLE_MOB_AI_OPTIONS_REMOVE_GOALS = SettingKey.create("global-spawner-settings.disable-mob-ai-options.remove-goals", SettingSerializers.BOOLEAN, true, "Should mob goals be removed? This includes movement and targeting along with other mob AI behaviors.", "This cannot be undone without a full restart.");
    public static final RoseSetting<Boolean> SPAWNER_DISABLE_MOB_AI_OPTIONS_SET_UNAWARE = SettingKey.create("global-spawner-settings.disable-mob-ai-options.set-unaware", SettingSerializers.BOOLEAN, true, "Should mobs be set to be unaware?");
    public static final RoseSetting<Boolean> SPAWNER_DISABLE_MOB_AI_OPTIONS_UNDEAD_BURN_IN_DAYLIGHT = SettingKey.create("global-spawner-settings.disable-mob-ai-options.undead-burn-in-daylight", SettingSerializers.BOOLEAN, false, "Should undead mobs be able to burn in the daylight?");
    public static final RoseSetting<Boolean> SPAWNER_DISABLE_MOB_AI_OPTIONS_SILENCE = SettingKey.create("global-spawner-settings.disable-mob-ai-options.silence", SettingSerializers.BOOLEAN, true, "Should mobs be silenced so they don't make any sounds?");
    public static final RoseSetting<Boolean> SPAWNER_DISABLE_MOB_AI_OPTIONS_NO_KNOCKBACK = SettingKey.create("global-spawner-settings.disable-mob-ai-options.no-knockback", SettingSerializers.BOOLEAN, true, "Should knockback be disabled?");
    public static final RoseSetting<Boolean> SPAWNER_DISABLE_MOB_AI_OPTIONS_DISABLE_BREEDING = SettingKey.create("global-spawner-settings.disable-mob-ai-options.disable-breeding", SettingSerializers.BOOLEAN, true, "Should mobs with disabled AI be able to breed?");
    public static final RoseSetting<Boolean> SPAWNER_DISABLE_MOB_AI_OPTIONS_KILL_ENTIRE_STACK_ON_DEATH = SettingKey.create("global-spawner-settings.disable-mob-ai-options.kill-entire-stack-on-death", SettingSerializers.BOOLEAN, false, "Should the entire stack of mobs be killed on death?", "This will only apply to mobs with disabled AI and overwrites any other settings if this is set to true");
    public static final RoseSetting<Boolean> SPAWNER_DISABLE_MOB_AI_OPTIONS_DISABLE_ZOMBIFICATION = SettingKey.create("global-spawner-settings.disable-mob-ai-options.disable-zombification", SettingSerializers.BOOLEAN, true, "Should mobs with disabled AI be immune to zombification?");
    public static final RoseSetting<Boolean> SPAWNER_DISABLE_MOB_AI_OPTIONS_DISABLE_ITEM_PICKUP = SettingKey.create("global-spawner-settings.disable-mob-ai-options.disable-item-pickup", SettingSerializers.BOOLEAN, true, "Should mobs with disabled AI be unable to pick up items?");
    public static final RoseSetting<Boolean> SPAWNER_DISABLE_MOB_AI_OPTIONS_DISABLE_COLLISION = SettingKey.create("global-spawner-settings.disable-mob-ai-options.disable-collision", SettingSerializers.BOOLEAN, false, "Should mobs with disabled AI be unable to collide with other mobs? Excludes players.", "This will also disable collision with projectiles like arrows, snowballs, tridents, etc");
    public static final RoseSetting<Boolean> SPAWNER_DISABLE_MOB_AI_OPTIONS_REENABLE_AI_ON_SPLIT = SettingKey.create("global-spawner-settings.disable-mob-ai-options.reenable-ai-on-split", SettingSerializers.BOOLEAN, false, "Should mobs with disabled AI have their AI re-enabled when they are split from the stack?", "Example: Adding a nametag to a mob to re-enable AI in combination with the dont-stack-custom-named setting");
    public static final RoseSetting<Boolean> SPAWNER_DISABLE_MOB_AI_ONLY_PLAYER_PLACED = SettingKey.create("global-spawner-settings.disable-mob-ai-only-player-placed", SettingSerializers.BOOLEAN, false, "Should only spawners placed by players spawn mobs with disabled AI?", "disable-mob-ai must be enabled for this to work");
    public static final RoseSetting<Boolean> SPAWNER_DISABLE_ATTACKING = SettingKey.create("global-spawner-settings.disable-attacking", SettingSerializers.BOOLEAN, false, "Should mobs spawned from spawners be prevented from attacking anything?");
    public static final RoseSetting<Boolean> SPAWNER_REMOVE_EQUIPMENT = SettingKey.create("global-spawner-settings.remove-equipment", SettingSerializers.BOOLEAN, false, "Should mobs spawned from spawners always spawn with no equipment?");
    public static final RoseSetting<Boolean> SPAWNER_STACK_ENTIRE_HAND_WHEN_SNEAKING = SettingKey.create("global-spawner-settings.stack-entire-hand-when-sneaking", SettingSerializers.BOOLEAN, true, "Should the entire item stack of spawners be merged when the player is sneaking?");
    public static final RoseSetting<Integer> SPAWNER_MAX_FAILED_SPAWN_ATTEMPTS = SettingKey.create("global-spawner-settings.max-failed-spawn-attempts", SettingSerializers.INTEGER, 50, "How many random blocks should we check to spawn a mob before giving up?");
    public static final RoseSetting<Boolean> SPAWNER_DEACTIVATE_WHEN_POWERED = SettingKey.create("global-spawner-settings.deactivate-when-powered", SettingSerializers.BOOLEAN, false, "Should spawners turn off when powered by redstone?");
    public static final RoseSetting<Integer> SPAWNER_POWERED_CHECK_FREQUENCY = SettingKey.create("global-spawner-settings.powered-check-frequency", SettingSerializers.INTEGER, 10, "How many ticks should there be between redstone power checks?", "Lower values will cause faster spawner updates at the cost of performance", "Value is measured in ticks, do not go below 1");
    public static final RoseSetting<Integer> SPAWNER_PLAYER_CHECK_FREQUENCY = SettingKey.create("global-spawner-settings.player-check-frequency", SettingSerializers.INTEGER, 10, "How many ticks should there be between nearby player checks?", "Lower values will cause faster player detection at the cost of performance", "Value is measured in ticks, do not go below 1");
    public static final RoseSetting<Boolean> SPAWNER_EXPLOSION_PROTECTION = SettingKey.create("global-spawner-settings.explosion-protection", SettingSerializers.BOOLEAN, true, "Should spawners be protected from explosions?");
    public static final RoseSetting<Boolean> SPAWNER_EXPLOSION_DECREASE_STACK_SIZE_ONLY = SettingKey.create("global-spawner-settings.explosion-decrease-stack-size-only", SettingSerializers.BOOLEAN, false, "If true, the stack size will decrease without dropping any items. Set to false to drop items.");
    public static final RoseSetting<Double> SPAWNER_EXPLOSION_DESTROY_CHANCE = SettingKey.create("global-spawner-settings.explosion-destroy-chance", SettingSerializers.DOUBLE, 100.0, "The chance that the stack will be affected by an explosion. (0-100)");
    public static final RoseSetting<Double> SPAWNER_EXPLOSION_DESTROY_AMOUNT_PERCENTAGE = SettingKey.create("global-spawner-settings.explosion-amount-percentage", SettingSerializers.DOUBLE, 100.0, "The percentage of the stack to either destroy or drop as items. (0-100)");
    public static final RoseSetting<Integer> SPAWNER_EXPLOSION_DESTROY_AMOUNT_FIXED = SettingKey.create("global-spawner-settings.explosion-amount-fixed", SettingSerializers.INTEGER, -1, "The amount of the stack to either destroy or drop as items. If this is set to 1 or greater, overrides explosion-amount-percentage");
    public static final RoseSetting<Boolean> SPAWNER_EXPLOSION_DESTROY_REMAINING = SettingKey.create("global-spawner-settings.explosion-destroy-remaining", SettingSerializers.BOOLEAN, false, "If this is set to true and explosion-decrease-stack-size-only is set to false, the remainder of the stack not dropped as items will be destroyed");
    public static final RoseSetting<Boolean> SPAWNER_EXPLOSION_DESTROY_NATURAL = SettingKey.create("global-spawner-settings.explosion-destroy-natural", SettingSerializers.BOOLEAN, false, "If true, naturally-generated spawners will always be destroyed if exploded");
    public static final RoseSetting<Boolean> SPAWNER_DROP_TO_INVENTORY = SettingKey.create("global-spawner-settings.drop-to-inventory", SettingSerializers.BOOLEAN, false, "Should spawners be dropped directly into the player's inventory when broken?");
    public static final RoseSetting<Boolean> SPAWNER_DROP_IN_CREATIVE = SettingKey.create("global-spawner-settings.drop-in-creative", SettingSerializers.BOOLEAN, false, "Should spawners always drop when broken in creative mode?");
    public static final RoseSetting<Boolean> SPAWNER_DROP_EXPERIENCE_WHEN_DESTROYED = SettingKey.create("global-spawner-settings.drop-experience-when-destroyed", SettingSerializers.BOOLEAN, true, "Should spawners drop experience when destroyed?");
    public static final RoseSetting<Boolean> SPAWNER_BREAK_ENTIRE_STACK_WHILE_SNEAKING = SettingKey.create("global-spawner-settings.break-entire-stack-while-sneaking", SettingSerializers.BOOLEAN, true, "Should the entire stack be broken if the player is sneaking?");
    public static final RoseSetting<Boolean> SPAWNER_BREAK_ENTIRE_STACK_INTO_SEPARATE = SettingKey.create("global-spawner-settings.break-entire-stack-into-separate", SettingSerializers.BOOLEAN, false, "Should the entire stack be broken into individual spawners?");
    public static final RoseSetting<Boolean> SPAWNER_ADVANCED_PERMISSIONS = SettingKey.create("global-spawner-settings.silk-touch-advanced-permissions", SettingSerializers.BOOLEAN, false, "Should advanced silk touch permissions be used?", "Requires silk-touch-require-permission to be enabled for the silk touch permissions", "This will enable the following permissions:", "- rosestacker.silktouch.<entityType>", "- rosestacker.nosilk.<entityType>", "- rosestacker.spawnerplace.<entityType>");
    public static final RoseSetting<Boolean> SPAWNER_SILK_TOUCH_REQUIRED = SettingKey.create("global-spawner-settings.silk-touch-required", SettingSerializers.BOOLEAN, false, "Should silk touch be required to pick up spawners?");
    public static final RoseSetting<Integer> SPAWNER_SILK_TOUCH_CHANCE = SettingKey.create("global-spawner-settings.silk-touch-chance", SettingSerializers.INTEGER, 100, "The chance that spawners will be picked up with a silk touch tool", "You may use rosestacker.silktouch.chance.<#> to use a custom percent chance through a permission", "The highest number between the config and permissions will be used", "Use a whole number value between 0 and 100");
    public static final RoseSetting<Double> SPAWNER_SILK_TOUCH_LUCK_CHANCE_INCREASE = SettingKey.create("global-spawner-settings.silk-touch-luck-chance-increase", SettingSerializers.DOUBLE, 0.0, "How much should the silk touch chance be increased per level of luck the player has?", "Luck can be applied by either attributes or the potion effect");
    public static final RoseSetting<Boolean> SPAWNER_SILK_TOUCH_ONLY_NATURAL = SettingKey.create("global-spawner-settings.silk-touch-only-natural", SettingSerializers.BOOLEAN, false, "Should only natural spawners have a chance of being picked up with silk touch?", "If enabled, player-placed spawners will always have a 100% chance of being picked up with silk touch");
    public static final RoseSetting<Boolean> SPAWNER_SILK_TOUCH_ONLY_PLAYER_PLACED = SettingKey.create("global-spawner-settings.silk-touch-only-player-placed", SettingSerializers.BOOLEAN, false, "Should only player placed spawners have a chance of being picked up with silk touch?", "If enabled, naturally generated spawners will always have a 100% chance of being destroyed when mined.", "Overrides silk-touch-only-natural.");
    public static final RoseSetting<Boolean> SPAWNER_SILK_TOUCH_GUARANTEE = SettingKey.create("global-spawner-settings.silk-touch-guarantee", SettingSerializers.BOOLEAN, true, "Should silk touch of level II or higher be guaranteed to pick up the spawner?");
    public static final RoseSetting<Boolean> SPAWNER_SILK_TOUCH_REQUIRE_PERMISSION = SettingKey.create("global-spawner-settings.silk-touch-require-permission", SettingSerializers.BOOLEAN, false, "Should the permission rosestacker.silktouch be required", "to be able to pick up spawners with silk touch?");
    public static final RoseSetting<Boolean> SPAWNER_SILK_TOUCH_PROTECT = SettingKey.create("global-spawner-settings.silk-touch-protect", SettingSerializers.BOOLEAN, false, "Should spawners be protected from being destroyed without silk touch?", "A message will be sent to the player explaining why it cannot be broken");
    public static final RoseSetting<Integer> SPAWNER_AUTO_STACK_RANGE = SettingKey.create("global-spawner-settings.auto-stack-range", SettingSerializers.INTEGER, -1, "How close should spawners have to be placed to auto stack together?", "A value of -1 will disable this setting", "This value is measured in blocks");
    public static final RoseSetting<Boolean> SPAWNER_AUTO_STACK_CHUNK = SettingKey.create("global-spawner-settings.auto-stack-chunk", SettingSerializers.BOOLEAN, false, "Should spawners in the same chunk auto stack together?", "This overrides the auto-stack-range setting");
    public static final RoseSetting<Boolean> SPAWNER_AUTO_STACK_PREVENT_SAME_TYPE_IN_RANGE = SettingKey.create("global-spawner-settings.auto-stack-prevent-same-type-in-range", SettingSerializers.BOOLEAN, false, "Should only one spawner block per mob type be allowed within the auto stack range?", "This will prevent placing spawners within range of another spawner of the same type");
    public static final RoseSetting<Boolean> SPAWNER_AUTO_STACK_PREVENT_MULTIPLE_IN_RANGE = SettingKey.create("global-spawner-settings.auto-stack-prevent-multiple-in-range", SettingSerializers.BOOLEAN, false, "Should only one spawner block be allowed within the auto stack range?", "This will prevent placing any spawners within range of another spawner");
    public static final RoseSetting<Boolean> SPAWNER_AUTO_STACK_PARTICLES = SettingKey.create("global-spawner-settings.auto-stack-particles", SettingSerializers.BOOLEAN, true, "Should particles be displayed when auto stacking spawners together?", "Useful for letting the player know where their spawner just went");
    public static final RoseSetting<Boolean> SPAWNER_CONVERT_REQUIRE_SAME_AMOUNT = SettingKey.create("global-spawner-settings.convert-require-same-amount", SettingSerializers.BOOLEAN, false, "Should the same number of spawn eggs as the spawner stack be required for conversion?");
    public static final RoseSetting<Boolean> SPAWNER_CONVERT_ADVANCED_PERMISSIONS = SettingKey.create("global-spawner-settings.convert-advanced-permissions", SettingSerializers.BOOLEAN, false, "Should advanced permissions be enabled for spawner conversions?", "Disables the permission rosestacker.spawnerconvert", "Enables the permissions rosestacker.spawnerconvert.*, replace * with individual mob names");
    public static final RoseSetting<Boolean> SPAWNER_HIDE_VANILLA_ITEM_LORE = SettingKey.create("global-spawner-settings.hide-vanilla-item-lore", SettingSerializers.BOOLEAN, true, "Should the vanilla spawner item lore displaying the mob type be hidden?", "Only affects 1.19.3+ servers");
    public static final RoseSetting<Boolean> SPAWNER_DISABLE_ITEM_ANVIL_RENAMING = SettingKey.create("global-spawner-settings.disable-item-anvil-renaming", SettingSerializers.BOOLEAN, false, "Should spawners be prevented from being renamed in anvils?");
    public static final RoseSetting<Boolean> SPAWNER_BYPASS_REGION_SPAWNING_RULES = SettingKey.create("global-spawner-settings.bypass-region-spawning-rules", SettingSerializers.BOOLEAN, true, "Should spawners bypass mob spawning rules of the region?", "If true, a CreatureSpawnEvent will not be fired when a new entity is spawned", "This mostly only applies when entity stacking is disabled");
    public static final RoseSetting<Integer> SPAWNER_SPAWN_COUNT_STACK_SIZE_MULTIPLIER = SettingKey.create("global-spawner-settings.spawn-count-stack-size-multiplier", SettingSerializers.INTEGER, 4, "How many mobs should spawn per stacked spawner?", "Will use spawner tile value if set to -1");
    public static final RoseSetting<Boolean> SPAWNER_SPAWN_COUNT_STACK_SIZE_RANDOMIZED = SettingKey.create("global-spawner-settings.spawn-count-stack-size-randomized", SettingSerializers.BOOLEAN, true, "Should the amount of mobs spawned be randomized between the stack size and the max spawn amount?");
    public static final RoseSetting<Integer> SPAWNER_SPAWN_DELAY_MINIMUM = SettingKey.create("global-spawner-settings.spawn-delay-minimum", SettingSerializers.INTEGER, 200, "The minimum number of ticks between spawn attempts", "Will use spawner tile value if set to -1");
    public static final RoseSetting<Integer> SPAWNER_SPAWN_DELAY_MAXIMUM = SettingKey.create("global-spawner-settings.spawn-delay-maximum", SettingSerializers.INTEGER, 800, "The maximum number of ticks between spawn attempts", "Will use spawner tile value if set to -1");
    public static final RoseSetting<Integer> SPAWNER_SPAWN_MAX_NEARBY_ENTITIES = SettingKey.create("global-spawner-settings.spawn-max-nearby-entities", SettingSerializers.INTEGER, 6, "If more than this number of entities are near the spawner, it will not spawn anything", "This only counts the individual mobs, and not the stack size", "Can be overridden for each spawner type using the max-nearby-entities:# spawn requirement");
    public static final RoseSetting<Integer> SPAWNER_SPAWN_ENTITY_SEARCH_RANGE = SettingKey.create("global-spawner-settings.spawn-entity-search-range", SettingSerializers.INTEGER, -1, "How many blocks away from the spawner should we search for nearby entities when using max-nearby-entities?", "A value of -1 will make this setting use the same value as the spawn range");
    public static final RoseSetting<Integer> SPAWNER_SPAWN_PLAYER_ACTIVATION_RANGE = SettingKey.create("global-spawner-settings.spawn-player-activation-range", SettingSerializers.INTEGER, 16, "How close do players need to be to activate the spawner?", "Will use spawner tile value if set to -1", "Will be unlimited range if set to -2", "This value is measured in blocks");
    public static final RoseSetting<Integer> SPAWNER_SPAWN_RANGE = SettingKey.create("global-spawner-settings.spawn-range", SettingSerializers.INTEGER, 4, "How many blocks away can entities be spawned from the spawner?", "Will use spawner tile value if set to -1");
    public static final RoseSetting<Boolean> SPAWNER_SPAWN_INTO_NEARBY_STACKS = SettingKey.create("global-spawner-settings.spawn-into-nearby-stacks", SettingSerializers.BOOLEAN, true, "Should mobs spawned from spawners spawn directly into nearby stacks?");
    public static final RoseSetting<Boolean> SPAWNER_SPAWN_ONLY_PLAYER_PLACED = SettingKey.create("global-spawner-settings.spawn-only-player-placed", SettingSerializers.BOOLEAN, false, "Should only spawners placed by players spawn mobs?", "Note that a spawner will only be detected if it was generated in the world after RoseStacker was installed");
    public static final RoseSetting<Boolean> SPAWNER_USE_VERTICAL_SPAWN_RANGE = SettingKey.create("global-spawner-settings.use-vertical-spawn-range", SettingSerializers.BOOLEAN, false, "Should the vertical spawn range use the horizontal spawn range?", "Entities normally only spawn one block above and below the spawner");
    public static final RoseSetting<Boolean> SPAWNER_DONT_SPAWN_INTO_BLOCKS = SettingKey.create("global-spawner-settings.dont-spawn-into-blocks", SettingSerializers.BOOLEAN, true, "When enabled, this will force the 'air' condition tag onto the", "spawner if it doesn't have 'fluid' or 'air' already.", "Disabling this will allow mobs to spawn into blocks unless", "you explicitly add the 'fluid' or 'air' tags.");
    public static final RoseSetting<Boolean> SPAWNER_NERF_PATROL_LEADERS = SettingKey.create("global-spawner-settings.nerf-patrol-leaders", SettingSerializers.BOOLEAN, false, "Should patrol leaders be prevented when spawning potential raid member mobs?");
    public static final RoseSetting<Boolean> SPAWNER_MAX_NEARBY_ENTITIES_INCLUDE_STACKS = SettingKey.create("global-spawner-settings.max-nearby-entities-include-stacks", SettingSerializers.BOOLEAN, false, "When enabled, the entire stack size of entities will be taken into account for nearby entiites", "When disabled, only one entity per stack will count towards nearby entities");
    public static final RoseSetting<Boolean> SPAWNER_ITEM_CHECK_DISPLAY_NAME = SettingKey.create("global-spawner-settings.check-name-and-lore", SettingSerializers.BOOLEAN, false, "Should the display name and lore of spawners be checked when determining the spawner item type?", "Helpful for migrating old spawner items from another spawner plugin with unsupported data");
    public static final RoseSetting<Boolean> SPAWNER_GUI_ENABLED = SettingKey.create("global-spawner-settings.gui-enabled", SettingSerializers.BOOLEAN, true, "Should a GUI to view the spawner information open when the player shift-right-clicks the stack?");
    public static final RoseSetting<Integer> SPAWNER_GUI_TICK_UPDATE_RATE = SettingKey.create("global-spawner-settings.gui-tick-update-rate", SettingSerializers.INTEGER, 2, "How often should the time before next spawn message be updated?", "Value is measured in ticks, do not go below 1");
    public static final RoseSetting<String> SPAWNER_GUI_BORDER_MATERIAL = SettingKey.create("global-spawner-settings.gui-border-material", SettingSerializers.STRING, Material.GRAY_STAINED_GLASS_PANE.name(), "What material should be used for the border of the GUI?");
    public static final RoseSetting<String> SPAWNER_GUI_BORDER_CORNER_MATERIAL = SettingKey.create("global-spawner-settings.gui-border-corner-material", SettingSerializers.STRING, Material.LIGHT_BLUE_STAINED_GLASS_PANE.name(), "What material should be used for the top right and bottom left corners of the GUI?");
    public static final RoseSetting<String> SPAWNER_GUI_BORDER_ACCENT_MATERIAL = SettingKey.create("global-spawner-settings.gui-border-accent-material", SettingSerializers.STRING, Material.BLUE_STAINED_GLASS_PANE.name(), "What material should be used for the corner accents of the GUI?");
    public static final RoseSetting<String> SPAWNER_GUI_SPAWNER_STATS_MATERIAL = SettingKey.create("global-spawner-settings.gui-spawner-stats-material", SettingSerializers.STRING, Material.BOOK.name(), "What material should the spawner stats icon be?");
    public static final RoseSetting<String> SPAWNER_GUI_CENTRAL_MATERIAL = SettingKey.create("global-spawner-settings.gui-central-material", SettingSerializers.STRING, Material.SPAWNER.name(), "What material should the central icon be?");
    public static final RoseSetting<String> SPAWNER_GUI_VALID_SPAWN_CONDITIONS_MATERIAL = SettingKey.create("global-spawner-settings.gui-valid-spawn-conditions-material", SettingSerializers.STRING, Material.EMERALD_BLOCK.name(), "What material should the valid spawn conditions icon be?");
    public static final RoseSetting<String> SPAWNER_GUI_INVALID_SPAWN_CONDITIONS_MATERIAL = SettingKey.create("global-spawner-settings.gui-invalid-spawn-conditions-material", SettingSerializers.STRING, Material.REDSTONE_BLOCK.name(), "What material should the invalid spawn conditions icon be?");
    public static final RoseSetting<ConfigurationSection> DYNAMIC_TAG_SETTINGS = SettingKey.create("dynamic-tag-settings", "Settings that apply to the tags above stacks", "These settings require their respective display-tags settings to be set to true to function", "These settings run at the same frequency as the stack-frequency setting", "If you are seeing impacts to server performance, consider disabling these settings");
    public static final RoseSetting<Boolean> ENTITY_DYNAMIC_TAG_VIEW_RANGE_ENABLED = SettingKey.create("dynamic-tag-settings.entity-dynamic-tag-view-range-enabled", SettingSerializers.BOOLEAN, true, "Should entity tags be hidden when the player is a certain distance away?", "Note: This overrides global-entity-settings.display-tags-hover if enabled");
    public static final RoseSetting<Boolean> ITEM_DYNAMIC_TAG_VIEW_RANGE_ENABLED = SettingKey.create("dynamic-tag-settings.item-dynamic-tag-view-range-enabled", SettingSerializers.BOOLEAN, true, "Should item tags be hidden when the player is a certain distance away?");
    public static final RoseSetting<Integer> ENTITY_DYNAMIC_TAG_VIEW_RANGE = SettingKey.create("dynamic-tag-settings.entity-dynamic-tag-view-range", SettingSerializers.INTEGER, 32, "How far away should a player be able to see entity tags?");
    public static final RoseSetting<Integer> ITEM_DYNAMIC_TAG_VIEW_RANGE = SettingKey.create("dynamic-tag-settings.item-dynamic-tag-view-range", SettingSerializers.INTEGER, 32, "How far away should a player be able to see item tags?");
    public static final RoseSetting<Integer> BLOCK_DYNAMIC_TAG_VIEW_RANGE = SettingKey.create("dynamic-tag-settings.block-dynamic-tag-view-range", SettingSerializers.INTEGER, 32, "How far away should a player be able to see block/spawner tags?");
    public static final RoseSetting<Boolean> ENTITY_DYNAMIC_TAG_VIEW_RANGE_WALL_DETECTION_ENABLED = SettingKey.create("dynamic-tag-settings.entity-dynamic-tag-view-range-wall-detection-enabled", SettingSerializers.BOOLEAN, true, "Should entity tags be hidden if they are out of view?");
    public static final RoseSetting<Boolean> ITEM_DYNAMIC_TAG_VIEW_RANGE_WALL_DETECTION_ENABLED = SettingKey.create("dynamic-tag-settings.item-dynamic-tag-view-range-wall-detection-enabled", SettingSerializers.BOOLEAN, true, "Should item tags be hidden if they are out of view?");
    public static final RoseSetting<Boolean> BLOCK_DYNAMIC_TAG_VIEW_RANGE_WALL_DETECTION_ENABLED = SettingKey.create("dynamic-tag-settings.block-dynamic-tag-view-range-wall-detection-enabled", SettingSerializers.BOOLEAN, true, "Should block/spawner tags be hidden if they are out of view?");
    public static final RoseSetting<ConfigurationSection> STACK_TOOL_SETTINGS = SettingKey.create("stack-tool-settings", "Settings that apply to the item given from '/rs stacktool'");
    public static final RoseSetting<String> STACK_TOOL_MATERIAL = SettingKey.create("stack-tool-settings.material", SettingSerializers.STRING, Material.STICK.name(), "The material of the stacking tool");
    public static final RoseSetting<String> STACK_TOOL_NAME = SettingKey.create("stack-tool-settings.name", SettingSerializers.STRING, "<g:#ed3737:#ffaf3e>Stacking Tool", "The name to display on the stacking tool");
    public static final RoseSetting<List<String>> STACK_TOOL_LORE = SettingKey.create("stack-tool-settings.lore", SettingSerializers.STRING_LIST, List.of("&bLeft Click:", "&7- &eSelect two mobs to test if they can stack together.", "&bShift Left Click:", "&7- &eView stack details, works on all stack types.", "&bRight Click:", "&7- &eToggle if a mob is stackable or not.", "&bShift Right Click:", "&7- &eMark an entire entity stack as unstackable.", "&7- &eThis will cause everything to unstack.", "&7- &eIf used on a spawner, will cause it to spawn instantly.", "&bWhile Held:", "&7- &eA particle will appear above nearby mobs.", "&7- &aGreen &emeans the mob can stack.", "&7- &cRed &emeans the mob can not stack."), "The lore to display on the stacking tool");
    public static final RoseSetting<ConfigurationSection> MISC_SETTINGS = SettingKey.create("misc-settings", "Miscellaneous other settings for the plugin");
    public static final RoseSetting<Boolean> MISC_WORLDGUARD_REGION = SettingKey.create("misc-settings.worldguard-region", SettingSerializers.BOOLEAN, false, "Should a custom WorldGuard region named 'rosestacker' be registered and used to test stacking?", "All stacking within regions will only work if the result is ALLOW", "This setting will only be updated after a restart");
    public static final RoseSetting<Boolean> MISC_WORLDGUARD_OBEY_FLAGS = SettingKey.create("misc-settings.worldguard-obey-flags", SettingSerializers.BOOLEAN, true, "Should we try to obey the WorldGuard exp-drops region flag?", "Experience will only drop within regions where the flag is not DENY");
    public static final RoseSetting<Boolean> MISC_COREPROTECT_LOGGING = SettingKey.create("misc-settings.coreprotect-logging-enabled", SettingSerializers.BOOLEAN, true, "If CoreProtect is installed, should we log stacked block/spawner break/placing?");
    public static final RoseSetting<Boolean> MISC_LOGBLOCK_LOGGING = SettingKey.create("misc-settings.logblock-logging-enabled", SettingSerializers.BOOLEAN, true, "If LogBlock is installed, should we log stacked block/spawner break/placing?");
    public static final RoseSetting<Boolean> MISC_INSIGHTS_LOGGING = SettingKey.create("misc-settings.insights-logging-enabled", SettingSerializers.BOOLEAN, true, "If Insights is installed, should we track stacked block/spawner break/placing?");
    public static final RoseSetting<Boolean> MISC_CLEARALL_REMOVE_SINGLE = SettingKey.create("misc-settings.clearall-remove-single", SettingSerializers.BOOLEAN, false, "Should single mobs be removed with `/rs clearall`?");
    public static final RoseSetting<Boolean> MISC_MYTHICMOBS_ALLOW_STACKING = SettingKey.create("misc-settings.mythicmobs-allow-stacking", SettingSerializers.BOOLEAN, false, "Should mobs owned by MythicMobs be allowed to stack?", "This is recommended to keep set to false unless you specifically only change mob attributes", "Having this disabled will also disable the entity instant-stack setting due to the timing of MythicMob spawns");
    public static final RoseSetting<Boolean> MISC_INFERNALMOBS_ALLOW_STACKING = SettingKey.create("misc-settings.infernalmobs-allow-stacking", SettingSerializers.BOOLEAN, false, "Should mobs from InfernalMobs be allowed to stack?", "Recommended to keep set to false to not interfere with InfernalMobs");
    public static final RoseSetting<Boolean> MISC_LEVELLEDMOBS_ALLOW_STACKING = SettingKey.create("misc-settings.levelledmobs-allow-stacking", SettingSerializers.BOOLEAN, false, "Should mobs from LevelledMobs be allowed to stack?", "Recommended to keep set to false to not interfere with LevelledMobs");
    public static final RoseSetting<Boolean> MISC_SPAWNER_PERSISTENT_COMPATIBILITY = SettingKey.create("misc-settings.spawner-persistent-compatibility", SettingSerializers.BOOLEAN, true, "Some plugins like Jobs, mcMMO, and RoseLoot store special data for spawner mobs.", "Disabling this will cause the functionality within those plugins to break.", "The individual plugin hooks can be configured separately below");
    public static final RoseSetting<Boolean> MISC_SPAWNER_JOBS_COMPATIBILITY = SettingKey.create("misc-settings.spawner-jobs-compatibility", SettingSerializers.BOOLEAN, true, "Disabling this will make Jobs no longer recognize spawner entities as spawned from a spawner");
    public static final RoseSetting<Boolean> MISC_SPAWNER_MCMMO_COMPATIBILITY = SettingKey.create("misc-settings.spawner-mcmmo-compatibility", SettingSerializers.BOOLEAN, true, "Disabling this will make mcMMO no longer recognize spawner entities as spawned from a spawner");
    public static final RoseSetting<Boolean> MISC_SPAWNER_ROSELOOT_COMPATIBILITY = SettingKey.create("misc-settings.spawner-roseloot-compatibility", SettingSerializers.BOOLEAN, true, "Disabling this will make RoseLoot no longer recognize spawner entities as spawned from a spawner");
    public static final RoseSetting<Boolean> MISC_STACK_STATISTICS = SettingKey.create("misc-settings.stack-statistics", SettingSerializers.BOOLEAN, true, "Should statistics be accurately tracked for stacked entities?", "This can cause issues if you expect players to kill multiple billion mobs");
    public static final RoseSetting<Boolean> MISC_SPAWNER_LORE_DISPLAY_GLOBAL_LORE_FIRST = SettingKey.create("misc-settings.spawner-lore-display-global-lore-first", SettingSerializers.BOOLEAN, true, "Should global lore be displayed before spawner type lore?");
    public static final RoseSetting<Boolean> MISC_SUPERIOR_SKYBLOCK_STACK_GUI_HOOK = SettingKey.create("misc-settings.superior-skyblock-stack-gui-hook", SettingSerializers.BOOLEAN, true, "Should stacked block/spawner GUIs be blocked from being opened without SuperiorSkyblock2 island break and place permissions?");

    private static <T> RoseSetting<T> create(String key, SettingSerializer<T> serializer, T defaultValue, String ... comments) {
        RoseSetting<T> setting = RoseSetting.ofBackedValue(key, RoseStacker.getInstance(), serializer, defaultValue, comments);
        KEYS.add(setting);
        return setting;
    }

    private static RoseSetting<ConfigurationSection> create(String key, String ... comments) {
        RoseSetting<ConfigurationSection> setting = RoseSetting.ofBackedSection(key, RoseStacker.getInstance(), comments);
        KEYS.add(setting);
        return setting;
    }

    private SettingKey() {
    }

    @Override
    public List<RoseSetting<?>> get() {
        return KEYS;
    }
}

