/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.event;

import dev.rosewood.rosestacker.event.StackEvent;
import dev.rosewood.rosestacker.stack.StackedBlock;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;

public class BlockStackEvent
extends StackEvent<StackedBlock> {
    private static final HandlerList HANDLERS = new HandlerList();
    private final Player player;
    private int increaseAmount;
    private final boolean isNew;

    public BlockStackEvent(@NotNull Player player, @NotNull StackedBlock target, int increaseAmount, boolean isNew) {
        super(target);
        this.player = player;
        this.increaseAmount = increaseAmount;
        this.isNew = isNew;
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    public int getIncreaseAmount() {
        return this.increaseAmount;
    }

    public void setIncreaseAmount(int increaseAmount) {
        if (increaseAmount < 1) {
            throw new IllegalArgumentException("Increase amount must be at least 1");
        }
        this.increaseAmount = increaseAmount;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }
}

