/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.event;

import com.google.common.collect.Multimap;
import dev.rosewood.rosestacker.stack.StackedEntity;
import java.util.List;
import java.util.function.BiFunction;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityStackMultipleDeathEvent
extends Event {
    private static final HandlerList HANDLERS = new HandlerList();
    private final StackedEntity stackedEntity;
    private final Multimap<LivingEntity, EntityDrops> entityDrops;
    private final int originalStackSize;
    private final int entityKillCount;
    private final double multiplier;
    private final LivingEntity mainEntity;
    private final Player killer;
    private final BiFunction<Multimap<LivingEntity, EntityDrops>, Double, EntityDrops> dropsCalculator;

    public EntityStackMultipleDeathEvent(@NotNull StackedEntity stackedEntity, @NotNull Multimap<LivingEntity, EntityDrops> entityDrops, int originalStackSize, int entityKillCount, double multiplier, LivingEntity mainEntity, Player killer, BiFunction<Multimap<LivingEntity, EntityDrops>, Double, EntityDrops> dropsCalculator) {
        super(!Bukkit.isPrimaryThread());
        this.stackedEntity = stackedEntity;
        this.entityDrops = entityDrops;
        this.originalStackSize = originalStackSize;
        this.entityKillCount = entityKillCount;
        this.multiplier = multiplier;
        this.mainEntity = mainEntity;
        this.killer = killer;
        this.dropsCalculator = dropsCalculator;
    }

    @NotNull
    public StackedEntity getStack() {
        return this.stackedEntity;
    }

    @NotNull
    public Multimap<LivingEntity, EntityDrops> getEntityDrops() {
        return this.entityDrops;
    }

    public int getOriginalStackSize() {
        return this.originalStackSize;
    }

    public int getEntityKillCount() {
        return this.entityKillCount;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    @NotNull
    public LivingEntity getMainEntity() {
        return this.mainEntity;
    }

    @Nullable
    public Player getKiller() {
        return this.killer;
    }

    public EntityDrops calculateFinalEntityDrops() {
        return this.dropsCalculator.apply(this.entityDrops, this.multiplier);
    }

    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }

    public static class EntityDrops {
        private final List<ItemStack> drops;
        private int experience;

        public EntityDrops(@NotNull List<ItemStack> drops, int experience) {
            this.drops = drops;
            this.experience = experience;
        }

        @NotNull
        public List<ItemStack> getDrops() {
            return this.drops;
        }

        public int getExperience() {
            return this.experience;
        }

        public void setExperience(int experience) {
            this.experience = experience;
        }
    }
}

