/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.event;

import dev.rosewood.rosestacker.event.UnstackEvent;
import dev.rosewood.rosestacker.stack.StackedSpawner;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpawnerUnstackEvent
extends UnstackEvent<StackedSpawner> {
    private static final HandlerList HANDLERS = new HandlerList();
    private final Player player;
    private int decreaseAmount;

    public SpawnerUnstackEvent(@Nullable Player player, @NotNull StackedSpawner target, int decreaseAmount) {
        super(target);
        this.player = player;
        this.decreaseAmount = decreaseAmount;
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    public int getDecreaseAmount() {
        return this.decreaseAmount;
    }

    public void setDecreaseAmount(int decreaseAmount) {
        if (decreaseAmount < 1) {
            throw new IllegalArgumentException("Decrease amount must be at least 1");
        }
        if (decreaseAmount < ((StackedSpawner)this.stack).getStackSize()) {
            throw new IllegalArgumentException("Decrease amount must not be larger than the total stack size");
        }
        this.decreaseAmount = decreaseAmount;
    }

    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }
}

