/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.gui;

import dev.rosewood.rosestacker.RoseStacker;
import dev.rosewood.rosestacker.config.SettingKey;
import dev.rosewood.rosestacker.event.BlockStackEvent;
import dev.rosewood.rosestacker.event.BlockUnstackEvent;
import dev.rosewood.rosestacker.gui.GuiHelper;
import dev.rosewood.rosestacker.lib.guiframework.GuiFactory;
import dev.rosewood.rosestacker.lib.guiframework.GuiFramework;
import dev.rosewood.rosestacker.lib.guiframework.framework.gui.FrameworkView;
import dev.rosewood.rosestacker.lib.guiframework.framework.util.GuiUtil;
import dev.rosewood.rosestacker.lib.guiframework.gui.ClickAction;
import dev.rosewood.rosestacker.lib.guiframework.gui.ClickActionType;
import dev.rosewood.rosestacker.lib.guiframework.gui.GuiButtonFlag;
import dev.rosewood.rosestacker.lib.guiframework.gui.GuiContainer;
import dev.rosewood.rosestacker.lib.guiframework.gui.GuiSize;
import dev.rosewood.rosestacker.lib.guiframework.gui.screen.GuiScreen;
import dev.rosewood.rosestacker.lib.guiframework.gui.screen.GuiScreenSection;
import dev.rosewood.rosestacker.lib.rosegarden.RosePlugin;
import dev.rosewood.rosestacker.lib.rosegarden.utils.NMSUtil;
import dev.rosewood.rosestacker.lib.rosegarden.utils.StringPlaceholders;
import dev.rosewood.rosestacker.manager.LocaleManager;
import dev.rosewood.rosestacker.manager.StackManager;
import dev.rosewood.rosestacker.stack.StackedBlock;
import dev.rosewood.rosestacker.stack.settings.BlockStackSettings;
import dev.rosewood.rosestacker.utils.ItemUtils;
import dev.rosewood.rosestacker.utils.ThreadUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class StackedBlockGui {
    private final RosePlugin rosePlugin = RoseStacker.getInstance();
    private final StackedBlock stackedBlock;
    private final GuiFramework guiFramework;
    private GuiContainer guiContainer;
    private Material stackType;

    public StackedBlockGui(StackedBlock stackedBlock) {
        this.stackedBlock = stackedBlock;
        this.guiFramework = GuiFramework.instantiate((Plugin)this.rosePlugin);
        this.guiContainer = null;
    }

    public void openFor(Player player) {
        if (this.isInvalid()) {
            this.buildGui();
        }
        this.guiContainer.openFor(player);
        FrameworkView view = (FrameworkView)this.guiContainer.getCurrentViewers().get(player.getUniqueId());
        if (view != null) {
            view.setViewingPage(view.getViewingScreen().getMaximumPageNumber() - 1);
            player.openInventory(view.getViewingScreen().getInventory(view.getViewingPage()));
        }
    }

    private void buildGui() {
        int i;
        int i2;
        this.stackType = this.stackedBlock.getBlock().getType();
        this.guiContainer = GuiFactory.createContainer().preventItemDropping(true);
        ArrayList<Integer> paginatedSlots = new ArrayList<Integer>();
        for (i2 = 10; i2 <= 16; ++i2) {
            paginatedSlots.add(i2);
        }
        for (i2 = 19; i2 <= 25; ++i2) {
            paginatedSlots.add(i2);
        }
        for (i2 = 28; i2 <= 34; ++i2) {
            paginatedSlots.add(i2);
        }
        for (i2 = 37; i2 <= 43; ++i2) {
            paginatedSlots.add(i2);
        }
        ArrayList<Integer> borderSlots = new ArrayList<Integer>();
        for (i = 0; i <= 8; ++i) {
            borderSlots.add(i);
        }
        for (i = 9; i <= 36; i += 9) {
            borderSlots.add(i);
        }
        for (i = 17; i <= 44; i += 9) {
            borderSlots.add(i);
        }
        for (i = 46; i <= 52; i += 2) {
            borderSlots.add(i);
        }
        borderSlots.addAll(List.of(Integer.valueOf(45), Integer.valueOf(53)));
        ItemStack borderItem = new ItemStack(GuiHelper.parseMaterial(SettingKey.BLOCK_GUI_BORDER_MATERIAL.get()));
        ItemMeta itemMeta = borderItem.getItemMeta();
        if (itemMeta != null) {
            itemMeta.setDisplayName(" ");
            if (NMSUtil.getVersionNumber() >= 21) {
                itemMeta.setHideTooltip(true);
            } else {
                itemMeta.addItemFlags(ItemFlag.values());
            }
            borderItem.setItemMeta(itemMeta);
        }
        ArrayList<Integer> destroyBorderSlots = new ArrayList<Integer>();
        for (int i3 = 0; i3 <= 26; ++i3) {
            destroyBorderSlots.add(i3);
        }
        destroyBorderSlots.removeAll(List.of(Integer.valueOf(12), Integer.valueOf(14)));
        GuiScreenSection editableSection = GuiFactory.createScreenSection(paginatedSlots);
        LocaleManager localeManager = this.rosePlugin.getManager(LocaleManager.class);
        BlockStackSettings stackSettings = this.stackedBlock.getStackSettings();
        GuiHelper.GuiStringHelper pageBackString = new GuiHelper.GuiStringHelper(localeManager.getLocaleMessages("gui-stacked-block-page-back", StringPlaceholders.empty()));
        GuiHelper.GuiStringHelper destroyString = new GuiHelper.GuiStringHelper(localeManager.getLocaleMessages("gui-stacked-block-destroy", StringPlaceholders.empty()));
        GuiHelper.GuiStringHelper pageForwardString = new GuiHelper.GuiStringHelper(localeManager.getLocaleMessages("gui-stacked-block-page-forward", StringPlaceholders.empty()));
        GuiHelper.GuiStringHelper confirmDestroyString = new GuiHelper.GuiStringHelper(localeManager.getLocaleMessages("gui-stacked-block-destroy-confirm", StringPlaceholders.empty()));
        GuiHelper.GuiStringHelper confirmCancelString = new GuiHelper.GuiStringHelper(localeManager.getLocaleMessages("gui-stacked-block-destroy-cancel", StringPlaceholders.empty()));
        List<ItemStack> stackItems = GuiUtil.getMaterialAmountAsItemStacks(this.stackType, this.stackedBlock.getStackSize());
        int pages = (int)Math.ceil((double)stackItems.size() / (double)paginatedSlots.size()) + 1;
        while (stackItems.size() < pages * paginatedSlots.size()) {
            stackItems.add(new ItemStack(Material.AIR));
        }
        GuiScreen mainScreen = GuiFactory.createScreen(this.guiContainer, GuiSize.ROWS_SIX).setTitle(localeManager.getLocaleMessage("gui-stacked-block-title", StringPlaceholders.of("name", stackSettings.getDisplayName()))).setEditableSection(editableSection, stackItems, this::updateStackedBlock).setEditFilters(GuiFactory.createScreenEditFilters().setWhitelist(this.stackType).setAllowModified(false)).addButtonAt(47, GuiFactory.createButton().setIcon(Material.PAPER).setName(pageBackString.getName()).setLore(pageBackString.getLore()).setClickAction(event -> ClickAction.PAGE_BACKWARDS, new ClickActionType[0]).setFlags(GuiButtonFlag.HIDE_IF_FIRST_PAGE).setHiddenReplacement(borderItem)).addButtonAt(49, GuiFactory.createButton().setIcon(Material.BARRIER).setName(destroyString.getName()).setLore(destroyString.getLore()).setClickAction(event -> ClickAction.TRANSITION_FORWARDS, new ClickActionType[0])).addButtonAt(51, GuiFactory.createButton().setIcon(Material.PAPER).setName(pageForwardString.getName()).setLore(pageForwardString.getLore()).setClickAction(event -> ClickAction.PAGE_FORWARDS, new ClickActionType[0]).setFlags(GuiButtonFlag.HIDE_IF_LAST_PAGE).setHiddenReplacement(borderItem));
        Iterator iterator = borderSlots.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            mainScreen.addItemStackAt(slot, borderItem);
        }
        GuiScreen confirmScreen = GuiFactory.createScreen(this.guiContainer, GuiSize.ROWS_THREE).setTitle(localeManager.getLocaleMessage("gui-stacked-block-destroy-title", StringPlaceholders.of("name", stackSettings.getDisplayName()))).addButtonAt(12, GuiFactory.createButton().setIcon(Material.EMERALD_BLOCK).setName(confirmDestroyString.getName()).setLore(confirmDestroyString.getLore()).setClickAction(event -> {
            this.destroyStackedBlock((Player)event.getWhoClicked());
            return ClickAction.NOTHING;
        }, new ClickActionType[0])).addButtonAt(14, GuiFactory.createButton().setIcon(Material.REDSTONE_BLOCK).setName(confirmCancelString.getName()).setLore(confirmCancelString.getLore()).setClickAction(event -> ClickAction.TRANSITION_BACKWARDS, new ClickActionType[0]));
        Iterator iterator2 = destroyBorderSlots.iterator();
        while (iterator2.hasNext()) {
            int slot = (Integer)iterator2.next();
            confirmScreen.addItemStackAt(slot, borderItem);
        }
        this.guiContainer.addScreen(mainScreen);
        this.guiContainer.addScreen(confirmScreen);
        this.guiFramework.getGuiManager().registerGui(this.guiContainer);
    }

    public void kickOutViewers() {
        if (this.guiContainer != null) {
            this.guiContainer.closeViewers();
        }
    }

    public boolean hasViewers() {
        return this.guiContainer != null;
    }

    private void updateStackedBlock(Player player, List<ItemStack> items) {
        int stackSize;
        int difference;
        StackManager stackManager = this.rosePlugin.getManager(StackManager.class);
        this.guiContainer = null;
        int newStackSize = items.stream().filter(Objects::nonNull).mapToInt(ItemStack::getAmount).sum();
        if (newStackSize == this.stackedBlock.getStackSize()) {
            return;
        }
        int maxStackSize = this.stackedBlock.getStackSettings().getMaxStackSize();
        if (newStackSize > maxStackSize) {
            List<ItemStack> overflowItems = GuiUtil.getMaterialAmountAsItemStacks(this.stackType, newStackSize - maxStackSize);
            ItemUtils.dropItemsToPlayer(player, overflowItems);
            newStackSize = maxStackSize;
        }
        if ((difference = newStackSize - (stackSize = this.stackedBlock.getStackSize())) == 0) {
            return;
        }
        if (newStackSize > stackSize) {
            BlockStackEvent blockStackEvent = new BlockStackEvent(player, this.stackedBlock, difference, false);
            Bukkit.getPluginManager().callEvent((Event)blockStackEvent);
            if (blockStackEvent.isCancelled()) {
                ItemUtils.dropItemsToPlayer(player, GuiUtil.getMaterialAmountAsItemStacks(this.stackType, difference));
                return;
            }
            newStackSize = stackSize + blockStackEvent.getIncreaseAmount();
        } else {
            BlockUnstackEvent blockUnstackEvent = new BlockUnstackEvent(player, this.stackedBlock, -difference);
            Bukkit.getPluginManager().callEvent((Event)blockUnstackEvent);
            if (blockUnstackEvent.isCancelled()) {
                this.takeFromPlayer(player, -difference);
                return;
            }
            newStackSize = stackSize - blockUnstackEvent.getDecreaseAmount();
        }
        if (newStackSize > maxStackSize) {
            newStackSize = maxStackSize;
        }
        if (newStackSize < 0) {
            newStackSize = 0;
        }
        this.stackedBlock.setStackSize(newStackSize);
        if (newStackSize == 1) {
            stackManager.removeBlockStack(this.stackedBlock);
        } else if (newStackSize == 0) {
            stackManager.removeBlockStack(this.stackedBlock);
            this.stackedBlock.getBlock().setType(Material.AIR);
        }
    }

    private void takeFromPlayer(Player player, int amount) {
        ItemStack[] contents;
        PlayerInventory playerInventory = player.getInventory();
        for (ItemStack itemStack : contents = playerInventory.getContents()) {
            if (itemStack == null || itemStack.getType() != this.stackType) continue;
            int amountToTake = Math.min(amount, itemStack.getAmount());
            itemStack.setAmount(itemStack.getAmount() - amountToTake);
            if ((amount -= amountToTake) == 0) break;
        }
        playerInventory.setContents(contents);
    }

    private void destroyStackedBlock(Player player) {
        this.kickOutViewers();
        if (this.stackedBlock.getStackSize() == 0) {
            return;
        }
        StackManager stackManager = this.rosePlugin.getManager(StackManager.class);
        ThreadUtils.runSync(() -> {
            BlockUnstackEvent blockUnstackEvent = new BlockUnstackEvent(player, this.stackedBlock, this.stackedBlock.getStackSize());
            Bukkit.getPluginManager().callEvent((Event)blockUnstackEvent);
            if (blockUnstackEvent.isCancelled()) {
                return;
            }
            List<ItemStack> itemsToDrop = SettingKey.BLOCK_BREAK_ENTIRE_STACK_INTO_SEPARATE.get() != false ? GuiUtil.getMaterialAmountAsItemStacks(this.stackType, blockUnstackEvent.getDecreaseAmount()) : List.of(ItemUtils.getBlockAsStackedItemStack(this.stackType, blockUnstackEvent.getDecreaseAmount()));
            if (SettingKey.BLOCK_DROP_TO_INVENTORY.get().booleanValue()) {
                ItemUtils.dropItemsToPlayer(player, itemsToDrop);
            } else {
                stackManager.preStackItems(itemsToDrop, this.stackedBlock.getLocation().add(0.5, 0.5, 0.5));
            }
            this.stackedBlock.setStackSize(this.stackedBlock.getStackSize() - blockUnstackEvent.getDecreaseAmount());
            if (this.stackedBlock.getStackSize() <= 0) {
                stackManager.removeBlockStack(this.stackedBlock);
                this.stackedBlock.getBlock().setType(Material.AIR);
                this.stackedBlock.getBlock().getWorld().playSound(this.stackedBlock.getBlock().getLocation(), Sound.BLOCK_ANVIL_LAND, 0.1f, 0.01f);
            }
        });
    }

    private boolean isInvalid() {
        return this.guiContainer == null || !this.guiFramework.getGuiManager().getActiveGuis().contains(this.guiContainer);
    }
}

