/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.hook;

import de.diddiz.LogBlock.Actor;
import de.diddiz.LogBlock.Consumer;
import de.diddiz.LogBlock.LogBlock;
import dev.rosewood.rosestacker.config.SettingKey;
import dev.rosewood.rosestacker.hook.InsightsHook;
import net.coreprotect.CoreProtect;
import net.coreprotect.CoreProtectAPI;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BlockLoggingHook {
    private static Boolean coreProtectEnabled;
    private static CoreProtectAPI coreProtectAPI;
    private static Boolean logBlockEnabled;
    private static Consumer logBlockConsumer;
    private static Boolean insightsEnabled;

    public static boolean coreProtectEnabled() {
        if (!SettingKey.MISC_COREPROTECT_LOGGING.get().booleanValue()) {
            return false;
        }
        if (coreProtectEnabled != null) {
            return coreProtectEnabled;
        }
        Plugin plugin = Bukkit.getPluginManager().getPlugin("CoreProtect");
        if (plugin != null) {
            coreProtectAPI = ((CoreProtect)plugin).getAPI();
            coreProtectEnabled = coreProtectAPI.isEnabled();
            return coreProtectEnabled;
        }
        coreProtectEnabled = false;
        return coreProtectEnabled;
    }

    public static boolean logBlockEnabled() {
        if (!SettingKey.MISC_LOGBLOCK_LOGGING.get().booleanValue()) {
            return false;
        }
        if (logBlockEnabled != null) {
            return logBlockEnabled;
        }
        Plugin plugin = Bukkit.getPluginManager().getPlugin("LogBlock");
        if (plugin != null) {
            logBlockConsumer = ((LogBlock)plugin).getConsumer();
            logBlockEnabled = true;
            return logBlockEnabled;
        }
        logBlockEnabled = false;
        return logBlockEnabled;
    }

    public static boolean insightsEnabled() {
        if (!SettingKey.MISC_INSIGHTS_LOGGING.get().booleanValue()) {
            return false;
        }
        if (insightsEnabled != null) {
            return insightsEnabled;
        }
        insightsEnabled = Bukkit.getPluginManager().getPlugin("Insights") != null;
        return insightsEnabled;
    }

    public static void recordBlockPlace(Player player, Block block) {
        if (BlockLoggingHook.coreProtectEnabled()) {
            Material type = block.getType();
            BlockData blockData = null;
            if (type == Material.SPAWNER) {
                blockData = block.getBlockData();
            }
            coreProtectAPI.logPlacement(player.getName(), block.getLocation(), type, blockData);
        }
        if (BlockLoggingHook.logBlockEnabled()) {
            logBlockConsumer.queueBlockPlace(new Actor(player.getName(), player.getUniqueId()), block.getState());
        }
        if (BlockLoggingHook.insightsEnabled()) {
            InsightsHook.modifyBlockAmount(block, 1);
        }
    }

    public static void recordBlockBreak(Player player, Block block) {
        if (BlockLoggingHook.coreProtectEnabled()) {
            Material type = block.getType();
            BlockData blockData = null;
            if (type == Material.SPAWNER) {
                blockData = block.getBlockData();
            }
            coreProtectAPI.logRemoval(player.getName(), block.getLocation(), type, blockData);
        }
        if (BlockLoggingHook.logBlockEnabled()) {
            logBlockConsumer.queueBlockBreak(new Actor(player.getName(), player.getUniqueId()), block.getState());
        }
        if (BlockLoggingHook.insightsEnabled()) {
            InsightsHook.modifyBlockAmount(block, -1);
        }
    }
}

