/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.hook;

import com.magmaguy.elitemobs.entitytracker.EntityTracker;
import com.nisovin.shopkeepers.api.ShopkeepersAPI;
import com.songoda.epicbosses.EpicBosses;
import dev.rosewood.rosestacker.config.SettingKey;
import dev.rosewood.rosestacker.lib.rosegarden.utils.StringPlaceholders;
import io.hotmail.com.jacob_vejvoda.infernal_mobs.infernal_mobs;
import io.lumine.mythic.bukkit.MythicBukkit;
import net.bestemor.villagermarket.VillagerMarketAPI;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.persistence.PersistentDataType;
import simplepets.brainsynder.api.plugin.SimplePets;

public class NPCsHook {
    private static Boolean mythicMobsEnabled;
    private static Boolean citizensEnabled;
    private static Boolean shopkeepersEnabled;
    private static Boolean epicBossesEnabled;
    private static Boolean eliteMobsEnabled;
    private static Boolean bossEnabled;
    private static Boolean proCosmeticsEnabled;
    private static Boolean infernalMobsEnabled;
    private static Boolean simplePetsEnabled;
    private static Boolean levelledMobsEnabled;
    private static Boolean villagerMarketEnabled;
    private static final NamespacedKey LEVELLEDMOBS_KEY;

    public static boolean citizensEnabled() {
        if (citizensEnabled != null) {
            return citizensEnabled;
        }
        citizensEnabled = Bukkit.getPluginManager().isPluginEnabled("Citizens");
        return citizensEnabled;
    }

    public static boolean shopkeepersEnabled() {
        if (shopkeepersEnabled != null) {
            return shopkeepersEnabled;
        }
        shopkeepersEnabled = Bukkit.getPluginManager().isPluginEnabled("Shopkeepers");
        return shopkeepersEnabled;
    }

    public static boolean mythicMobsEnabled() {
        if (mythicMobsEnabled != null) {
            return mythicMobsEnabled;
        }
        mythicMobsEnabled = Bukkit.getPluginManager().isPluginEnabled("MythicMobs");
        return mythicMobsEnabled;
    }

    public static boolean epicBossesEnabled() {
        if (epicBossesEnabled != null) {
            return epicBossesEnabled;
        }
        epicBossesEnabled = Bukkit.getPluginManager().isPluginEnabled("EpicBosses");
        return epicBossesEnabled;
    }

    public static boolean eliteMobsEnabled() {
        if (eliteMobsEnabled != null) {
            return eliteMobsEnabled;
        }
        eliteMobsEnabled = Bukkit.getPluginManager().isPluginEnabled("EliteMobs");
        return eliteMobsEnabled;
    }

    public static boolean bossEnabled() {
        if (bossEnabled != null) {
            return bossEnabled;
        }
        bossEnabled = Bukkit.getPluginManager().isPluginEnabled("Boss");
        return bossEnabled;
    }

    public static boolean proCosmeticsEnabled() {
        if (proCosmeticsEnabled != null) {
            return proCosmeticsEnabled;
        }
        proCosmeticsEnabled = Bukkit.getPluginManager().isPluginEnabled("ProCosmetics");
        return proCosmeticsEnabled;
    }

    public static boolean infernalMobsEnabled() {
        if (infernalMobsEnabled != null) {
            return infernalMobsEnabled;
        }
        infernalMobsEnabled = Bukkit.getPluginManager().isPluginEnabled("InfernalMobs");
        return infernalMobsEnabled;
    }

    public static boolean simplePetsEnabled() {
        if (simplePetsEnabled != null) {
            return simplePetsEnabled;
        }
        boolean enabled = Bukkit.getPluginManager().isPluginEnabled("SimplePets");
        if (!enabled) {
            simplePetsEnabled = false;
            return simplePetsEnabled;
        }
        try {
            Class.forName("simplepets.brainsynder.api.plugin.SimplePets");
        }
        catch (ClassNotFoundException e) {
            simplePetsEnabled = false;
            return simplePetsEnabled;
        }
        simplePetsEnabled = true;
        return simplePetsEnabled;
    }

    public static boolean levelledMobsEnabled() {
        if (levelledMobsEnabled != null) {
            return levelledMobsEnabled;
        }
        levelledMobsEnabled = Bukkit.getPluginManager().isPluginEnabled("LevelledMobs");
        return levelledMobsEnabled;
    }

    public static boolean villagerMarketEnabled() {
        if (villagerMarketEnabled != null) {
            return villagerMarketEnabled;
        }
        villagerMarketEnabled = Bukkit.getPluginManager().isPluginEnabled("VillagerMarket");
        return villagerMarketEnabled;
    }

    public static boolean anyEnabled() {
        return NPCsHook.citizensEnabled() || NPCsHook.shopkeepersEnabled() || NPCsHook.mythicMobsEnabled() || NPCsHook.epicBossesEnabled() || NPCsHook.eliteMobsEnabled() || NPCsHook.bossEnabled() || NPCsHook.proCosmeticsEnabled() || NPCsHook.infernalMobsEnabled() || NPCsHook.simplePetsEnabled() || NPCsHook.levelledMobsEnabled() || NPCsHook.villagerMarketEnabled();
    }

    public static boolean isNPC(LivingEntity entity) {
        boolean npc = false;
        if (NPCsHook.citizensEnabled() && CitizensAPI.hasImplementation()) {
            npc = CitizensAPI.getNPCRegistry().isNPC((Entity)entity);
        }
        if (!npc && NPCsHook.shopkeepersEnabled() && ShopkeepersAPI.isEnabled()) {
            npc = ShopkeepersAPI.getShopkeeperRegistry().isShopkeeper((Entity)entity);
        }
        if (!npc && NPCsHook.mythicMobsEnabled() && !SettingKey.MISC_MYTHICMOBS_ALLOW_STACKING.get().booleanValue()) {
            npc = MythicBukkit.inst().getAPIHelper().isMythicMob((Entity)entity);
        }
        if (!npc && NPCsHook.epicBossesEnabled()) {
            boolean bl = npc = EpicBosses.getInstance().getBossEntityManager().getActiveBossHolder(entity) != null;
        }
        if (!npc && NPCsHook.eliteMobsEnabled()) {
            boolean bl = npc = EntityTracker.isEliteMob((Entity)entity) && EntityTracker.isNPCEntity((Entity)entity);
        }
        if (!npc && NPCsHook.bossEnabled()) {
            npc = entity.hasMetadata("Boss_V4");
        }
        if (!npc && NPCsHook.proCosmeticsEnabled()) {
            npc = entity.hasMetadata("PROCOSMETICS_ENTITY");
        }
        if (!npc && NPCsHook.infernalMobsEnabled() && !SettingKey.MISC_INFERNALMOBS_ALLOW_STACKING.get().booleanValue()) {
            infernal_mobs plugin = (infernal_mobs)Bukkit.getPluginManager().getPlugin("InfernalMobs");
            boolean bl = npc = plugin != null && plugin.idSearch(entity.getUniqueId()) >= 0;
        }
        if (!npc && NPCsHook.simplePetsEnabled()) {
            npc = SimplePets.isPetEntity((Entity)entity);
        }
        if (!npc && NPCsHook.levelledMobsEnabled() && !SettingKey.MISC_LEVELLEDMOBS_ALLOW_STACKING.get().booleanValue()) {
            npc = entity.getPersistentDataContainer().has(LEVELLEDMOBS_KEY, PersistentDataType.INTEGER);
        }
        if (!npc && NPCsHook.villagerMarketEnabled()) {
            npc = VillagerMarketAPI.getShopManager().isShop((Entity)entity);
        }
        return npc;
    }

    public static void addCustomPlaceholders(LivingEntity entity, StringPlaceholders.Builder placeholders) {
        if (NPCsHook.levelledMobsEnabled()) {
            Integer level = (Integer)entity.getPersistentDataContainer().get(LEVELLEDMOBS_KEY, PersistentDataType.INTEGER);
            placeholders.add("levelledmobs_level", level == null ? 0 : level);
        }
    }

    static {
        LEVELLEDMOBS_KEY = new NamespacedKey("levelledmobs", "level");
    }
}

