/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.hook;

import dev.rosewood.rosestacker.lib.rosegarden.RosePlugin;
import dev.rosewood.rosestacker.lib.rosegarden.utils.StringPlaceholders;
import dev.rosewood.rosestacker.manager.LocaleManager;
import dev.rosewood.rosestacker.utils.StackerUtils;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;

public class RoseStackerPlaceholderExpansion
extends PlaceholderExpansion {
    private final RosePlugin plugin;

    public RoseStackerPlaceholderExpansion(RosePlugin plugin) {
        this.plugin = plugin;
    }

    public String onPlaceholderRequest(Player player, String placeholder) {
        if (player == null) {
            return null;
        }
        LocaleManager localeManager = this.plugin.getManager(LocaleManager.class);
        return switch (placeholder) {
            case "spawner_silktouch_chance" -> localeManager.getLocaleMessage("silktouch-chance-placeholder", StringPlaceholders.of("chance", Math.round(StackerUtils.getSilkTouchChanceRaw(player))));
            default -> null;
        };
    }

    public boolean persist() {
        return true;
    }

    public String getIdentifier() {
        return this.plugin.getDescription().getName().toLowerCase();
    }

    public String getAuthor() {
        return (String)this.plugin.getDescription().getAuthors().get(0);
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }
}

