/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.hook;

import com.gamingmesh.jobs.container.JobsMobSpawner;
import com.gmail.nossr50.metadata.MobMetaFlagType;
import com.gmail.nossr50.util.MobMetadataUtils;
import dev.rosewood.roseloot.util.LootUtils;
import dev.rosewood.rosestacker.RoseStacker;
import dev.rosewood.rosestacker.config.SettingKey;
import dev.rosewood.rosestacker.lib.rosegarden.utils.NMSUtil;
import dev.rosewood.rosestacker.nms.NMSAdapter;
import dev.rosewood.rosestacker.utils.PersistentDataUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;

public class SpawnerFlagPersistenceHook {
    private static Boolean mcMMOEnabled;
    private static Boolean jobsEnabled;
    private static Boolean roseLootEnabled;
    private static boolean displayedMcMMOMessage;

    public static boolean mcMMOEnabled() {
        block4: {
            if (mcMMOEnabled != null) {
                return mcMMOEnabled;
            }
            Plugin plugin = Bukkit.getPluginManager().getPlugin("mcMMO");
            mcMMOEnabled = plugin != null && plugin.getDescription().getVersion().startsWith("2") && NMSUtil.getVersionNumber() >= 18;
            if (mcMMOEnabled.booleanValue()) {
                try {
                    Class.forName("com.gmail.nossr50.util.MobMetadataUtils");
                }
                catch (ClassNotFoundException e) {
                    mcMMOEnabled = false;
                    if (displayedMcMMOMessage) break block4;
                    RoseStacker.getInstance().getLogger().severe("mcMMO is enabled, but the required com.gmail.nossr50.util.MobMetadataUtils class is not found. Your mcMMO version is either too old or too new for RoseStacker to support. The mcMMO hook has been disabled.");
                    displayedMcMMOMessage = true;
                }
            }
        }
        return mcMMOEnabled;
    }

    public static boolean jobsEnabled() {
        if (jobsEnabled != null) {
            return jobsEnabled;
        }
        jobsEnabled = Bukkit.getPluginManager().getPlugin("Jobs") != null;
        return jobsEnabled;
    }

    public static boolean roseLootEnabled() {
        if (roseLootEnabled != null) {
            return roseLootEnabled;
        }
        roseLootEnabled = Bukkit.getPluginManager().getPlugin("RoseLoot") != null;
        return roseLootEnabled;
    }

    public static void flagSpawnerSpawned(LivingEntity entity) {
        if (!SettingKey.MISC_SPAWNER_PERSISTENT_COMPATIBILITY.get().booleanValue()) {
            return;
        }
        if (SettingKey.MISC_SPAWNER_MCMMO_COMPATIBILITY.get().booleanValue() && SpawnerFlagPersistenceHook.mcMMOEnabled()) {
            MobMetadataUtils.flagMetadata((MobMetaFlagType)MobMetaFlagType.MOB_SPAWNER_MOB, (LivingEntity)entity);
        }
        if (SettingKey.MISC_SPAWNER_JOBS_COMPATIBILITY.get().booleanValue() && SpawnerFlagPersistenceHook.jobsEnabled()) {
            JobsMobSpawner.setSpawnerMeta((Entity)entity);
        }
        if (SettingKey.MISC_SPAWNER_ROSELOOT_COMPATIBILITY.get().booleanValue() && SpawnerFlagPersistenceHook.roseLootEnabled()) {
            LootUtils.setEntitySpawnReason((LivingEntity)entity, (CreatureSpawnEvent.SpawnReason)CreatureSpawnEvent.SpawnReason.SPAWNER);
        }
        NMSAdapter.getHandler().setPaperFromMobSpawner((Entity)entity);
    }

    public static void unflagSpawnerSpawned(LivingEntity entity) {
        if (!SettingKey.MISC_SPAWNER_PERSISTENT_COMPATIBILITY.get().booleanValue()) {
            return;
        }
        if (SettingKey.MISC_SPAWNER_MCMMO_COMPATIBILITY.get().booleanValue() && SpawnerFlagPersistenceHook.mcMMOEnabled()) {
            MobMetadataUtils.removeMobFlag((MobMetaFlagType)MobMetaFlagType.MOB_SPAWNER_MOB, (LivingEntity)entity);
        }
        if (SettingKey.MISC_SPAWNER_JOBS_COMPATIBILITY.get().booleanValue() && SpawnerFlagPersistenceHook.jobsEnabled()) {
            JobsMobSpawner.removeSpawnerMeta((Entity)entity);
        }
    }

    public static void setPersistence(LivingEntity entity) {
        if (!PersistentDataUtils.isSpawnedFromSpawner((Entity)entity)) {
            return;
        }
        SpawnerFlagPersistenceHook.flagSpawnerSpawned(entity);
    }
}

