/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.hook;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import dev.rosewood.rosestacker.config.SettingKey;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class WorldGuardFlagHook {
    private static StateFlag flag;

    public static void registerFlag() {
        if (!SettingKey.MISC_WORLDGUARD_REGION.get().booleanValue()) {
            return;
        }
        flag = new StateFlag("rosestacker", true);
        WorldGuard.getInstance().getFlagRegistry().register((Flag)flag);
    }

    public static boolean testLocation(Location location) {
        if (!SettingKey.MISC_WORLDGUARD_REGION.get().booleanValue()) {
            return true;
        }
        RegionQuery regionQuery = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
        return regionQuery.testState(BukkitAdapter.adapt((Location)location), null, new StateFlag[]{flag});
    }

    public static boolean testCanDropExperience(Player player, Location location) {
        return WorldGuardFlagHook.testFlag(player, location, Flags.EXP_DROPS);
    }

    private static boolean testFlag(Player player, Location location, StateFlag flag) {
        LocalPlayer localPlayer;
        if (!SettingKey.MISC_WORLDGUARD_OBEY_FLAGS.get().booleanValue()) {
            return true;
        }
        LocalPlayer localPlayer2 = localPlayer = player != null ? WorldGuardPlugin.inst().wrapPlayer(player) : null;
        if (localPlayer != null && WorldGuard.getInstance().getPlatform().getSessionManager().hasBypass(localPlayer, BukkitAdapter.adapt((World)location.getWorld()))) {
            return true;
        }
        RegionQuery regionQuery = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
        return regionQuery.testState(BukkitAdapter.adapt((Location)location), localPlayer, new StateFlag[]{flag});
    }
}

