/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.guiframework;

import com.google.common.base.Preconditions;
import dev.rosewood.rosestacker.lib.guiframework.framework.gui.listeners.InventoryListener;
import dev.rosewood.rosestacker.lib.guiframework.framework.gui.manager.FrameworkManager;
import dev.rosewood.rosestacker.lib.guiframework.gui.manager.GuiManager;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class GuiFramework {
    private static GuiFramework INSTANCE;
    private FrameworkManager guiManager;
    private Plugin hookedPlugin;

    private GuiFramework(@NotNull Plugin plugin) {
        this.guiManager = new FrameworkManager(plugin);
        this.hookedPlugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)new InventoryListener(this.guiManager), plugin);
    }

    @NotNull
    public GuiManager getGuiManager() {
        return this.guiManager;
    }

    @NotNull
    public Plugin getHookedPlugin() {
        return this.hookedPlugin;
    }

    @NotNull
    public static GuiFramework instantiate(@NotNull Plugin plugin) {
        if (INSTANCE == null) {
            INSTANCE = new GuiFramework(plugin);
        }
        return INSTANCE;
    }

    @NotNull
    public static GuiFramework getInstance() {
        Preconditions.checkNotNull((Object)INSTANCE, (Object)"GuiFramework not yet instantiated. Must use GuiFramework#instantiate(Plugin) first.");
        return INSTANCE;
    }
}

