/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.guiframework.framework.gui;

import dev.rosewood.rosestacker.lib.guiframework.GuiFramework;
import dev.rosewood.rosestacker.lib.guiframework.adapter.InventoryViewAdapter;
import dev.rosewood.rosestacker.lib.guiframework.framework.gui.FrameworkView;
import dev.rosewood.rosestacker.lib.guiframework.framework.gui.screen.FrameworkScreen;
import dev.rosewood.rosestacker.lib.guiframework.gui.GuiContainer;
import dev.rosewood.rosestacker.lib.guiframework.gui.GuiView;
import dev.rosewood.rosestacker.lib.guiframework.gui.Tickable;
import dev.rosewood.rosestacker.lib.guiframework.gui.screen.GuiScreen;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class FrameworkContainer
implements GuiContainer {
    private final Map<UUID, FrameworkView> currentViewers = new HashMap<UUID, FrameworkView>();
    private final Map<Integer, GuiScreen> screens = new HashMap<Integer, GuiScreen>();
    private boolean persistent = false;
    private boolean preventItemDropping = false;
    private int tickRate = -1;
    private int currentTick = 0;

    @Override
    public FrameworkContainer setPersistent(boolean persistent) {
        this.persistent = persistent;
        return this;
    }

    @Override
    public FrameworkContainer setTickRate(int tickRate) {
        this.tickRate = tickRate;
        return this;
    }

    @Override
    public GuiContainer preventItemDropping(boolean disable) {
        this.preventItemDropping = disable;
        return this;
    }

    @Override
    public GuiContainer addScreen(GuiScreen screen) {
        this.screens.put(this.screens.size(), screen);
        return this;
    }

    @Override
    public void openFor(Player player, int screenNumber) {
        FrameworkScreen screen = (FrameworkScreen)this.screens.get(screenNumber);
        if (screen == null) {
            throw new IndexOutOfBoundsException("A screen with the id " + screenNumber + " does not exist.");
        }
        GuiFramework.getInstance().getGuiManager().getActiveGuis().stream().filter(x -> x instanceof FrameworkContainer).map(x -> (FrameworkContainer)x).filter(x -> x != this).filter(x -> x.getCurrentViewers().containsKey(player.getUniqueId())).forEach(x -> x.runCloseFor(player));
        this.currentViewers.put(player.getUniqueId(), new FrameworkView(player.getUniqueId(), screen, 1));
        InventoryViewAdapter.getHandler().openInventory(player, screen.getInventory(1));
    }

    @Override
    public void openFor(Player player) {
        this.openFor(player, 0);
    }

    public void runCloseFor(@NotNull Player player) {
        if (this.currentViewers.remove(player.getUniqueId()) != null && this.currentViewers.isEmpty()) {
            this.screens.values().stream().map(x -> (FrameworkScreen)x).forEach(x -> x.onViewersLeave(player));
        }
    }

    public void firstPage(@NotNull Player player) {
        if (!this.currentViewers.containsKey(player.getUniqueId())) {
            return;
        }
        FrameworkView view = this.currentViewers.get(player.getUniqueId());
        if (view.getViewingPage() == 1) {
            return;
        }
        view.setViewingPage(1);
        InventoryViewAdapter.getHandler().openInventory(player, view.getViewingScreen().getInventory(view.getViewingPage()));
    }

    public void pageBackwards(@NotNull Player player) {
        if (!this.currentViewers.containsKey(player.getUniqueId())) {
            return;
        }
        FrameworkView view = this.currentViewers.get(player.getUniqueId());
        if (view.getViewingPage() == 1) {
            return;
        }
        view.setViewingPage(view.getViewingPage() - 1);
        InventoryViewAdapter.getHandler().openInventory(player, view.getViewingScreen().getInventory(view.getViewingPage()));
    }

    public void pageForwards(@NotNull Player player) {
        if (!this.currentViewers.containsKey(player.getUniqueId())) {
            return;
        }
        FrameworkView view = this.currentViewers.get(player.getUniqueId());
        if (!view.getViewingScreen().hasNextPage(view.getViewingPage())) {
            return;
        }
        view.setViewingPage(view.getViewingPage() + 1);
        InventoryViewAdapter.getHandler().openInventory(player, view.getViewingScreen().getInventory(view.getViewingPage()));
    }

    public void lastPage(@NotNull Player player) {
        if (!this.currentViewers.containsKey(player.getUniqueId())) {
            return;
        }
        FrameworkView view = this.currentViewers.get(player.getUniqueId());
        if (view.getViewingPage() == view.getViewingScreen().getMaximumPageNumber()) {
            return;
        }
        view.setViewingPage(view.getViewingScreen().getMaximumPageNumber());
        InventoryViewAdapter.getHandler().openInventory(player, view.getViewingScreen().getInventory(view.getViewingPage()));
    }

    public void transitionForwards(@NotNull Player player) {
        FrameworkView view = this.currentViewers.get(player.getUniqueId());
        for (int key : this.screens.keySet()) {
            FrameworkScreen screen = (FrameworkScreen)this.screens.get(key);
            if (screen != view.getViewingScreen()) continue;
            FrameworkScreen nextScreen = (FrameworkScreen)this.screens.get(key + 1);
            if (nextScreen != null) {
                view.setViewingScreen(nextScreen);
                view.setViewingPage(1);
                InventoryViewAdapter.getHandler().openInventory(player, view.getViewingScreen().getInventory(view.getViewingPage()));
            }
            return;
        }
    }

    public void transitionBackwards(@NotNull Player player) {
        FrameworkView view = this.currentViewers.get(player.getUniqueId());
        for (int key : this.screens.keySet()) {
            FrameworkScreen screen = (FrameworkScreen)this.screens.get(key);
            if (screen != view.getViewingScreen()) continue;
            FrameworkScreen nextScreen = (FrameworkScreen)this.screens.get(key - 1);
            if (nextScreen != null) {
                view.setViewingScreen(nextScreen);
                view.setViewingPage(1);
                InventoryViewAdapter.getHandler().openInventory(player, view.getViewingScreen().getInventory(view.getViewingPage()));
            }
            return;
        }
    }

    @Override
    public void tick() {
        if (this.tickRate == -1) {
            return;
        }
        ++this.currentTick;
        if (this.currentTick >= this.tickRate) {
            this.currentTick = 0;
            this.screens.values().forEach(Tickable::tick);
        }
    }

    @Override
    public Map<Integer, GuiScreen> getNumberedScreens() {
        return Collections.unmodifiableMap(this.screens);
    }

    @Override
    public Collection<GuiScreen> getScreens() {
        return Collections.unmodifiableCollection(this.screens.values());
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    @Override
    public int getTickRate() {
        return this.tickRate;
    }

    @Override
    public boolean preventsItemDropping() {
        return this.preventItemDropping;
    }

    @Override
    public Map<UUID, GuiView> getCurrentViewers() {
        return Collections.unmodifiableMap(this.currentViewers);
    }

    @Override
    public int getTotalViewers() {
        return this.currentViewers.size();
    }

    @Override
    public boolean hasViewers() {
        return !this.currentViewers.isEmpty();
    }

    @Override
    public void closeViewers() {
        List<Player> viewers = this.currentViewers.values().stream().map(GuiView::getViewer).collect(Collectors.toList());
        viewers.forEach(viewer -> {
            viewer.closeInventory();
            this.runCloseFor((Player)viewer);
        });
    }
}

