/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.guiframework.framework.gui.listeners;

import dev.rosewood.rosestacker.lib.guiframework.GuiFramework;
import dev.rosewood.rosestacker.lib.guiframework.adapter.InventoryViewAdapter;
import dev.rosewood.rosestacker.lib.guiframework.adapter.InventoryViewHandler;
import dev.rosewood.rosestacker.lib.guiframework.adapter.InventoryViewWrapper;
import dev.rosewood.rosestacker.lib.guiframework.framework.gui.FrameworkButton;
import dev.rosewood.rosestacker.lib.guiframework.framework.gui.FrameworkContainer;
import dev.rosewood.rosestacker.lib.guiframework.framework.gui.manager.FrameworkManager;
import dev.rosewood.rosestacker.lib.guiframework.framework.gui.screen.FrameworkScreen;
import dev.rosewood.rosestacker.lib.guiframework.framework.gui.screen.FrameworkScreenEditFilters;
import dev.rosewood.rosestacker.lib.guiframework.framework.gui.screen.FrameworkScreenSection;
import dev.rosewood.rosestacker.lib.guiframework.gui.ClickAction;
import dev.rosewood.rosestacker.lib.guiframework.gui.GuiContainer;
import dev.rosewood.rosestacker.lib.guiframework.gui.screen.GuiScreen;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class InventoryListener
implements Listener {
    private final FrameworkManager guiManager;
    private final List<ClickType> validEditClickTypes;
    private final List<ClickType> validButtonClickTypes;
    private final List<InventoryAction> validEditInventoryActions;
    private final List<InventoryAction> validButtonInventoryActions;
    private final InventoryViewHandler inventoryViewAdapter;

    public InventoryListener(FrameworkManager guiManager) {
        this.guiManager = guiManager;
        this.validEditClickTypes = Arrays.asList(ClickType.CONTROL_DROP, ClickType.CREATIVE, ClickType.DOUBLE_CLICK, ClickType.DROP, ClickType.LEFT, ClickType.MIDDLE, ClickType.NUMBER_KEY, ClickType.RIGHT, ClickType.SHIFT_LEFT, ClickType.SHIFT_RIGHT);
        this.validButtonClickTypes = Arrays.asList(ClickType.LEFT, ClickType.MIDDLE, ClickType.RIGHT, ClickType.SHIFT_LEFT, ClickType.SHIFT_RIGHT);
        this.validEditInventoryActions = Arrays.asList(InventoryAction.CLONE_STACK, InventoryAction.DROP_ALL_CURSOR, InventoryAction.DROP_ALL_SLOT, InventoryAction.DROP_ONE_CURSOR, InventoryAction.DROP_ONE_SLOT, InventoryAction.MOVE_TO_OTHER_INVENTORY, InventoryAction.PICKUP_ALL, InventoryAction.PICKUP_HALF, InventoryAction.PICKUP_ONE, InventoryAction.PICKUP_SOME, InventoryAction.PLACE_ALL, InventoryAction.PLACE_ONE, InventoryAction.PLACE_SOME, InventoryAction.SWAP_WITH_CURSOR);
        this.validButtonInventoryActions = Arrays.asList(InventoryAction.PICKUP_ALL, InventoryAction.PICKUP_HALF, InventoryAction.PICKUP_ONE, InventoryAction.PICKUP_SOME, InventoryAction.MOVE_TO_OTHER_INVENTORY);
        this.inventoryViewAdapter = InventoryViewAdapter.getHandler();
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onInventoryItemDrag(InventoryDragEvent event) {
        Inventory inventory = this.inventoryViewAdapter.getView(event).getTopInventory();
        FrameworkContainer clickedContainer = this.getGuiContainer(inventory);
        FrameworkScreen clickedScreen = this.getGuiScreen(inventory);
        if (clickedContainer == null || clickedScreen == null || !(event.getWhoClicked() instanceof Player)) {
            return;
        }
        FrameworkScreenSection editableSection = clickedScreen.getEditableSection();
        if (editableSection != null) {
            Material draggedType = event.getOldCursor().getType();
            FrameworkScreenEditFilters filters = clickedScreen.getEditFilters();
            if (filters != null && !filters.canInteractWith(event.getOldCursor())) {
                event.setCancelled(true);
            }
            InventoryViewWrapper view = this.inventoryViewAdapter.getView(event);
            Map newItems = event.getNewItems();
            HashMap<Integer, ItemStack> rejectedItems = new HashMap<Integer, ItemStack>();
            Iterator iterator = newItems.keySet().iterator();
            while (iterator.hasNext()) {
                int slot2 = (Integer)iterator.next();
                if (view.getInventory(slot2) != view.getTopInventory() || editableSection.containsSlot(slot2)) continue;
                ItemStack oldItem = view.getItem(slot2);
                if (oldItem == null) {
                    oldItem = new ItemStack(draggedType, 0);
                }
                ItemStack newItem = (ItemStack)newItems.get(slot2);
                ItemStack adjustedItem = newItem.clone();
                adjustedItem.setAmount(newItem.getAmount() - oldItem.getAmount());
                rejectedItems.put(slot2, adjustedItem);
            }
            int totalRejected = rejectedItems.values().stream().mapToInt(ItemStack::getAmount).sum();
            if (totalRejected > 0) {
                event.setCancelled(true);
                Player player = (Player)event.getWhoClicked();
                Bukkit.getScheduler().runTask(GuiFramework.getInstance().getHookedPlugin(), () -> {
                    ItemStack newCursor = event.getCursor();
                    if (newCursor == null || newCursor.getType() == Material.AIR) {
                        newCursor = new ItemStack(draggedType, 0);
                    }
                    player.setItemOnCursor(new ItemStack(draggedType, newCursor.getAmount() + totalRejected));
                });
                newItems.keySet().stream().filter(x -> !rejectedItems.containsKey(x)).forEach(slot -> {
                    ItemStack additive = (ItemStack)newItems.get(slot);
                    ItemStack original = view.getItem((int)slot);
                    if (original == null || original.getType() == Material.AIR) {
                        view.setItem((int)slot, new ItemStack(draggedType, additive.getAmount()));
                    } else {
                        original = original.clone();
                        original.setAmount(original.getAmount() + additive.getAmount());
                        view.setItem((int)slot, original);
                    }
                });
            }
        } else {
            boolean draggedIntoTop = event.getInventorySlots().stream().anyMatch(x -> this.inventoryViewAdapter.getView(event).getSlotType((int)x) == InventoryType.SlotType.CONTAINER);
            if (draggedIntoTop) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        InventoryViewWrapper view = this.inventoryViewAdapter.getView(event);
        Inventory topInventory = view.getTopInventory();
        Inventory bottomInventory = view.getBottomInventory();
        Inventory clickedInventory = event.getClickedInventory();
        if (clickedInventory == null || !(event.getWhoClicked() instanceof Player)) {
            return;
        }
        FrameworkContainer clickedContainer = this.getGuiContainer(topInventory);
        FrameworkScreen clickedScreen = this.getGuiScreen(topInventory);
        if (clickedContainer == null || clickedScreen == null) {
            return;
        }
        if (clickedContainer.preventsItemDropping() && (event.getClick() == ClickType.DROP || event.getClick() == ClickType.CONTROL_DROP)) {
            event.setCancelled(true);
            return;
        }
        FrameworkScreenSection editableSection = clickedScreen.getEditableSection();
        if (clickedInventory == bottomInventory && event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
            ItemStack movingItemStack = bottomInventory.getItem(event.getSlot());
            if (editableSection == null || movingItemStack == null || movingItemStack.getType() == Material.AIR) {
                event.setCancelled(true);
                return;
            }
            FrameworkScreenEditFilters editFilters = clickedScreen.getEditFilters();
            if (editFilters != null && !editFilters.canInteractWith(movingItemStack)) {
                event.setCancelled(true);
                return;
            }
            int maxStackSize = movingItemStack.getMaxStackSize();
            int totalRemaining = movingItemStack.getAmount();
            for (int slot : editableSection.getSlots()) {
                ItemStack slotItemStack = topInventory.getItem(slot);
                if (slotItemStack == null || slotItemStack.getType() == Material.AIR) {
                    slotItemStack = movingItemStack.clone();
                    slotItemStack.setAmount(totalRemaining);
                    totalRemaining = 0;
                } else {
                    if (!slotItemStack.isSimilar(movingItemStack)) continue;
                    int amountToMove = Math.min(totalRemaining, maxStackSize - slotItemStack.getAmount());
                    slotItemStack.setAmount(slotItemStack.getAmount() + amountToMove);
                    totalRemaining -= amountToMove;
                }
                topInventory.setItem(slot, slotItemStack);
                if (totalRemaining != 0) continue;
                break;
            }
            if (totalRemaining > 0) {
                movingItemStack.setAmount(totalRemaining);
                bottomInventory.setItem(event.getSlot(), movingItemStack);
            } else {
                bottomInventory.setItem(event.getSlot(), null);
            }
            event.setCancelled(true);
            return;
        }
        if (clickedInventory != topInventory) {
            return;
        }
        if (editableSection != null && editableSection.containsSlot(event.getSlot())) {
            if (!this.validEditClickTypes.contains(event.getClick()) || !this.validEditInventoryActions.contains(event.getAction())) {
                event.setCancelled(true);
                return;
            }
            FrameworkScreenEditFilters editFilters = clickedScreen.getEditFilters();
            if (editFilters != null) {
                Material type;
                ItemStack cursor = event.getCursor();
                ItemStack current = event.getCurrentItem();
                boolean filtered = false;
                if (cursor != null && (type = cursor.getType()) != Material.AIR && !editFilters.canInteractWith(cursor)) {
                    filtered = true;
                }
                if (!filtered && current != null && (type = current.getType()) != Material.AIR && !editFilters.canInteractWith(current)) {
                    filtered = true;
                }
                if (filtered) {
                    event.setCancelled(true);
                    return;
                }
            }
            return;
        }
        event.setCancelled(true);
        if (!this.validButtonClickTypes.contains(event.getClick()) || !this.validButtonInventoryActions.contains(event.getAction())) {
            return;
        }
        FrameworkButton clickedButton = clickedScreen.getButtonOnInventoryPage(topInventory, event.getSlot());
        if (clickedButton == null || !clickedScreen.isButtonOnInventoryPageVisible(topInventory, event.getSlot())) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ClickAction clickAction = clickedButton.click(event);
        switch (clickAction) {
            case REFRESH: {
                clickedScreen.updateInventories();
                break;
            }
            case CLOSE: {
                player.closeInventory();
                break;
            }
            case PAGE_FIRST: {
                clickedContainer.firstPage(player);
                break;
            }
            case PAGE_BACKWARDS: {
                clickedContainer.pageBackwards(player);
                break;
            }
            case PAGE_FORWARDS: {
                clickedContainer.pageForwards(player);
                break;
            }
            case PAGE_LAST: {
                clickedContainer.lastPage(player);
                break;
            }
            case TRANSITION_BACKWARDS: {
                clickedContainer.transitionBackwards(player);
                break;
            }
            case TRANSITION_FORWARDS: {
                clickedContainer.transitionForwards(player);
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryClose(InventoryCloseEvent event) {
        Bukkit.getScheduler().runTask(GuiFramework.getInstance().getHookedPlugin(), () -> this.runClose((Player)event.getPlayer(), event.getInventory()));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.forceCloseActiveGuis(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        this.forceCloseActiveGuis(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onItemDrop(PlayerDropItemEvent event) {
        Inventory inventory = this.inventoryViewAdapter.getOpenInventory(event.getPlayer()).getTopInventory();
        FrameworkContainer openContainer = this.getGuiContainer(inventory);
        if (openContainer != null && openContainer.preventsItemDropping()) {
            event.setCancelled(true);
        }
    }

    private void forceCloseActiveGuis(Player player) {
        List orphanedContainers = this.guiManager.getActiveGuis().stream().filter(x -> x instanceof FrameworkContainer).map(x -> (FrameworkContainer)x).filter(x -> x.getCurrentViewers().containsKey(player.getUniqueId())).collect(Collectors.toList());
        for (FrameworkContainer container : orphanedContainers) {
            container.runCloseFor(player);
            if (container.isPersistent() || container.hasViewers()) continue;
            this.guiManager.unregisterGui(container);
        }
        if (!orphanedContainers.isEmpty()) {
            player.closeInventory();
        }
    }

    private void runClose(Player player, Inventory inventory) {
        FrameworkContainer eventContainer = this.getGuiContainer(inventory);
        FrameworkContainer playerContainer = this.getGuiContainer(this.inventoryViewAdapter.getOpenInventory(player).getTopInventory());
        if (eventContainer == null || playerContainer != null) {
            return;
        }
        eventContainer.runCloseFor(player);
        if (!eventContainer.isPersistent() && !eventContainer.hasViewers()) {
            this.guiManager.unregisterGui(eventContainer);
        }
    }

    private FrameworkContainer getGuiContainer(Inventory inventory) {
        for (GuiContainer container : this.guiManager.getActiveGuis()) {
            for (GuiScreen screen : container.getScreens()) {
                if (!((FrameworkScreen)screen).containsInventory(inventory)) continue;
                return (FrameworkContainer)container;
            }
        }
        return null;
    }

    private FrameworkScreen getGuiScreen(Inventory inventory) {
        for (GuiContainer container : this.guiManager.getActiveGuis()) {
            for (GuiScreen screen : container.getScreens()) {
                if (!((FrameworkScreen)screen).containsInventory(inventory)) continue;
                return (FrameworkScreen)screen;
            }
        }
        return null;
    }
}

