/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.guiframework.framework.gui.screen;

import dev.rosewood.rosestacker.lib.guiframework.gui.screen.GuiScreenEditFilters;
import java.util.Arrays;
import java.util.function.Predicate;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class FrameworkScreenEditFilters
implements GuiScreenEditFilters {
    private Predicate<ItemStack> whitelist = null;
    private Predicate<ItemStack> blacklist = null;
    private boolean allowModified = true;

    @Override
    @NotNull
    public FrameworkScreenEditFilters setWhitelist(Material ... whitelist) {
        this.whitelist = stack -> Arrays.stream(whitelist).allMatch(arg_0 -> stack.getType().equals(arg_0));
        return this;
    }

    @Override
    @NotNull
    public GuiScreenEditFilters setWhitelist(@NotNull Predicate<ItemStack> whitelist) {
        this.whitelist = whitelist;
        return this;
    }

    @Override
    @NotNull
    public FrameworkScreenEditFilters setBlacklist(Material ... blacklist) {
        this.blacklist = stack -> Arrays.stream(blacklist).noneMatch(arg_0 -> stack.getType().equals(arg_0));
        return this;
    }

    @Override
    @NotNull
    public GuiScreenEditFilters setBlacklist(@NotNull Predicate<ItemStack> blacklist) {
        this.blacklist = blacklist;
        return this;
    }

    @Override
    public FrameworkScreenEditFilters setAllowModified(boolean allowModified) {
        this.allowModified = allowModified;
        return this;
    }

    @Override
    @NotNull
    public Predicate<ItemStack> getWhitelist() {
        return this.whitelist;
    }

    @Override
    @NotNull
    public Predicate<ItemStack> getBlacklist() {
        return this.blacklist;
    }

    @Override
    public boolean canInteractWith(ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (!this.allowModified && itemMeta != null && (itemMeta.hasDisplayName() || itemMeta.hasLore() || itemMeta.hasEnchants() || itemMeta.hasAttributeModifiers())) {
            return false;
        }
        if (this.blacklist != null && this.blacklist.test(itemStack)) {
            return false;
        }
        return this.whitelist == null || this.whitelist.test(itemStack);
    }
}

