/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.guiframework.framework.util;

import dev.rosewood.rosestacker.lib.guiframework.gui.GuiSize;
import dev.rosewood.rosestacker.lib.guiframework.gui.screen.GuiScreen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public final class GuiUtil {
    public static final int ROW_1_START = 0;
    public static final int ROW_2_START = 9;
    public static final int ROW_3_START = 18;
    public static final int ROW_4_START = 27;
    public static final int ROW_5_START = 36;
    public static final int ROW_6_START = 45;
    public static final int ROW_1_END = 8;
    public static final int ROW_2_END = 17;
    public static final int ROW_3_END = 26;
    public static final int ROW_4_END = 35;
    public static final int ROW_5_END = 44;
    public static final int ROW_6_END = 53;
    public static final String PREVIOUS_PAGE_NUMBER_PLACEHOLDER = "%previousPage%";
    public static final String CURRENT_PAGE_NUMBER_PLACEHOLDER = "%currentPage%";
    public static final String NEXT_PAGE_NUMBER_PLACEHOLDER = "%nextPage%";
    public static final String MAX_PAGE_NUMBER_PLACEHOLDER = "%maxPage%";

    private GuiUtil() {
    }

    public static List<ItemStack> getMaterialAmountAsItemStacks(Material material, int stackSize) {
        int maxStackSize = material.getMaxStackSize();
        if (maxStackSize <= 0) {
            return Collections.emptyList();
        }
        int remaining = stackSize;
        ArrayList<ItemStack> stackItems = new ArrayList<ItemStack>();
        while (remaining - maxStackSize > 0) {
            remaining -= maxStackSize;
            stackItems.add(new ItemStack(material, maxStackSize));
        }
        if (remaining > 0) {
            stackItems.add(new ItemStack(material, remaining));
        }
        return stackItems;
    }

    public static void fillScreen(GuiScreen screen, ItemStack fillItem) {
        GuiSize size = screen.getCurrentSize();
        if (!size.name().startsWith("ROWS") && size != GuiSize.DYNAMIC) {
            throw new IllegalArgumentException("Cannot fill borders of a non-chest GUI");
        }
        for (int i = 0; i < size.getNumSlots(); ++i) {
            screen.addItemStackAt(i, fillItem);
        }
    }

    public static void fillBorders(GuiScreen screen, ItemStack fillItem) {
        GuiSize size = screen.getCurrentSize();
        if (!size.name().startsWith("ROWS")) {
            throw new IllegalArgumentException("Cannot fill borders of a non-chest GUI");
        }
        GuiUtil.fillRow(screen, 0, fillItem);
        GuiUtil.fillRow(screen, size.getRows() - 1, fillItem);
        GuiUtil.fillColumn(screen, 0, fillItem);
        GuiUtil.fillColumn(screen, size.getCols() - 1, fillItem);
    }

    public static void fillRow(GuiScreen screen, int row, ItemStack fillItem) {
        GuiSize size = screen.getCurrentSize();
        if (!size.name().startsWith("ROWS")) {
            throw new IllegalArgumentException("Cannot fill borders of a non-chest GUI");
        }
        if (row < 0 || row > size.getRows()) {
            throw new IllegalArgumentException(String.format("row must be between 0 and %d inclusive for this GUI", size.getRows() - 1));
        }
        for (int i = row * 9; i < row * 9 + size.getCols(); ++i) {
            screen.addItemStackAt(i, fillItem);
        }
    }

    public static void fillColumn(GuiScreen screen, int column, ItemStack fillItem) {
        GuiSize size = screen.getCurrentSize();
        if (!size.name().startsWith("ROWS")) {
            throw new IllegalArgumentException("Cannot fill borders of a non-chest GUI");
        }
        if (column < 0 || column > size.getCols()) {
            throw new IllegalArgumentException(String.format("column must be between 0 and %d inclusive for this GUI", size.getCols() - 1));
        }
        for (int i = column; i < size.getRows() * 9; i += 9) {
            screen.addItemStackAt(i, fillItem);
        }
    }

    public static GuiSize getGuiSizeFromSlots(Collection<Integer> slots) {
        return GuiSize.fromRows(Math.min(((int)((double)slots.stream().max(Integer::compareTo).orElse(0).intValue() / 9.0) + 1) * 9, 54));
    }

    public static int slotFromCoordinate(int row, int col) {
        return row * 9 + col;
    }

    public static String formatName(String name) {
        return Arrays.stream(name.replace('_', ' ').split("\\s+")).map(x -> x.substring(0, 1).toUpperCase() + x.substring(1).toLowerCase()).collect(Collectors.joining(" "));
    }
}

