/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.guiframework.gui;

public enum GuiSize {
    DYNAMIC(-1, -1),
    ROWS_ONE(1, 9),
    ROWS_TWO(2, 9),
    ROWS_THREE(3, 9),
    ROWS_FOUR(4, 9),
    ROWS_FIVE(5, 9),
    ROWS_SIX(6, 9),
    HOPPER(1, 5),
    DISPENSER(3, 3);

    private final int rows;
    private final int cols;

    private GuiSize(int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public int getNumSlots() {
        if (this == DYNAMIC) {
            return -1;
        }
        return this.rows * this.cols;
    }

    public static GuiSize fromRows(int rows) {
        if (rows <= 0 || rows > 6) {
            throw new IllegalArgumentException("rows must be between 1 and 6 inclusive");
        }
        for (GuiSize guiSize : GuiSize.values()) {
            if (!guiSize.name().startsWith("ROWS") || guiSize.rows != rows) continue;
            return guiSize;
        }
        throw new IllegalStateException();
    }
}

