/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden;

import dev.rosewood.rosestacker.lib.rosegarden.command.framework.RoseCommandWrapper;
import dev.rosewood.rosestacker.lib.rosegarden.command.rwd.RwdCommand;
import dev.rosewood.rosestacker.lib.rosegarden.config.RoseConfig;
import dev.rosewood.rosestacker.lib.rosegarden.config.SettingHolder;
import dev.rosewood.rosestacker.lib.rosegarden.lib.bstats.bukkit.Metrics;
import dev.rosewood.rosestacker.lib.rosegarden.manager.AbstractCommandManager;
import dev.rosewood.rosestacker.lib.rosegarden.manager.AbstractDataManager;
import dev.rosewood.rosestacker.lib.rosegarden.manager.AbstractLocaleManager;
import dev.rosewood.rosestacker.lib.rosegarden.manager.Manager;
import dev.rosewood.rosestacker.lib.rosegarden.manager.PluginUpdateManager;
import dev.rosewood.rosestacker.lib.rosegarden.objects.RosePluginData;
import dev.rosewood.rosestacker.lib.rosegarden.scheduler.RoseScheduler;
import dev.rosewood.rosestacker.lib.rosegarden.utils.RoseGardenUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RosePlugin
extends JavaPlugin {
    public static final String ROSEGARDEN_VERSION = "1.5.3";
    private static RosePlugin instance;
    private final int spigotId;
    private final int bStatsId;
    private final Class<? extends AbstractDataManager> dataManagerClass;
    private final Class<? extends AbstractLocaleManager> localeManagerClass;
    private final Class<? extends AbstractCommandManager> commandManagerClass;
    private final Map<Class<? extends Manager>, Manager> managers;
    private final Deque<Class<? extends Manager>> managerInitializationStack;
    private RoseConfig roseConfig;
    private boolean firstInitialization = true;
    private boolean firstToRegister = false;
    private boolean snapshot = false;

    public RosePlugin(int spigotId, int bStatsId, Class<? extends AbstractDataManager> dataManagerClass, Class<? extends AbstractLocaleManager> localeManagerClass, Class<? extends AbstractCommandManager> commandManagerClass) {
        if (dataManagerClass != null && Modifier.isAbstract(dataManagerClass.getModifiers())) {
            throw new IllegalArgumentException("dataManagerClass cannot be abstract");
        }
        if (localeManagerClass != null && Modifier.isAbstract(localeManagerClass.getModifiers())) {
            throw new IllegalArgumentException("localeManagerClass cannot be abstract");
        }
        if (commandManagerClass != null && Modifier.isAbstract(commandManagerClass.getModifiers())) {
            throw new IllegalArgumentException("commandManagerClass cannot be abstract");
        }
        this.spigotId = spigotId;
        this.bStatsId = bStatsId;
        this.dataManagerClass = dataManagerClass;
        this.localeManagerClass = localeManagerClass;
        this.commandManagerClass = commandManagerClass;
        this.managers = new ConcurrentHashMap<Class<? extends Manager>, Manager>();
        this.managerInitializationStack = new ConcurrentLinkedDeque<Class<? extends Manager>>();
        instance = this;
    }

    public void onLoad() {
        this.getLogger().info("Initializing using RoseGarden v1.5.3");
        if (!RoseGardenUtils.isRelocated()) {
            this.getLogger().severe("=====================================================");
            this.getLogger().severe("DEVELOPER WARNING! RoseGarden has not been relocated!");
            this.getLogger().severe("    This will not prevent the plugin from loading,   ");
            this.getLogger().severe("        but should be fixed before releasing!        ");
            this.getLogger().severe("=====================================================");
        }
        this.snapshot = RoseGardenUtils.checkSnapshotVersion(this);
    }

    public void onEnable() {
        if (this.bStatsId != -1) {
            Metrics metrics = new Metrics(this, this.bStatsId);
            this.addCustomMetricsCharts(metrics);
        }
        this.injectService();
        this.getRoseConfig();
        this.reload();
        this.enable();
    }

    public void onDisable() {
        this.disable();
        this.disableManagers();
    }

    protected abstract void enable();

    protected abstract void disable();

    @NotNull
    protected abstract List<Class<? extends Manager>> getManagerLoadPriority();

    public boolean isLocalDatabaseOnly() {
        return false;
    }

    @Nullable
    protected SettingHolder getRoseConfigSettingHolder() {
        return null;
    }

    @NotNull
    protected String[] getRoseConfigHeader() {
        return new String[0];
    }

    protected void addCustomMetricsCharts(Metrics metrics) {
    }

    public void reload() {
        this.disableManagers();
        if (this.roseConfig != null) {
            this.roseConfig.reload();
        }
        if (this.firstInitialization) {
            ArrayList<Class<Manager>> managerLoadPriority = new ArrayList<Class<Manager>>();
            if (this.hasDataManager()) {
                managerLoadPriority.add(this.dataManagerClass);
            }
            if (this.hasLocaleManager()) {
                managerLoadPriority.add(this.localeManagerClass);
            }
            if (this.hasCommandManager()) {
                managerLoadPriority.add(this.commandManagerClass);
            }
            managerLoadPriority.addAll(this.getManagerLoadPriority());
            if (this.spigotId != -1) {
                managerLoadPriority.add(PluginUpdateManager.class);
            }
            managerLoadPriority.forEach(this::getManager);
        } else {
            ArrayList<Class<? extends Manager>> initStack = new ArrayList<Class<? extends Manager>>(this.managerInitializationStack);
            Collections.reverse(initStack);
            for (Class clazz : initStack) {
                Manager manager = this.managers.get(clazz);
                try {
                    manager.reload();
                }
                catch (Exception e) {
                    throw new ManagerLoadException(clazz, (Throwable)e);
                }
            }
        }
        this.firstInitialization = false;
    }

    private void disableManagers() {
        for (Class<? extends Manager> managerClass : this.managerInitializationStack) {
            Manager manager = this.managers.get(managerClass);
            try {
                manager.disable();
            }
            catch (Exception e) {
                throw new ManagerUnloadException(managerClass, (Throwable)e);
            }
        }
    }

    @NotNull
    public <T extends Manager> T getManager(Class<T> managerClass) {
        Class<Manager> lookupClass = this.remapAbstractManagerClasses(managerClass);
        AtomicBoolean initialized = new AtomicBoolean();
        Manager manager = this.managers.computeIfAbsent(lookupClass, key -> {
            try {
                Manager manager = (Manager)lookupClass.getConstructor(RosePlugin.class).newInstance(new Object[]{this});
                return manager;
            }
            catch (Exception e) {
                throw new ManagerInitializationException(lookupClass, (Throwable)e);
            }
            finally {
                initialized.set(true);
            }
        });
        if (initialized.get()) {
            try {
                manager.reload();
            }
            catch (Exception e) {
                throw new ManagerLoadException(lookupClass, (Throwable)e);
            }
            finally {
                this.managerInitializationStack.push(lookupClass);
            }
        }
        return (T)manager;
    }

    protected <T extends Manager> Class<? extends Manager> remapAbstractManagerClasses(Class<T> managerClass) {
        Class<Manager> lookupClass = this.hasDataManager() && managerClass == AbstractDataManager.class ? this.dataManagerClass : (this.hasLocaleManager() && managerClass == AbstractLocaleManager.class ? this.localeManagerClass : (this.hasCommandManager() && managerClass == AbstractCommandManager.class ? this.commandManagerClass : managerClass));
        return lookupClass;
    }

    public final RoseScheduler getScheduler() {
        return RoseScheduler.getInstance(this);
    }

    public final RoseConfig getRoseConfig() {
        if (this.roseConfig == null) {
            SettingHolder settingHolder;
            ArrayList settings = new ArrayList();
            if (this.hasLocaleManager()) {
                settings.addAll(AbstractLocaleManager.Settings.INSTANCE.get());
            }
            if ((settingHolder = this.getRoseConfigSettingHolder()) != null) {
                settings.addAll(settingHolder.get());
            }
            if (this.hasDataManager() && !this.isLocalDatabaseOnly()) {
                settings.addAll(AbstractDataManager.Settings.INSTANCE.get());
            }
            File file = new File(this.getDataFolder(), "config.yml");
            this.roseConfig = RoseConfig.builder(file).header(this.getRoseConfigHeader()).settings(settings).writeDefaultValueComments().build();
        }
        return this.roseConfig;
    }

    public final int getSpigotId() {
        return this.spigotId;
    }

    public final int getBStatsId() {
        return this.bStatsId;
    }

    public final boolean isFirstToRegister() {
        return this.firstToRegister;
    }

    public final boolean isSnapshot() {
        return this.snapshot;
    }

    private void injectService() {
        if (this.getLoadedRosePluginsData().isEmpty()) {
            this.firstToRegister = true;
            new RoseCommandWrapper("rosegarden", this.getRoseGardenDataFolder(), this, new RwdCommand(this)).register();
        }
        Bukkit.getServicesManager().register(RosePlugin.class, (Object)this, (Plugin)this, ServicePriority.Normal);
    }

    @NotNull
    public final List<RosePluginData> getLoadedRosePluginsData() {
        ArrayList<RosePluginData> data = new ArrayList<RosePluginData>();
        ServicesManager servicesManager = Bukkit.getServicesManager();
        for (Class service : servicesManager.getKnownServices()) {
            try {
                String roseGardenVersion = (String)service.getField("ROSEGARDEN_VERSION").get(null);
                Method updateVersionMethod = service.getMethod("getUpdateVersion", new Class[0]);
                for (RegisteredServiceProvider provider : servicesManager.getRegistrations(service)) {
                    Plugin plugin = provider.getPlugin();
                    String pluginName = plugin.getName();
                    String pluginVersion = plugin.getDescription().getVersion();
                    String website = plugin.getDescription().getWebsite();
                    String updateVersion = (String)updateVersionMethod.invoke((Object)plugin, new Object[0]);
                    List authors = plugin.getDescription().getAuthors();
                    data.add(new RosePluginData(pluginName, pluginVersion, updateVersion, website, roseGardenVersion, authors));
                }
            }
            catch (ClassCastException | ReflectiveOperationException exception) {
            }
        }
        return data;
    }

    @NotNull
    public final File getRoseGardenDataFolder() {
        File configDir = new File(this.getDataFolder().getParentFile(), "RoseGarden");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        return configDir;
    }

    @NotNull
    public final String getUpdateVersion() {
        return this.getManager(PluginUpdateManager.class).getUpdateVersion();
    }

    public final boolean hasDataManager() {
        return this.dataManagerClass != null;
    }

    public final boolean hasLocaleManager() {
        return this.localeManagerClass != null;
    }

    public final boolean hasCommandManager() {
        return this.commandManagerClass != null;
    }

    public static RosePlugin instance() {
        return instance;
    }

    private static class ManagerLoadException
    extends RuntimeException {
        public ManagerLoadException(Class<? extends Manager> managerClass, Throwable cause) {
            super("Failed to load " + managerClass.getSimpleName(), cause);
        }
    }

    private static class ManagerUnloadException
    extends RuntimeException {
        public ManagerUnloadException(Class<? extends Manager> managerClass, Throwable cause) {
            super("Failed to unload " + managerClass.getSimpleName(), cause);
        }
    }

    private static class ManagerInitializationException
    extends RuntimeException {
        public ManagerInitializationException(Class<? extends Manager> managerClass, Throwable cause) {
            super("Failed to initialize " + managerClass.getSimpleName(), cause);
        }
    }
}

