/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.command.argument;

import dev.rosewood.rosestacker.lib.rosegarden.command.framework.Argument;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.ArgumentHandler;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.CommandContext;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.InputIterator;
import dev.rosewood.rosestacker.lib.rosegarden.utils.StringPlaceholders;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractColorArgumentHandler<T>
extends ArgumentHandler<T> {
    private static final Map<String, org.bukkit.Color> COLOR_NAME_MAP = new HashMap<String, org.bukkit.Color>();

    protected AbstractColorArgumentHandler(Class<T> clazz) {
        super(clazz);
    }

    protected abstract T rgbToColor(int var1, int var2, int var3);

    @Override
    public final T handle(CommandContext context, Argument argument, InputIterator inputIterator) throws ArgumentHandler.HandledArgumentException {
        String input = inputIterator.next();
        if (input.startsWith("#")) {
            try {
                Color color = Color.decode(input);
                return this.rgbToColor(color.getRed(), color.getGreen(), color.getBlue());
            }
            catch (NumberFormatException e) {
                throw new ArgumentHandler.HandledArgumentException("argument-handler-color-hex", StringPlaceholders.of("input", input));
            }
        }
        org.bukkit.Color namedColor = COLOR_NAME_MAP.get(input.toLowerCase());
        if (namedColor != null) {
            return this.rgbToColor(namedColor.getRed(), namedColor.getGreen(), namedColor.getBlue());
        }
        String input2 = inputIterator.next();
        String input3 = inputIterator.next();
        if (input2.isEmpty() && input3.isEmpty()) {
            throw new ArgumentHandler.HandledArgumentException("argument-handler-color-hex", StringPlaceholders.of("input", input));
        }
        try {
            return this.rgbToColor(Integer.parseInt(input), Integer.parseInt(input2), Integer.parseInt(input3));
        }
        catch (NumberFormatException e) {
            throw new ArgumentHandler.HandledArgumentException("argument-handler-color-rgb");
        }
    }

    @Override
    public final List<String> suggest(CommandContext context, Argument argument, String[] args) {
        if (args.length == 0 || args.length == 1) {
            ArrayList<String> inputs = new ArrayList<String>(Arrays.asList("<#hexCode>", "<0-255> <0-255> <0-255>"));
            inputs.addAll(COLOR_NAME_MAP.keySet());
            return inputs;
        }
        if (args.length == 2) {
            return Collections.singletonList("<0-255> <0-255>");
        }
        if (args.length == 3) {
            return Collections.singletonList("<0-255>");
        }
        return Collections.emptyList();
    }

    static {
        COLOR_NAME_MAP.put("red", org.bukkit.Color.fromRGB((int)255, (int)0, (int)0));
        COLOR_NAME_MAP.put("orange", org.bukkit.Color.fromRGB((int)255, (int)140, (int)0));
        COLOR_NAME_MAP.put("yellow", org.bukkit.Color.fromRGB((int)255, (int)255, (int)0));
        COLOR_NAME_MAP.put("lime", org.bukkit.Color.fromRGB((int)50, (int)205, (int)50));
        COLOR_NAME_MAP.put("green", org.bukkit.Color.fromRGB((int)0, (int)128, (int)0));
        COLOR_NAME_MAP.put("blue", org.bukkit.Color.fromRGB((int)0, (int)0, (int)255));
        COLOR_NAME_MAP.put("cyan", org.bukkit.Color.fromRGB((int)0, (int)139, (int)139));
        COLOR_NAME_MAP.put("light_blue", org.bukkit.Color.fromRGB((int)173, (int)216, (int)230));
        COLOR_NAME_MAP.put("purple", org.bukkit.Color.fromRGB((int)138, (int)43, (int)226));
        COLOR_NAME_MAP.put("magenta", org.bukkit.Color.fromRGB((int)202, (int)31, (int)123));
        COLOR_NAME_MAP.put("pink", org.bukkit.Color.fromRGB((int)255, (int)182, (int)193));
        COLOR_NAME_MAP.put("brown", org.bukkit.Color.fromRGB((int)139, (int)69, (int)19));
        COLOR_NAME_MAP.put("black", org.bukkit.Color.fromRGB((int)0, (int)0, (int)0));
        COLOR_NAME_MAP.put("gray", org.bukkit.Color.fromRGB((int)128, (int)128, (int)128));
        COLOR_NAME_MAP.put("light_gray", org.bukkit.Color.fromRGB((int)192, (int)192, (int)192));
        COLOR_NAME_MAP.put("white", org.bukkit.Color.fromRGB((int)255, (int)255, (int)255));
    }
}

