/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.command.argument;

import dev.rosewood.rosestacker.lib.rosegarden.command.argument.BooleanArgumentHandler;
import dev.rosewood.rosestacker.lib.rosegarden.command.argument.BukkitColorArgumentHandler;
import dev.rosewood.rosestacker.lib.rosegarden.command.argument.ByteArgumentHandler;
import dev.rosewood.rosestacker.lib.rosegarden.command.argument.CharacterArgumentHandler;
import dev.rosewood.rosestacker.lib.rosegarden.command.argument.DoubleArgumentHandler;
import dev.rosewood.rosestacker.lib.rosegarden.command.argument.EnumArgumentHandler;
import dev.rosewood.rosestacker.lib.rosegarden.command.argument.FilteredPlayerArgumentHandler;
import dev.rosewood.rosestacker.lib.rosegarden.command.argument.FloatArgumentHandler;
import dev.rosewood.rosestacker.lib.rosegarden.command.argument.GreedyStringArgumentHandler;
import dev.rosewood.rosestacker.lib.rosegarden.command.argument.IntegerArgumentHandler;
import dev.rosewood.rosestacker.lib.rosegarden.command.argument.JavaColorArgumentHandler;
import dev.rosewood.rosestacker.lib.rosegarden.command.argument.LongArgumentHandler;
import dev.rosewood.rosestacker.lib.rosegarden.command.argument.OfflinePlayerArgumentHandler;
import dev.rosewood.rosestacker.lib.rosegarden.command.argument.PlayerArgumentHandler;
import dev.rosewood.rosestacker.lib.rosegarden.command.argument.RegistryValueArgumentHandler;
import dev.rosewood.rosestacker.lib.rosegarden.command.argument.SelectorPlayerArgumentHandler;
import dev.rosewood.rosestacker.lib.rosegarden.command.argument.ShortArgumentHandler;
import dev.rosewood.rosestacker.lib.rosegarden.command.argument.StringArgumentHandler;
import dev.rosewood.rosestacker.lib.rosegarden.command.argument.ValuesArgumentHandler;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.ArgumentHandler;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.OfflinePlayer;
import org.bukkit.Registry;
import org.bukkit.entity.Player;

public final class ArgumentHandlers {
    public static final ArgumentHandler<Boolean> BOOLEAN = new BooleanArgumentHandler();
    public static final ArgumentHandler<org.bukkit.Color> BUKKIT_COLOR = new BukkitColorArgumentHandler();
    public static final ArgumentHandler<Byte> BYTE = new ByteArgumentHandler();
    public static final ArgumentHandler<Character> CHARACTER = new CharacterArgumentHandler();
    public static final ArgumentHandler<Double> DOUBLE = new DoubleArgumentHandler();
    public static final ArgumentHandler<Float> FLOAT = new FloatArgumentHandler();
    public static final ArgumentHandler<String> GREEDY_STRING = new GreedyStringArgumentHandler();
    public static final ArgumentHandler<Integer> INTEGER = new IntegerArgumentHandler();
    public static final ArgumentHandler<Color> JAVA_COLOR = new JavaColorArgumentHandler();
    public static final ArgumentHandler<Long> LONG = new LongArgumentHandler();
    public static final ArgumentHandler<OfflinePlayer> OFFLINE_PLAYER = new OfflinePlayerArgumentHandler();
    public static final ArgumentHandler<Player> PLAYER = new PlayerArgumentHandler();
    public static final ArgumentHandler<Player> SELECTOR_PLAYER = new SelectorPlayerArgumentHandler();
    public static final ArgumentHandler<Short> SHORT = new ShortArgumentHandler();
    public static final ArgumentHandler<String> STRING = new StringArgumentHandler();

    private ArgumentHandlers() {
    }

    public static ArgumentHandler<Player> filteredPlayer(Predicate<Player> filter) {
        return new FilteredPlayerArgumentHandler(filter);
    }

    public static <T extends Enum<T>> ArgumentHandler<T> forEnum(Class<T> enumClass) {
        return new EnumArgumentHandler<T>(enumClass);
    }

    public static <T extends Keyed, Z extends Enum<Z>> ArgumentHandler<T> forKeyed(Class<T> keyedClass) {
        if (keyedClass.isEnum()) {
            return new EnumArgumentHandler<T>(keyedClass);
        }
        Registry registry = Bukkit.getRegistry(keyedClass);
        if (registry == null) {
            throw new IllegalArgumentException("Registry does not exist for " + keyedClass.getName());
        }
        return new RegistryValueArgumentHandler<T>(keyedClass, registry);
    }

    @SafeVarargs
    public static <T> ArgumentHandler<T> forValues(Class<T> clazz, T ... values) {
        return new ValuesArgumentHandler<T>(clazz, Arrays.asList(values));
    }

    public static <T> ArgumentHandler<T> forValues(Class<T> clazz, Collection<T> values) {
        return new ValuesArgumentHandler<T>(clazz, new ArrayList<T>(values));
    }
}

