/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.command.argument;

import dev.rosewood.rosestacker.lib.rosegarden.command.framework.Argument;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.ArgumentHandler;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.CommandContext;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.InputIterator;
import dev.rosewood.rosestacker.lib.rosegarden.utils.StringPlaceholders;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EnumArgumentHandler<T extends Enum<T>>
extends ArgumentHandler<T> {
    protected EnumArgumentHandler(Class<T> handledEnumClass) {
        super(handledEnumClass);
    }

    @Override
    public T handle(CommandContext context, Argument argument, InputIterator inputIterator) throws ArgumentHandler.HandledArgumentException {
        String input = inputIterator.next();
        Enum[] enumConstants = (Enum[])this.getHandledType().getEnumConstants();
        Optional<Enum> value = Stream.of(enumConstants).filter(x -> x.name().equalsIgnoreCase(input)).findFirst();
        if (!value.isPresent()) {
            StringPlaceholders placeholders = StringPlaceholders.of("enum", this.getHandledType().getSimpleName(), "input", input, "types", Stream.of(enumConstants).map(x -> x.name().toLowerCase()).collect(Collectors.joining(", ")));
            String messageKey = enumConstants.length <= 10 ? "argument-handler-enum-list" : "argument-handler-enum";
            throw new ArgumentHandler.HandledArgumentException(messageKey, placeholders);
        }
        return (T)value.get();
    }

    @Override
    public List<String> suggest(CommandContext context, Argument argument, String[] args) {
        return Stream.of((Enum[])this.getHandledType().getEnumConstants()).map(Enum::name).map(String::toLowerCase).collect(Collectors.toList());
    }
}

