/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.command.argument;

import dev.rosewood.rosestacker.lib.rosegarden.command.framework.Argument;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.ArgumentHandler;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.CommandContext;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.InputIterator;
import dev.rosewood.rosestacker.lib.rosegarden.utils.NMSUtil;
import dev.rosewood.rosestacker.lib.rosegarden.utils.StringPlaceholders;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class OfflinePlayerArgumentHandler
extends ArgumentHandler<OfflinePlayer> {
    protected OfflinePlayerArgumentHandler() {
        super(OfflinePlayer.class);
    }

    @Override
    public OfflinePlayer handle(CommandContext context, Argument argument, InputIterator inputIterator) throws ArgumentHandler.HandledArgumentException {
        String input = inputIterator.next();
        OfflinePlayer offlinePlayer = NMSUtil.isPaper() ? Bukkit.getOfflinePlayerIfCached((String)input) : Bukkit.getOfflinePlayer((String)input);
        if (offlinePlayer == null || !offlinePlayer.hasPlayedBefore()) {
            throw new ArgumentHandler.HandledArgumentException("argument-handler-player", StringPlaceholders.of("input", input));
        }
        return offlinePlayer;
    }

    @Override
    public List<String> suggest(CommandContext context, Argument argument, String[] args) {
        return Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
    }
}

