/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.command.argument;

import dev.rosewood.rosestacker.lib.rosegarden.command.framework.Argument;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.ArgumentHandler;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.CommandContext;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.InputIterator;
import dev.rosewood.rosestacker.lib.rosegarden.utils.StringPlaceholders;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;

public class RegistryValueArgumentHandler<T extends Keyed>
extends ArgumentHandler<T> {
    private final Registry<T> registry;

    public RegistryValueArgumentHandler(Class<T> handledType, Registry<T> registry) {
        super(handledType);
        this.registry = registry;
    }

    @Override
    public T handle(CommandContext context, Argument argument, InputIterator inputIterator) throws ArgumentHandler.HandledArgumentException {
        String input = inputIterator.next();
        NamespacedKey key = NamespacedKey.fromString((String)input.toLowerCase());
        StringPlaceholders placeholders = StringPlaceholders.of("type", this.getHandledType().getSimpleName(), "input", input);
        if (key == null) {
            throw new ArgumentHandler.HandledArgumentException("argument-handler-registry-value", placeholders);
        }
        Keyed value = this.registry.get(key);
        if (value == null) {
            throw new ArgumentHandler.HandledArgumentException("argument-handler-registry-value", placeholders);
        }
        return (T)value;
    }

    @Override
    public List<String> suggest(CommandContext context, Argument argument, String[] args) {
        return this.registry.stream().map(x -> RegistryValueArgumentHandler.asMinimalString(x.getKey())).collect(Collectors.toList());
    }

    private static String asMinimalString(NamespacedKey key) {
        if (key.getNamespace().equals("minecraft")) {
            return key.getKey();
        }
        return key.toString();
    }
}

