/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.command.argument;

import dev.rosewood.rosestacker.lib.rosegarden.command.framework.Argument;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.ArgumentHandler;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.CommandContext;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.InputIterator;
import dev.rosewood.rosestacker.lib.rosegarden.utils.StringPlaceholders;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class SelectorPlayerArgumentHandler
extends ArgumentHandler<Player> {
    protected SelectorPlayerArgumentHandler() {
        super(Player.class);
    }

    @Override
    public Player handle(CommandContext context, Argument argument, InputIterator inputIterator) throws ArgumentHandler.HandledArgumentException {
        String input = inputIterator.next();
        if (input.startsWith("@")) {
            List entities;
            try {
                entities = Bukkit.selectEntities((CommandSender)context.getSender(), (String)input);
            }
            catch (Exception e) {
                throw new ArgumentHandler.HandledArgumentException("argument-handler-player-selector-syntax");
            }
            if (entities.isEmpty()) {
                throw new ArgumentHandler.HandledArgumentException("argument-handler-player-selector-none");
            }
            if (entities.size() > 1) {
                throw new ArgumentHandler.HandledArgumentException("argument-handler-player-selector-multiple");
            }
            Entity selected = (Entity)entities.get(0);
            if (!(selected instanceof Player)) {
                throw new ArgumentHandler.HandledArgumentException("argument-handler-player-selector-entity");
            }
            return (Player)selected;
        }
        Player player = Bukkit.getPlayer((String)input);
        if (player == null) {
            throw new ArgumentHandler.HandledArgumentException("argument-handler-player", StringPlaceholders.of("input", input));
        }
        return player;
    }

    @Override
    public List<String> suggest(CommandContext context, Argument argument, String[] args) {
        return Stream.concat(Stream.of("@p", "@r"), Bukkit.getOnlinePlayers().stream().map(Player::getName)).collect(Collectors.toList());
    }
}

