/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.command.framework;

import dev.rosewood.rosestacker.lib.rosegarden.command.framework.ArgumentCondition;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.ArgumentHandler;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.RoseCommand;
import java.util.Collection;

public interface Argument {
    public String name();

    public boolean optional();

    public ArgumentCondition condition();

    default public String parameter() {
        if (this.optional()) {
            return "[" + this.name() + "]";
        }
        return "<" + this.name() + ">";
    }

    public static class SubCommandArgument
    implements Argument {
        private final String name;
        private final boolean optional;
        private final ArgumentCondition condition;
        private final Collection<RoseCommand> subCommands;

        public SubCommandArgument(String name, boolean optional, ArgumentCondition condition, Collection<RoseCommand> subCommands) {
            this.name = name;
            this.optional = optional;
            this.condition = condition;
            this.subCommands = subCommands;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public boolean optional() {
            return this.optional;
        }

        @Override
        public ArgumentCondition condition() {
            return this.condition;
        }

        public Collection<RoseCommand> subCommands() {
            return this.subCommands;
        }
    }

    public static class CommandArgument<T>
    implements Argument {
        private final String name;
        private final boolean optional;
        private final ArgumentCondition condition;
        private final ArgumentHandler<T> handler;

        public CommandArgument(String name, boolean optional, ArgumentCondition condition, ArgumentHandler<T> handler) {
            this.name = name;
            this.optional = optional;
            this.condition = condition;
            this.handler = handler;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public boolean optional() {
            return this.optional;
        }

        @Override
        public ArgumentCondition condition() {
            return this.condition;
        }

        public ArgumentHandler<T> handler() {
            return this.handler;
        }
    }
}

