/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.command.framework;

import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import dev.rosewood.rosestacker.lib.rosegarden.RosePlugin;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.Argument;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.ArgumentHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;

public class CommandContext {
    private final RosePlugin rosePlugin;
    private final CommandSender sender;
    private final String commandLabel;
    private final String[] rawArguments;
    private final Map<Argument.CommandArgument<?>, Object> parametersByArgument;
    private final List<Argument.CommandArgument<?>> usedParameters;
    private final ListMultimap<Class<?>, Object> parametersByType;
    private final Map<String, Object> parametersByName;
    private final List<Argument> argumentsPath;
    private final Map<Argument, String[]> rawArgumentsPath;

    public CommandContext(RosePlugin rosePlugin, CommandSender sender, String commandLabel, String[] rawArguments) {
        this.rosePlugin = rosePlugin;
        this.sender = sender;
        this.commandLabel = commandLabel;
        this.rawArguments = rawArguments;
        this.parametersByArgument = new LinkedHashMap();
        this.usedParameters = new ArrayList();
        this.parametersByType = MultimapBuilder.hashKeys().arrayListValues().build();
        this.parametersByName = new LinkedHashMap<String, Object>();
        this.argumentsPath = new ArrayList<Argument>();
        this.rawArgumentsPath = new LinkedHashMap<Argument, String[]>();
    }

    public RosePlugin getRosePlugin() {
        return this.rosePlugin;
    }

    public CommandSender getSender() {
        return this.sender;
    }

    public String getCommandLabel() {
        return this.commandLabel;
    }

    public String[] getRawArguments() {
        return Arrays.copyOf(this.rawArguments, this.rawArguments.length);
    }

    public String[] getRawArguments(Argument argument) {
        return this.rawArgumentsPath.getOrDefault(argument, new String[0]);
    }

    protected <T> void put(Argument argument, T value, List<String> input) {
        this.argumentsPath.add(argument);
        this.rawArgumentsPath.put(argument, input.toArray(new String[0]));
        if (argument instanceof Argument.CommandArgument) {
            Argument.CommandArgument commandArgument = (Argument.CommandArgument)argument;
            if (!argument.optional() || value != null) {
                this.usedParameters.add(commandArgument);
            }
            this.parametersByArgument.put(commandArgument, value);
            this.parametersByType.put(commandArgument.handler().getHandledType(), value);
            this.parametersByName.put(commandArgument.name(), value);
        }
    }

    protected void put(Argument argument) {
        this.put(argument, null, Collections.emptyList());
    }

    public <T> T get(Class<T> clazz) {
        return this.get(0, clazz);
    }

    public <T> T get(int index, Class<T> clazz) {
        List values = this.parametersByType.get(clazz);
        if (values.size() <= index) {
            return null;
        }
        return (T)this.parametersByType.get(clazz).get(index);
    }

    public <T> T get(String name) {
        return (T)this.parametersByName.get(name);
    }

    public <T> T get(int index) {
        return (T)Iterables.get(this.parametersByArgument.values(), (int)index, null);
    }

    protected Class<?>[] getUsedArgumentTypes() {
        return (Class[])this.usedParameters.stream().map(Argument.CommandArgument::handler).map(ArgumentHandler::getHandledType).toArray(Class[]::new);
    }

    protected List<Argument> getArgumentsPath() {
        return new ArrayList<Argument>(this.argumentsPath);
    }
}

