/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.command.framework;

import dev.rosewood.rosestacker.lib.rosegarden.command.framework.Argument;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.ArgumentsDefinition;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.RoseCommand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public class CommandExecutionWalker {
    private RoseCommand command;
    private ArgumentsDefinition currentDefinition;
    private int argumentIndex;
    private boolean exited;
    private boolean completed;
    private List<Argument> unconsumed;

    public CommandExecutionWalker(RoseCommand command) {
        this.command = command;
        this.currentDefinition = command.getCommandArguments();
        this.argumentIndex = 0;
        this.exited = false;
        this.completed = this.currentDefinition.size() == 0;
        this.unconsumed = new ArrayList<Argument>();
    }

    public void step(BiFunction<RoseCommand, Argument.CommandArgument<?>, Boolean> walker, Function<Argument.SubCommandArgument, RoseCommand> subCommandSelector) {
        if (this.completed) {
            throw new IllegalStateException("Walker has already finished executing");
        }
        Argument argument = this.currentDefinition.get(this.argumentIndex);
        if (argument instanceof Argument.SubCommandArgument) {
            Argument.SubCommandArgument subCommandArgument = (Argument.SubCommandArgument)argument;
            RoseCommand nextCommand = subCommandSelector.apply(subCommandArgument);
            if (nextCommand == null) {
                this.exited = true;
                return;
            }
            this.command = nextCommand;
            this.currentDefinition = this.command.getCommandArguments();
            this.argumentIndex = 0;
        } else if (argument instanceof Argument.CommandArgument) {
            Argument.CommandArgument commandArgument = (Argument.CommandArgument)argument;
            if (!walker.apply(this.command, commandArgument).booleanValue()) {
                this.exited = true;
                while (++this.argumentIndex < this.currentDefinition.size()) {
                    this.unconsumed.add(this.currentDefinition.get(this.argumentIndex));
                }
                return;
            }
            ++this.argumentIndex;
        } else {
            throw new IllegalStateException("Invalid argument type: " + argument.getClass().getName());
        }
        if (this.argumentIndex >= this.currentDefinition.size()) {
            this.completed = true;
        }
    }

    public List<Argument> walkRemaining() {
        if (this.completed) {
            return Collections.emptyList();
        }
        ArrayList<Argument> remaining = new ArrayList<Argument>();
        while (this.hasNext()) {
            this.step((command, argument) -> {
                remaining.add((Argument)argument);
                return true;
            }, argument -> {
                remaining.add((Argument)argument);
                return null;
            });
        }
        this.completed = true;
        return remaining;
    }

    public List<Argument> getUnconsumed() {
        return this.unconsumed;
    }

    public boolean hasNext() {
        return !this.exited && !this.completed;
    }

    public boolean hasNextStep() {
        return this.currentDefinition.size() > this.argumentIndex + 1;
    }

    public boolean isCompleted() {
        return this.completed && this.command != null;
    }

    public RoseCommand getCurrentCommand() {
        return this.command;
    }
}

