/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.command.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class InputIterator
implements Iterator<String>,
Cloneable {
    private List<String> input;
    private List<String> stack;

    public InputIterator(Collection<String> input) {
        this.input = new LinkedList<String>(input);
        this.stack = new ArrayList<String>(input.size());
    }

    @Override
    public boolean hasNext() {
        return !this.input.isEmpty();
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            return "";
        }
        String value = this.input.remove(0);
        this.stack.add(value);
        return value;
    }

    public String[] next(int amount) {
        String[] result = new String[amount];
        for (int i = 0; i < amount; ++i) {
            result[i] = this.next();
        }
        return result;
    }

    public String peek() {
        if (!this.hasNext()) {
            return "";
        }
        return this.input.get(0);
    }

    public String[] peek(int amount) {
        String[] result = new String[amount];
        InputIterator it = this.clone();
        for (int i = 0; i < amount; ++i) {
            result[i] = it.next();
        }
        return result;
    }

    protected List<String> getStack() {
        return Collections.unmodifiableList(this.stack);
    }

    protected void clearStack() {
        this.stack.clear();
    }

    protected void restore(InputIterator other) {
        this.input = new LinkedList<String>(other.input);
        this.stack = new ArrayList<String>(other.stack);
    }

    public InputIterator clone() {
        try {
            InputIterator clone = (InputIterator)super.clone();
            clone.restore(this);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

