/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.command.framework;

import dev.rosewood.rosestacker.lib.rosegarden.RosePlugin;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.Argument;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.ArgumentHandler;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.ArgumentsDefinition;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.BaseRoseCommand;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.CommandContext;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.CommandExecutionWalker;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.InputIterator;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.RoseCommand;
import dev.rosewood.rosestacker.lib.rosegarden.config.CommentedFileConfiguration;
import dev.rosewood.rosestacker.lib.rosegarden.manager.AbstractLocaleManager;
import dev.rosewood.rosestacker.lib.rosegarden.utils.CommandMapUtils;
import dev.rosewood.rosestacker.lib.rosegarden.utils.StringPlaceholders;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.util.StringUtil;

public class RoseCommandWrapper
extends BukkitCommand {
    private final String namespace;
    private final File dataFolder;
    private final RosePlugin rosePlugin;
    private final BaseRoseCommand command;

    public RoseCommandWrapper(RosePlugin rosePlugin, BaseRoseCommand command) {
        this(rosePlugin.getName().toLowerCase(), rosePlugin.getDataFolder(), rosePlugin, command);
    }

    public RoseCommandWrapper(String namespace, File dataFolder, RosePlugin rosePlugin, BaseRoseCommand command) {
        super("");
        this.namespace = namespace;
        this.dataFolder = dataFolder;
        this.rosePlugin = rosePlugin;
        this.command = command;
    }

    public void register() {
        File commandsDirectory = new File(this.dataFolder, "commands");
        commandsDirectory.mkdirs();
        String commandName = this.command.getCommandInfo().name();
        File commandConfigFile = new File(commandsDirectory, commandName + ".yml");
        boolean exists = commandConfigFile.exists();
        CommentedFileConfiguration commandConfig = CommentedFileConfiguration.loadConfiguration(commandConfigFile);
        AtomicBoolean modified = new AtomicBoolean(false);
        if (!exists) {
            commandConfig.addComments("This file lets you disable the command, change the name and aliases, and set the priority.", "If you edit the name/aliases at the top of this file, you will need to restart the server to see all the changes applied properly.", "Enabling the priority setting will make this command take priority over commands from other plugins on the server.");
            modified.set(true);
        }
        if (!commandConfig.contains("enabled")) {
            commandConfig.set("enabled", true);
            modified.set(true);
        }
        if (!commandConfig.contains("name")) {
            commandConfig.set("name", commandName);
            modified.set(true);
        }
        if (!commandConfig.contains("aliases")) {
            commandConfig.set("aliases", new ArrayList<String>(this.command.getCommandInfo().aliases()));
            modified.set(true);
        }
        if (!commandConfig.contains("priority")) {
            commandConfig.set("priority", this.command.hasPriority());
            modified.set(true);
        }
        this.writeSubcommands(commandConfig, this.command, modified);
        if (modified.get()) {
            commandConfig.save(commandConfigFile);
        }
        if (!commandConfig.getBoolean("enabled", true)) {
            return;
        }
        this.command.setNameAndAliases(commandConfig.getString("name"), commandConfig.getStringList("aliases"));
        this.loadSubCommands(commandConfig, this.command);
        this.setName(this.command.getName());
        this.setAliases(this.command.getAliases());
        this.setPermission(this.command.getPermission());
        String descriptionKey = this.command.getDescriptionKey();
        if (descriptionKey != null) {
            AbstractLocaleManager localeManager = this.rosePlugin.getManager(AbstractLocaleManager.class);
            this.setDescription(localeManager.getCommandLocaleMessage(this.command.getDescriptionKey()));
        }
        CommandMapUtils.registerCommand(this.namespace, (Command)this, commandConfig.getBoolean("priority", false));
    }

    private void writeSubcommands(ConfigurationSection section, RoseCommand command, AtomicBoolean modified) {
        CommandExecutionWalker walker = new CommandExecutionWalker(command);
        while (walker.hasNext()) {
            walker.step((cmd, argument) -> true, argument -> {
                List editableSubcommands = argument.subCommands().stream().filter(BaseRoseCommand.class::isInstance).map(BaseRoseCommand.class::cast).collect(Collectors.toList());
                if (editableSubcommands.isEmpty()) {
                    return null;
                }
                ConfigurationSection subCommandsSection = section.getConfigurationSection("subcommands");
                if (subCommandsSection == null) {
                    subCommandsSection = section.createSection("subcommands");
                    modified.set(true);
                }
                for (BaseRoseCommand subCommand : editableSubcommands) {
                    ConfigurationSection subCommandSection = subCommandsSection.getConfigurationSection(subCommand.getCommandInfo().name());
                    if (subCommandSection == null) {
                        subCommandSection = subCommandsSection.createSection(subCommand.getCommandInfo().name());
                        modified.set(true);
                    }
                    if (!subCommandSection.contains("name")) {
                        subCommandSection.set("name", (Object)subCommand.getCommandInfo().name());
                        modified.set(true);
                    }
                    if (!subCommandSection.contains("aliases")) {
                        subCommandSection.set("aliases", new ArrayList<String>(subCommand.getCommandInfo().aliases()));
                        modified.set(true);
                    }
                    this.writeSubcommands(subCommandSection, subCommand, modified);
                }
                return null;
            });
        }
    }

    private void loadSubCommands(ConfigurationSection section, BaseRoseCommand command) {
        CommandExecutionWalker walker = new CommandExecutionWalker(command);
        while (walker.hasNext()) {
            walker.step((cmd, argument) -> true, argument -> {
                List editableSubcommands = argument.subCommands().stream().filter(BaseRoseCommand.class::isInstance).map(BaseRoseCommand.class::cast).collect(Collectors.toList());
                if (editableSubcommands.isEmpty()) {
                    return null;
                }
                ConfigurationSection subCommandsSection = section.getConfigurationSection("subcommands");
                if (subCommandsSection == null) {
                    return null;
                }
                for (BaseRoseCommand subCommand : editableSubcommands) {
                    ConfigurationSection subCommandSection = subCommandsSection.getConfigurationSection(subCommand.getCommandInfo().name());
                    if (subCommandSection == null) continue;
                    subCommand.setNameAndAliases(subCommandSection.getString("name"), subCommandSection.getStringList("aliases"));
                    this.loadSubCommands(subCommandSection, subCommand);
                }
                return null;
            });
        }
    }

    public void unregister() {
        CommandMapUtils.unregisterCommand((Command)this);
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        AbstractLocaleManager localeManager = this.rosePlugin.getManager(AbstractLocaleManager.class);
        if (this.command.isPlayerOnly() && !(sender instanceof Player)) {
            localeManager.sendCommandMessage(sender, "only-player");
            return true;
        }
        if (!this.command.canUse((Permissible)sender)) {
            localeManager.sendCommandMessage(sender, "no-permission");
            return true;
        }
        CommandContext context = new CommandContext(this.rosePlugin, sender, commandLabel, args);
        CommandExecutionWalker walker = new CommandExecutionWalker(this.command);
        InputIterator inputIterator = new InputIterator(Arrays.asList(args));
        AtomicBoolean shownErrorMessage = new AtomicBoolean();
        boolean missingArgs = false;
        while (walker.hasNext()) {
            if (!inputIterator.hasNext()) {
                List<Argument> remainingArguments = walker.walkRemaining();
                if (remainingArguments.stream().allMatch(Argument::optional)) break;
                remainingArguments.forEach(context::put);
                missingArgs = true;
                break;
            }
            walker.step((command, argument) -> {
                if (!argument.condition().test(context)) {
                    context.put((Argument)argument);
                    return true;
                }
                inputIterator.clearStack();
                InputIterator beforeState = inputIterator.clone();
                try {
                    ArgumentHandler handler = argument.handler();
                    Object parsedArgument = handler.handle(context, (Argument)argument, inputIterator);
                    context.put((Argument)argument, parsedArgument, inputIterator.getStack());
                    return true;
                }
                catch (ArgumentHandler.HandledArgumentException e) {
                    if (argument.optional() && walker.hasNextStep()) {
                        inputIterator.restore(beforeState);
                        context.put((Argument)argument);
                        return true;
                    }
                    String message = localeManager.getCommandLocaleMessage(e.getMessage(), e.getPlaceholders());
                    localeManager.sendCommandMessage(sender, "invalid-argument", StringPlaceholders.of("message", message));
                    if (!walker.hasNextStep() || inputIterator.hasNext()) {
                        shownErrorMessage.set(true);
                    }
                    context.put((Argument)argument);
                    return false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    localeManager.sendCommandMessage(sender, "unknown-command-error");
                    shownErrorMessage.set(true);
                    context.put((Argument)argument);
                    return false;
                }
            }, argument -> {
                if (!argument.condition().test(context)) {
                    return null;
                }
                String input = inputIterator.next();
                RoseCommand match = argument.subCommands().stream().filter(subCommand -> Stream.concat(Stream.of(subCommand.getName()), subCommand.getAliases().stream()).anyMatch(s -> s.equalsIgnoreCase(input))).findFirst().orElse(null);
                if (match == null) {
                    localeManager.sendCommandMessage(sender, "invalid-subcommand");
                    shownErrorMessage.set(true);
                    context.put((Argument)argument);
                    return null;
                }
                if (match.isPlayerOnly() && !(sender instanceof Player)) {
                    localeManager.sendCommandMessage(sender, "only-player");
                    shownErrorMessage.set(true);
                    context.put((Argument)argument);
                    return null;
                }
                if (!match.canUse((Permissible)sender)) {
                    localeManager.sendCommandMessage(sender, "no-permission");
                    shownErrorMessage.set(true);
                    context.put((Argument)argument);
                    return null;
                }
                context.put((Argument)argument, null, Collections.singletonList(input));
                return match;
            });
        }
        if (walker.isCompleted() && !missingArgs) {
            RoseCommand commandToExecute = walker.getCurrentCommand();
            if (!commandToExecute.canUse((Permissible)sender)) {
                localeManager.sendCommandMessage(sender, "no-permission");
                return true;
            }
            commandToExecute.invoke(context);
        } else if (!shownErrorMessage.get()) {
            List<Argument> allArguments = context.getArgumentsPath();
            allArguments.addAll(walker.walkRemaining());
            allArguments.addAll(walker.getUnconsumed());
            String argumentsString = ArgumentsDefinition.getParametersString(context, allArguments);
            localeManager.sendCommandMessage(sender, "command-usage", StringPlaceholders.of("cmd", context.getCommandLabel(), "args", argumentsString));
        }
        return true;
    }

    public List<String> tabComplete(CommandSender sender, String commandLabel, String[] args) {
        boolean isPlayer = sender instanceof Player;
        if (this.command.isPlayerOnly() && !isPlayer || !this.command.canUse((Permissible)sender)) {
            return Collections.emptyList();
        }
        CommandContext context = new CommandContext(this.rosePlugin, sender, commandLabel, args);
        CommandExecutionWalker walker = new CommandExecutionWalker(this.command);
        InputIterator inputIterator = new InputIterator(Arrays.asList(args));
        ArrayList<String> suggestions = new ArrayList<String>();
        while (walker.hasNext()) {
            walker.step((command, argument) -> {
                if (!argument.condition().test(context)) {
                    return true;
                }
                if (!inputIterator.hasNext()) {
                    suggestions.addAll(argument.handler().suggest(context, (Argument)argument, new String[0]));
                    return argument.optional();
                }
                inputIterator.clearStack();
                InputIterator beforeState = inputIterator.clone();
                try {
                    ArgumentHandler handler = argument.handler();
                    String input = inputIterator.peek();
                    if (input.isEmpty()) {
                        throw new ArgumentHandler.HandledArgumentException("");
                    }
                    Object parsedArgument = handler.handle(context, (Argument)argument, inputIterator);
                    if (!inputIterator.hasNext()) {
                        String[] remainingArgs = inputIterator.getStack().toArray(new String[0]);
                        argument.handler().suggest(context, (Argument)argument, remainingArgs).stream().filter(x -> StringUtil.startsWithIgnoreCase((String)x, (String)String.join((CharSequence)" ", remainingArgs))).forEach(suggestions::add);
                        return argument.optional();
                    }
                    context.put((Argument)argument, parsedArgument, inputIterator.getStack());
                    return true;
                }
                catch (ArgumentHandler.HandledArgumentException e) {
                    ArrayList<String> remainingInput = new ArrayList<String>(inputIterator.getStack());
                    while (inputIterator.hasNext()) {
                        remainingInput.add(inputIterator.next());
                    }
                    String[] remainingArgs = remainingInput.toArray(new String[0]);
                    argument.handler().suggest(context, (Argument)argument, remainingArgs).stream().filter(x -> StringUtil.startsWithIgnoreCase((String)x, (String)String.join((CharSequence)" ", remainingInput))).forEach(suggestions::add);
                    if (argument.optional() && walker.hasNextStep()) {
                        inputIterator.restore(beforeState);
                        return true;
                    }
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }, argument -> {
                if (!argument.condition().test(context)) {
                    return null;
                }
                if (!inputIterator.hasNext()) {
                    this.streamUsableSubCommands((Argument.SubCommandArgument)argument, sender).flatMap(x -> Stream.concat(Stream.of(x.getName()), x.getAliases().stream())).forEach(suggestions::add);
                    return null;
                }
                String input = inputIterator.next();
                RoseCommand subCommand = this.streamUsableSubCommands((Argument.SubCommandArgument)argument, sender).filter(x -> Stream.concat(Stream.of(x.getName()), x.getAliases().stream()).anyMatch(s -> s.equalsIgnoreCase(input))).findFirst().orElse(null);
                if (subCommand != null) {
                    if (!inputIterator.hasNext()) {
                        return null;
                    }
                    return subCommand;
                }
                this.streamUsableSubCommands((Argument.SubCommandArgument)argument, sender).flatMap(x -> Stream.concat(Stream.of(x.getName()), x.getAliases().stream())).filter(x -> StringUtil.startsWithIgnoreCase((String)x, (String)input)).forEach(suggestions::add);
                return null;
            });
        }
        return suggestions;
    }

    private Stream<RoseCommand> streamUsableSubCommands(Argument.SubCommandArgument argument, CommandSender sender) {
        return argument.subCommands().stream().filter(x -> x.canUse((Permissible)sender)).filter(x -> !x.isPlayerOnly() || sender instanceof Player);
    }

    public String getName() {
        return this.command.getName();
    }

    public List<String> getAliases() {
        return this.command.getAliases();
    }

    public String getPermission() {
        return this.command.getPermission();
    }

    public BaseRoseCommand getWrappedCommand() {
        return this.command;
    }
}

