/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.command.rwd;

import dev.rosewood.rosestacker.lib.rosegarden.RosePlugin;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.BaseRoseCommand;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.CommandContext;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.CommandInfo;
import dev.rosewood.rosestacker.lib.rosegarden.command.framework.annotation.RoseExecutable;
import dev.rosewood.rosestacker.lib.rosegarden.objects.RosePluginData;
import dev.rosewood.rosestacker.lib.rosegarden.utils.HexUtils;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;

public class RwdCommand
extends BaseRoseCommand {
    public RwdCommand(RosePlugin rosePlugin) {
        super(rosePlugin);
    }

    @Override
    protected CommandInfo createCommandInfo() {
        return CommandInfo.builder("rwd").permission("rosegarden.rwd").build();
    }

    @RoseExecutable
    public void execute(CommandContext context) {
        List<RosePluginData> pluginData = this.rosePlugin.getLoadedRosePluginsData();
        ComponentBuilder builder = new ComponentBuilder();
        builder.append(TextComponent.fromLegacyText((String)HexUtils.colorify("&7[<g:#8A2387:#E94057:#F27121>RoseGarden&7] &ePlugins installed using <g:#8A2387:#E94057:#F27121>RoseGarden &eby <g:#8A2387:#E94057:#F27121>Rosewood Development&e. Hover over to view info: ")));
        boolean first = true;
        for (RosePluginData data : pluginData) {
            if (!first) {
                builder.append(TextComponent.fromLegacyText((String)HexUtils.colorify("&e, ")), ComponentBuilder.FormatRetention.NONE);
            }
            first = false;
            String updateVersion = data.updateVersion();
            String website = data.website();
            ArrayList<Text> content = new ArrayList<Text>();
            content.add(new Text(TextComponent.fromLegacyText((String)HexUtils.colorify("&ePlugin Version: &b" + data.version()))));
            content.add(new Text(TextComponent.fromLegacyText((String)HexUtils.colorify("\n&eRoseGarden Version: &b" + data.roseGardenVersion()))));
            if (data.authors().size() == 1) {
                content.add(new Text(TextComponent.fromLegacyText((String)HexUtils.colorify("\n&eAuthor: &b" + data.authors().get(0)))));
            } else if (data.authors().size() > 1) {
                content.add(new Text(TextComponent.fromLegacyText((String)HexUtils.colorify("\n&eAuthors: &b" + String.join((CharSequence)"&e, &b", data.authors())))));
            }
            if (updateVersion != null) {
                content.add(new Text(TextComponent.fromLegacyText((String)HexUtils.colorify("\n&eAn update (&b" + updateVersion + "&e) is available! Click to open the Spigot page."))));
            }
            TextComponent pluginName = new TextComponent(TextComponent.fromLegacyText((String)HexUtils.colorify("<g:#8A2387:#E94057:#F27121>" + data.name())));
            pluginName.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Content[])content.toArray(new Text[0])));
            if (website != null) {
                pluginName.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, data.website()));
            }
            builder.append((BaseComponent)pluginName);
        }
        context.getSender().spigot().sendMessage(builder.create());
    }
}

