/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.compatibility;

import dev.rosewood.rosestacker.lib.rosegarden.compatibility.handler.CreatureSpawnerHandler;
import dev.rosewood.rosestacker.lib.rosegarden.compatibility.handler.InventoryViewHandler;
import dev.rosewood.rosestacker.lib.rosegarden.compatibility.handler.OldEnumHandler;
import dev.rosewood.rosestacker.lib.rosegarden.compatibility.handler.ShearedHandler;

public final class CompatibilityAdapter {
    private static final String PACKAGE = "dev.rosewood.rosestacker.lib.rosegarden.compatibility.handler.";
    private static final InventoryViewHandler INVENTORY_VIEW_HANDLER;
    private static final ShearedHandler SHEARED_HANDLER;
    private static final CreatureSpawnerHandler CREATURE_SPAWNER_HANDLER;
    private static final OldEnumHandler OLD_ENUM_HANDLER;

    public static InventoryViewHandler getInventoryViewHandler() {
        return INVENTORY_VIEW_HANDLER;
    }

    public static ShearedHandler getShearedHandler() {
        return SHEARED_HANDLER;
    }

    public static CreatureSpawnerHandler getCreatureSpawnerHandler() {
        return CREATURE_SPAWNER_HANDLER;
    }

    public static OldEnumHandler getOldEnumHandler() {
        return OLD_ENUM_HANDLER;
    }

    private static <T> T lookupHandler(Class<T> handlerClass, boolean current) {
        try {
            String lookupClassName = PACKAGE + (current ? "Current" : "Legacy") + handlerClass.getSimpleName();
            Class<?> lookupClass = Class.forName(lookupClassName);
            return handlerClass.cast(lookupClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new CompatibilityLookupException("Failed to look up compatibility handler for " + handlerClass.getSimpleName(), e);
        }
    }

    private static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static {
        try {
            INVENTORY_VIEW_HANDLER = CompatibilityAdapter.lookupHandler(InventoryViewHandler.class, Class.forName("org.bukkit.inventory.InventoryView").isInterface());
            SHEARED_HANDLER = CompatibilityAdapter.lookupHandler(ShearedHandler.class, CompatibilityAdapter.classExists("org.bukkit.entity.Shearable"));
            CREATURE_SPAWNER_HANDLER = CompatibilityAdapter.lookupHandler(CreatureSpawnerHandler.class, CompatibilityAdapter.classExists("org.bukkit.spawner.Spawner"));
            OLD_ENUM_HANDLER = CompatibilityAdapter.lookupHandler(OldEnumHandler.class, Class.forName("org.bukkit.entity.Villager$Profession").isInterface());
        }
        catch (ReflectiveOperationException e) {
            throw new CompatibilityLookupException("Failed to initialize compatibility handler", e);
        }
    }

    public static class CompatibilityLookupException
    extends RuntimeException {
        public CompatibilityLookupException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

