/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.config;

import dev.rosewood.rosestacker.lib.rosegarden.config.PDCDelegatingSettingSerializer;
import dev.rosewood.rosestacker.lib.rosegarden.config.SettingSerializer;
import java.util.function.Function;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.persistence.PersistentDataType;

public abstract class BaseSettingSerializer<T>
implements SettingSerializer<T> {
    protected final Class<T> type;
    protected final Function<T, String> asStringFunction;
    protected final Function<String, T> fromStringFunction;

    public BaseSettingSerializer(Class<T> type, Function<T, String> asStringFunction, Function<String, T> fromStringFunction) {
        this.type = type;
        this.asStringFunction = asStringFunction;
        this.fromStringFunction = fromStringFunction;
    }

    public BaseSettingSerializer(Class<T> type) {
        this(type, null, null);
    }

    @Override
    public abstract void write(ConfigurationSection var1, String var2, T var3, String ... var4);

    @Override
    public abstract T read(ConfigurationSection var1, String var2);

    @Override
    public final boolean isStringKey() {
        return this.asStringFunction != null && this.fromStringFunction != null;
    }

    @Override
    public final String asStringKey(T key) {
        if (this.asStringFunction == null) {
            throw new UnsupportedOperationException("asStringKey not available, check isStringKey() first");
        }
        return this.asStringFunction.apply(key);
    }

    @Override
    public final T fromStringKey(String key) {
        if (this.fromStringFunction == null) {
            throw new UnsupportedOperationException("fromStringKey not available, check isStringKey() first");
        }
        return this.fromStringFunction.apply(key);
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public SettingSerializer.PDCAdapter<T> pdc() {
        return new DelegateAdapter();
    }

    public class DelegateAdapter
    implements SettingSerializer.PDCAdapter<T> {
        @Override
        public PDCDelegatingSettingSerializer<T> adapt(PersistentDataType<?, T> pdc) {
            return new PDCDelegatingSettingSerializer(BaseSettingSerializer.this, pdc);
        }
    }
}

