/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.config;

import dev.rosewood.rosestacker.lib.rosegarden.config.BasicRoseSetting;
import dev.rosewood.rosestacker.lib.rosegarden.config.PDCRoseSetting;
import dev.rosewood.rosestacker.lib.rosegarden.config.PDCSettingSerializer;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;

class PDCBasicRoseSetting<T>
extends BasicRoseSetting<T>
implements PDCRoseSetting<T> {
    private final PDCSettingSerializer<T> pdcSerializer;

    protected PDCBasicRoseSetting(PDCSettingSerializer<T> serializer, String key, Supplier<T> defaultValueSupplier, boolean hidden, String ... comments) {
        super(serializer, key, defaultValueSupplier, hidden, comments);
        this.pdcSerializer = serializer;
    }

    @Override
    public PDCSettingSerializer<T> getSerializer() {
        return this.pdcSerializer;
    }

    @Override
    public PDCRoseSetting<T> copy(T defaultValue, String ... comments) {
        return this.copy(() -> defaultValue, comments);
    }

    @Override
    public PDCRoseSetting<T> copy(Supplier<T> defaultValueSupplier, String ... comments) {
        String[] newComments = comments == null ? new String[]{} : Arrays.copyOf(this.comments, this.comments.length);
        return new PDCBasicRoseSetting<T>(this.pdcSerializer, this.key, defaultValueSupplier, false, newComments);
    }

    @Override
    public String toString() {
        return "PDCBasicRoseSetting{key='" + this.key + '\'' + ", defaultValue=" + this.defaultValueSupplier.get() + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof PDCBasicRoseSetting)) {
            return false;
        }
        PDCBasicRoseSetting that = (PDCBasicRoseSetting)o;
        return Objects.equals(this.pdcSerializer, that.pdcSerializer) && Objects.equals(this.key, that.key);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pdcSerializer, this.key);
    }
}

