/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.config;

import dev.rosewood.rosestacker.lib.rosegarden.config.FieldMappedSettingSerializer;
import dev.rosewood.rosestacker.lib.rosegarden.config.PDCSettingSerializer;
import dev.rosewood.rosestacker.lib.rosegarden.config.SettingSerializer;
import java.util.Collections;
import java.util.Map;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class PDCFieldMappedSettingSerializer<T, M>
extends FieldMappedSettingSerializer<T, M>
implements PDCSettingSerializer<T> {
    private final PDCSettingSerializer<M> fieldSerializer;
    private final Map<M, PDCSettingSerializer<? extends T>> mapper;

    public PDCFieldMappedSettingSerializer(Class<T> type, String fieldKey, PDCSettingSerializer<M> fieldSerializer, Map<M, PDCSettingSerializer<? extends T>> mapper) {
        super(type, fieldKey, fieldSerializer, Collections.unmodifiableMap(mapper));
        this.fieldSerializer = fieldSerializer;
        this.mapper = mapper;
    }

    @Override
    public void write(PersistentDataContainer container, String key, T value) {
        SettingSerializer serializer = this.mapField((Object)this.fieldSerializer.read(container, this.fieldKey));
        if (serializer != null) {
            serializer.write(container, key, value);
        }
    }

    @Override
    public T read(PersistentDataContainer container, String key) {
        SettingSerializer serializer = this.mapField((Object)this.fieldSerializer.read(container, this.fieldKey));
        return serializer != null ? (T)serializer.read(container, key) : null;
    }

    @Override
    protected PDCSettingSerializer<T> mapField(M value) {
        if (value == null) {
            return null;
        }
        try {
            SettingSerializer serializer = this.mapper.get(value);
            return (PDCSettingSerializer)serializer;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public PersistentDataType<?, T> getPDCType() {
        throw new UnsupportedOperationException("No strict PDC type");
    }
}

