/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.config;

import dev.rosewood.rosestacker.lib.rosegarden.config.PDCBasicRoseSetting;
import dev.rosewood.rosestacker.lib.rosegarden.config.PDCSettingSerializer;
import dev.rosewood.rosestacker.lib.rosegarden.config.PDCSettingSerializers;
import dev.rosewood.rosestacker.lib.rosegarden.config.RoseSetting;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public interface PDCRoseSetting<T>
extends RoseSetting<T> {
    @Override
    public PDCSettingSerializer<T> getSerializer();

    @Override
    public PDCRoseSetting<T> copy(T var1, String ... var2);

    @Override
    public PDCRoseSetting<T> copy(Supplier<T> var1, String ... var2);

    public static PDCRoseSetting<Boolean> ofBoolean(String name, boolean defaultValue, String ... comments) {
        return PDCRoseSetting.of(name, PDCSettingSerializers.BOOLEAN, () -> defaultValue, comments);
    }

    public static PDCRoseSetting<Integer> ofInteger(String name, int defaultValue, String ... comments) {
        return PDCRoseSetting.of(name, PDCSettingSerializers.INTEGER, () -> defaultValue, comments);
    }

    public static PDCRoseSetting<Long> ofLong(String name, long defaultValue, String ... comments) {
        return PDCRoseSetting.of(name, PDCSettingSerializers.LONG, () -> defaultValue, comments);
    }

    public static PDCRoseSetting<Short> ofShort(String name, short defaultValue, String ... comments) {
        return PDCRoseSetting.of(name, PDCSettingSerializers.SHORT, () -> defaultValue, comments);
    }

    public static PDCRoseSetting<Byte> ofByte(String name, byte defaultValue, String ... comments) {
        return PDCRoseSetting.of(name, PDCSettingSerializers.BYTE, () -> defaultValue, comments);
    }

    public static PDCRoseSetting<Double> ofDouble(String name, double defaultValue, String ... comments) {
        return PDCRoseSetting.of(name, PDCSettingSerializers.DOUBLE, () -> defaultValue, comments);
    }

    public static PDCRoseSetting<Float> ofFloat(String name, float defaultValue, String ... comments) {
        return PDCRoseSetting.of(name, PDCSettingSerializers.FLOAT, () -> Float.valueOf(defaultValue), comments);
    }

    public static PDCRoseSetting<Character> ofCharacter(String name, char defaultValue, String ... comments) {
        return PDCRoseSetting.of(name, PDCSettingSerializers.CHAR, () -> Character.valueOf(defaultValue), comments);
    }

    public static PDCRoseSetting<String> ofString(String name, String defaultValue, String ... comments) {
        return PDCRoseSetting.of(name, PDCSettingSerializers.STRING, () -> defaultValue, comments);
    }

    public static PDCRoseSetting<List<String>> ofStringList(String name, List<String> defaultValue, String ... comments) {
        return PDCRoseSetting.of(name, PDCSettingSerializers.STRING_LIST, () -> new ArrayList(defaultValue), comments);
    }

    public static <T extends Enum<T>> PDCRoseSetting<T> ofEnum(String name, Class<T> enumClass, T defaultValue, String ... comments) {
        return PDCRoseSetting.of(name, PDCSettingSerializers.ofEnum(enumClass), () -> defaultValue, comments);
    }

    public static <T> PDCRoseSetting<T> ofValue(String name, PDCSettingSerializer<T> serializer, T defaultValue, String ... comments) {
        return new PDCBasicRoseSetting<Object>(serializer, name.toLowerCase(), () -> defaultValue, false, comments != null ? comments : new String[]{});
    }

    public static <T> PDCRoseSetting<T> of(String name, PDCSettingSerializer<T> serializer, Supplier<T> defaultValueSupplier, String ... comments) {
        return new PDCBasicRoseSetting<T>(serializer, name.toLowerCase(), defaultValueSupplier, false, comments != null ? comments : new String[]{});
    }

    public static <T> PDCRoseSetting<T> ofHiddenValue(String name, PDCSettingSerializer<T> serializer, T defaultValue) {
        return new PDCBasicRoseSetting<Object>(serializer, name.toLowerCase(), () -> defaultValue, true, new String[0]);
    }

    public static <T> PDCRoseSetting<T> ofHidden(String name, PDCSettingSerializer<T> serializer, Supplier<T> defaultValueSupplier) {
        return new PDCBasicRoseSetting<T>(serializer, name.toLowerCase(), defaultValueSupplier, true, new String[0]);
    }
}

