/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.config;

import dev.rosewood.rosestacker.lib.rosegarden.config.PDCDelegatingSettingSerializer;
import dev.rosewood.rosestacker.lib.rosegarden.config.PDCFieldMappedSettingSerializer;
import dev.rosewood.rosestacker.lib.rosegarden.config.PDCRecordSettingSerializerBuilder;
import dev.rosewood.rosestacker.lib.rosegarden.config.PDCSettingField;
import dev.rosewood.rosestacker.lib.rosegarden.config.PDCSettingSerializer;
import dev.rosewood.rosestacker.lib.rosegarden.config.SettingSerializerFactories;
import dev.rosewood.rosestacker.lib.rosegarden.config.SettingSerializers;
import dev.rosewood.rosestacker.lib.rosegarden.datatype.CustomPersistentDataType;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.Vector;

public final class PDCSettingSerializers {
    public static final PDCSettingSerializer<Boolean> BOOLEAN = SettingSerializers.BOOLEAN.pdc().adapt(PersistentDataType.BOOLEAN);
    public static final PDCSettingSerializer<Integer> INTEGER = SettingSerializers.INTEGER.pdc().adapt(PersistentDataType.INTEGER);
    public static final PDCSettingSerializer<Long> LONG = SettingSerializers.LONG.pdc().adapt(PersistentDataType.LONG);
    public static final PDCSettingSerializer<Short> SHORT = SettingSerializers.SHORT.pdc().adapt(PersistentDataType.SHORT);
    public static final PDCSettingSerializer<Byte> BYTE = SettingSerializers.BYTE.pdc().adapt(PersistentDataType.BYTE);
    public static final PDCSettingSerializer<Double> DOUBLE = SettingSerializers.DOUBLE.pdc().adapt(PersistentDataType.DOUBLE);
    public static final PDCSettingSerializer<Float> FLOAT = SettingSerializers.FLOAT.pdc().adapt(PersistentDataType.FLOAT);
    public static final PDCSettingSerializer<Character> CHAR = SettingSerializers.CHAR.pdc().adapt(CustomPersistentDataType.CHARACTER);
    public static final PDCSettingSerializer<List<Boolean>> BOOLEAN_LIST = PDCSettingSerializers.ofList(BOOLEAN);
    public static final PDCSettingSerializer<List<Long>> LONG_LIST = PDCSettingSerializers.ofList(LONG);
    public static final PDCSettingSerializer<List<Short>> SHORT_LIST = PDCSettingSerializers.ofList(SHORT);
    public static final PDCSettingSerializer<List<Byte>> BYTE_LIST = PDCSettingSerializers.ofList(BYTE);
    public static final PDCSettingSerializer<List<Double>> DOUBLE_LIST = PDCSettingSerializers.ofList(DOUBLE);
    public static final PDCSettingSerializer<List<Float>> FLOAT_LIST = PDCSettingSerializers.ofList(FLOAT);
    public static final PDCSettingSerializer<List<Character>> CHAR_LIST = PDCSettingSerializers.ofList(CHAR);
    public static final PDCSettingSerializer<String> STRING = SettingSerializers.STRING.pdc().adapt(PersistentDataType.STRING);
    public static final PDCSettingSerializer<List<String>> STRING_LIST = PDCSettingSerializers.ofList(STRING);
    public static final PDCSettingSerializer<Material> MATERIAL = PDCSettingSerializers.ofEnum(Material.class);
    public static final PDCSettingSerializer<List<Material>> MATERIAL_LIST = PDCSettingSerializers.ofList(MATERIAL);
    public static final PDCSettingSerializer<Vector> VECTOR = PDCSettingSerializers.ofRecord(Vector.class, instance -> instance.group(PDCSettingField.of("x", DOUBLE, Vector::getX, new String[0]), PDCSettingField.of("y", DOUBLE, Vector::getY, new String[0]), PDCSettingField.of("z", DOUBLE, Vector::getZ, new String[0])).apply((PDCRecordSettingSerializerBuilder<Vector>)instance, Vector::new));

    private PDCSettingSerializers() {
    }

    public static <T extends Enum<T>> PDCSettingSerializer<T> ofEnum(Class<T> enumClass) {
        return SettingSerializerFactories.ofEnum(enumClass).pdc().adapt(CustomPersistentDataType.forEnum(enumClass));
    }

    public static <T extends Keyed> PDCSettingSerializer<T> ofKeyed(Class<T> keyedClass, Function<NamespacedKey, T> valueOfFunction) {
        return SettingSerializerFactories.ofKeyed(keyedClass, valueOfFunction).pdc().adapt(CustomPersistentDataType.forKeyed(keyedClass, valueOfFunction));
    }

    public static <T> PDCSettingSerializer<T[]> ofArray(PDCSettingSerializer<T> serializer) {
        return SettingSerializerFactories.ofArray(serializer).pdc().adapt(CustomPersistentDataType.forArray(serializer.getPDCType()));
    }

    public static <T> PDCSettingSerializer<List<T>> ofList(PDCSettingSerializer<T> serializer) {
        return SettingSerializerFactories.ofList(serializer).pdc().adapt(CustomPersistentDataType.forList(serializer.getPDCType()));
    }

    public static <K, V> PDCSettingSerializer<Map<K, V>> ofMap(PDCSettingSerializer<K> keySerializer, PDCSettingSerializer<V> valueSerializer) {
        return new PDCDelegatingSettingSerializer<Map<K, V>>(SettingSerializerFactories.ofMap(keySerializer, valueSerializer), CustomPersistentDataType.forMap(keySerializer.getPDCType(), valueSerializer.getPDCType()));
    }

    public static <O> PDCSettingSerializer<O> ofRecord(Class<O> clazz, Function<PDCRecordSettingSerializerBuilder<O>, PDCRecordSettingSerializerBuilder.BuiltPDC<O>> builder) {
        return PDCRecordSettingSerializerBuilder.createPDC(clazz, builder);
    }

    public static <T, M> PDCSettingSerializer<T> ofFieldMapped(Class<T> type, String fieldKey, PDCSettingSerializer<M> fieldSerializer, Map<M, PDCSettingSerializer<? extends T>> mapper) {
        return new PDCFieldMappedSettingSerializer<T, M>(type, fieldKey, fieldSerializer, mapper);
    }
}

