/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.config;

import dev.rosewood.rosestacker.lib.rosegarden.config.BaseSettingSerializer;
import dev.rosewood.rosestacker.lib.rosegarden.config.Functions;
import dev.rosewood.rosestacker.lib.rosegarden.config.RecordFieldGroups;
import dev.rosewood.rosestacker.lib.rosegarden.config.SettingField;
import dev.rosewood.rosestacker.lib.rosegarden.config.SettingSerializer;
import dev.rosewood.rosestacker.lib.rosegarden.config.SettingSerializerFactories;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;

public class RecordSettingSerializerBuilder<O> {
    protected final Class<O> type;
    protected SettingSerializer<O> serializer;

    RecordSettingSerializerBuilder(Class<O> type) {
        this.type = type;
    }

    private static <T, O> T getValueOrDefault(ConfigurationSection section, SettingField<O, T> settingField) {
        T value;
        if (section == null) {
            return null;
        }
        if (settingField.flatten()) {
            section = RecordSettingSerializerBuilder.liftSection(section, settingField.key());
        }
        if ((value = settingField.settingSerializer().read(section, settingField.key())) == null) {
            value = settingField.defaultValue();
        }
        return value;
    }

    private static ConfigurationSection liftSection(ConfigurationSection section, String key) {
        MemoryConfiguration liftedSection = new MemoryConfiguration();
        Map map = section.getValues(true);
        String prefix = key + ".";
        map.forEach((path, val) -> {
            liftedSection.set(prefix + path, val);
            liftedSection.set(path, val);
        });
        return liftedSection;
    }

    private static <T, O> void writeConfigurationField(ConfigurationSection section, SettingField<O, T> settingField, O value, boolean writeDefaults) {
        ConfigurationSection flatteningSection;
        if (value == null) {
            return;
        }
        ConfigurationSection checkSection = section;
        if (settingField.flatten()) {
            checkSection = RecordSettingSerializerBuilder.liftSection(checkSection, settingField.key());
        }
        if (settingField.settingSerializer().readIsValid(checkSection, settingField.key())) {
            return;
        }
        if (writeDefaults) {
            settingField.settingSerializer().writeWithDefault(section, settingField.key(), settingField.getter().apply(value), settingField.comments());
        } else {
            settingField.settingSerializer().write(section, settingField.key(), settingField.getter().apply(value), settingField.comments());
        }
        if (settingField.flatten() && section.isConfigurationSection(settingField.key()) && (flatteningSection = section.getConfigurationSection(settingField.key())) != null) {
            Map map = flatteningSection.getValues(true);
            section.set(settingField.key(), null);
            map.forEach((arg_0, arg_1) -> ((ConfigurationSection)section).set(arg_0, arg_1));
        }
    }

    private static <T, O> boolean testSection(ConfigurationSection section, SettingField<O, T> settingField) {
        if (settingField.optional()) {
            return true;
        }
        if (settingField.flatten()) {
            section = RecordSettingSerializerBuilder.liftSection(section, settingField.key());
        }
        return settingField.settingSerializer().readIsValid(section, settingField.key());
    }

    public static <O> SettingSerializer<O> create(Class<O> clazz, Function<RecordSettingSerializerBuilder<O>, Built<O>> builder) {
        Built<O> built = builder.apply(new RecordSettingSerializerBuilder<O>(clazz));
        RecordSettingSerializerBuilder instance = ((Built)built).instance();
        return instance.serializer;
    }

    public <T1> RecordFieldGroups.Group1<O, T1> group(SettingField<O, T1> t1) {
        return new RecordFieldGroups.Group1<O, T1>(t1);
    }

    public <T1, T2> RecordFieldGroups.Group2<O, T1, T2> group(SettingField<O, T1> t1, SettingField<O, T2> t2) {
        return new RecordFieldGroups.Group2<O, T1, T2>(t1, t2);
    }

    public <T1, T2, T3> RecordFieldGroups.Group3<O, T1, T2, T3> group(SettingField<O, T1> t1, SettingField<O, T2> t2, SettingField<O, T3> t3) {
        return new RecordFieldGroups.Group3<O, T1, T2, T3>(t1, t2, t3);
    }

    public <T1, T2, T3, T4> RecordFieldGroups.Group4<O, T1, T2, T3, T4> group(SettingField<O, T1> t1, SettingField<O, T2> t2, SettingField<O, T3> t3, SettingField<O, T4> t4) {
        return new RecordFieldGroups.Group4<O, T1, T2, T3, T4>(t1, t2, t3, t4);
    }

    public <T1, T2, T3, T4, T5> RecordFieldGroups.Group5<O, T1, T2, T3, T4, T5> group(SettingField<O, T1> t1, SettingField<O, T2> t2, SettingField<O, T3> t3, SettingField<O, T4> t4, SettingField<O, T5> t5) {
        return new RecordFieldGroups.Group5<O, T1, T2, T3, T4, T5>(t1, t2, t3, t4, t5);
    }

    public <T1, T2, T3, T4, T5, T6> RecordFieldGroups.Group6<O, T1, T2, T3, T4, T5, T6> group(SettingField<O, T1> t1, SettingField<O, T2> t2, SettingField<O, T3> t3, SettingField<O, T4> t4, SettingField<O, T5> t5, SettingField<O, T6> t6) {
        return new RecordFieldGroups.Group6<O, T1, T2, T3, T4, T5, T6>(t1, t2, t3, t4, t5, t6);
    }

    public <T1, T2, T3, T4, T5, T6, T7> RecordFieldGroups.Group7<O, T1, T2, T3, T4, T5, T6, T7> group(SettingField<O, T1> t1, SettingField<O, T2> t2, SettingField<O, T3> t3, SettingField<O, T4> t4, SettingField<O, T5> t5, SettingField<O, T6> t6, SettingField<O, T7> t7) {
        return new RecordFieldGroups.Group7<O, T1, T2, T3, T4, T5, T6, T7>(t1, t2, t3, t4, t5, t6, t7);
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8> RecordFieldGroups.Group8<O, T1, T2, T3, T4, T5, T6, T7, T8> group(SettingField<O, T1> t1, SettingField<O, T2> t2, SettingField<O, T3> t3, SettingField<O, T4> t4, SettingField<O, T5> t5, SettingField<O, T6> t6, SettingField<O, T7> t7, SettingField<O, T8> t8) {
        return new RecordFieldGroups.Group8<O, T1, T2, T3, T4, T5, T6, T7, T8>(t1, t2, t3, t4, t5, t6, t7, t8);
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9> RecordFieldGroups.Group9<O, T1, T2, T3, T4, T5, T6, T7, T8, T9> group(SettingField<O, T1> t1, SettingField<O, T2> t2, SettingField<O, T3> t3, SettingField<O, T4> t4, SettingField<O, T5> t5, SettingField<O, T6> t6, SettingField<O, T7> t7, SettingField<O, T8> t8, SettingField<O, T9> t9) {
        return new RecordFieldGroups.Group9<O, T1, T2, T3, T4, T5, T6, T7, T8, T9>(t1, t2, t3, t4, t5, t6, t7, t8, t9);
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> RecordFieldGroups.Group10<O, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> group(SettingField<O, T1> t1, SettingField<O, T2> t2, SettingField<O, T3> t3, SettingField<O, T4> t4, SettingField<O, T5> t5, SettingField<O, T6> t6, SettingField<O, T7> t7, SettingField<O, T8> t8, SettingField<O, T9> t9, SettingField<O, T10> t10) {
        return new RecordFieldGroups.Group10<O, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10);
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> RecordFieldGroups.Group11<O, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> group(SettingField<O, T1> t1, SettingField<O, T2> t2, SettingField<O, T3> t3, SettingField<O, T4> t4, SettingField<O, T5> t5, SettingField<O, T6> t6, SettingField<O, T7> t7, SettingField<O, T8> t8, SettingField<O, T9> t9, SettingField<O, T10> t10, SettingField<O, T11> t11) {
        return new RecordFieldGroups.Group11<O, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11);
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> RecordFieldGroups.Group12<O, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> group(SettingField<O, T1> t1, SettingField<O, T2> t2, SettingField<O, T3> t3, SettingField<O, T4> t4, SettingField<O, T5> t5, SettingField<O, T6> t6, SettingField<O, T7> t7, SettingField<O, T8> t8, SettingField<O, T9> t9, SettingField<O, T10> t10, SettingField<O, T11> t11, SettingField<O, T12> t12) {
        return new RecordFieldGroups.Group12<O, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12);
    }

    <T1> Built<O> build1(final Function<T1, O> constructor, final SettingField<O, T1> settingField1) {
        this.serializer = new BaseSettingSerializer<O>(this.type){

            @Override
            public void write(ConfigurationSection config, String key, O value, String ... comments) {
                ConfigurationSection section = SettingSerializerFactories.getOrCreateSection(config, key, comments);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField1, value, false);
            }

            @Override
            public void writeWithDefault(ConfigurationSection config, String key, O value, String ... comments) {
                ConfigurationSection section = SettingSerializerFactories.getOrCreateSection(config, key, comments);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField1, value, true);
            }

            @Override
            public O read(ConfigurationSection config, String key) {
                ConfigurationSection section = config.getConfigurationSection(key);
                if (section == null) {
                    return null;
                }
                Object value1 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField1);
                return constructor.apply(value1);
            }

            @Override
            public boolean readIsValid(ConfigurationSection config, String key) {
                ConfigurationSection section = config.getConfigurationSection(key);
                return section != null && RecordSettingSerializerBuilder.testSection(section, settingField1);
            }
        };
        return new Built(this);
    }

    <T1, T2> Built<O> build2(final BiFunction<T1, T2, O> constructor, final SettingField<O, T1> settingField1, final SettingField<O, T2> settingField2) {
        this.serializer = new BaseSettingSerializer<O>(this.type){

            @Override
            public void write(ConfigurationSection config, String key, O value, String ... comments) {
                ConfigurationSection section = SettingSerializerFactories.getOrCreateSection(config, key, comments);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField1, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField2, value, false);
            }

            @Override
            public void writeWithDefault(ConfigurationSection config, String key, O value, String ... comments) {
                ConfigurationSection section = SettingSerializerFactories.getOrCreateSection(config, key, comments);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField1, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField2, value, true);
            }

            @Override
            public O read(ConfigurationSection config, String key) {
                ConfigurationSection section = config.getConfigurationSection(key);
                if (section == null) {
                    return null;
                }
                Object value1 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField1);
                Object value2 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField2);
                return constructor.apply(value1, value2);
            }

            @Override
            public boolean readIsValid(ConfigurationSection config, String key) {
                ConfigurationSection section = config.getConfigurationSection(key);
                return section != null && RecordSettingSerializerBuilder.testSection(section, settingField1) && RecordSettingSerializerBuilder.testSection(section, settingField2);
            }
        };
        return new Built(this);
    }

    <T1, T2, T3> Built<O> build3(final Functions.Function3<T1, T2, T3, O> constructor, final SettingField<O, T1> settingField1, final SettingField<O, T2> settingField2, final SettingField<O, T3> settingField3) {
        this.serializer = new BaseSettingSerializer<O>(this.type){

            @Override
            public void write(ConfigurationSection config, String key, O value, String ... comments) {
                ConfigurationSection section = SettingSerializerFactories.getOrCreateSection(config, key, comments);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField1, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField2, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField3, value, false);
            }

            @Override
            public void writeWithDefault(ConfigurationSection config, String key, O value, String ... comments) {
                ConfigurationSection section = SettingSerializerFactories.getOrCreateSection(config, key, comments);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField1, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField2, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField3, value, true);
            }

            @Override
            public O read(ConfigurationSection config, String key) {
                ConfigurationSection section = config.getConfigurationSection(key);
                if (section == null) {
                    return null;
                }
                Object value1 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField1);
                Object value2 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField2);
                Object value3 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField3);
                return constructor.apply(value1, value2, value3);
            }

            @Override
            public boolean readIsValid(ConfigurationSection config, String key) {
                ConfigurationSection section = config.getConfigurationSection(key);
                return section != null && RecordSettingSerializerBuilder.testSection(section, settingField1) && RecordSettingSerializerBuilder.testSection(section, settingField2) && RecordSettingSerializerBuilder.testSection(section, settingField3);
            }
        };
        return new Built(this);
    }

    <T1, T2, T3, T4> Built<O> build4(final Functions.Function4<T1, T2, T3, T4, O> constructor, final SettingField<O, T1> settingField1, final SettingField<O, T2> settingField2, final SettingField<O, T3> settingField3, final SettingField<O, T4> settingField4) {
        this.serializer = new BaseSettingSerializer<O>(this.type){

            @Override
            public void write(ConfigurationSection config, String key, O value, String ... comments) {
                ConfigurationSection section = SettingSerializerFactories.getOrCreateSection(config, key, comments);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField1, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField2, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField3, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField4, value, false);
            }

            @Override
            public void writeWithDefault(ConfigurationSection config, String key, O value, String ... comments) {
                ConfigurationSection section = SettingSerializerFactories.getOrCreateSection(config, key, comments);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField1, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField2, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField3, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField4, value, true);
            }

            @Override
            public O read(ConfigurationSection config, String key) {
                ConfigurationSection section = config.getConfigurationSection(key);
                if (section == null) {
                    return null;
                }
                Object value1 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField1);
                Object value2 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField2);
                Object value3 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField3);
                Object value4 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField4);
                return constructor.apply(value1, value2, value3, value4);
            }

            @Override
            public boolean readIsValid(ConfigurationSection config, String key) {
                ConfigurationSection section = config.getConfigurationSection(key);
                return section != null && RecordSettingSerializerBuilder.testSection(section, settingField1) && RecordSettingSerializerBuilder.testSection(section, settingField2) && RecordSettingSerializerBuilder.testSection(section, settingField3) && RecordSettingSerializerBuilder.testSection(section, settingField4);
            }
        };
        return new Built(this);
    }

    <T1, T2, T3, T4, T5> Built<O> build5(final Functions.Function5<T1, T2, T3, T4, T5, O> constructor, final SettingField<O, T1> settingField1, final SettingField<O, T2> settingField2, final SettingField<O, T3> settingField3, final SettingField<O, T4> settingField4, final SettingField<O, T5> settingField5) {
        this.serializer = new BaseSettingSerializer<O>(this.type){

            @Override
            public void write(ConfigurationSection config, String key, O value, String ... comments) {
                ConfigurationSection section = SettingSerializerFactories.getOrCreateSection(config, key, comments);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField1, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField2, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField3, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField4, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField5, value, false);
            }

            @Override
            public void writeWithDefault(ConfigurationSection config, String key, O value, String ... comments) {
                ConfigurationSection section = SettingSerializerFactories.getOrCreateSection(config, key, comments);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField1, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField2, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField3, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField4, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField5, value, true);
            }

            @Override
            public O read(ConfigurationSection config, String key) {
                ConfigurationSection section = config.getConfigurationSection(key);
                if (section == null) {
                    return null;
                }
                Object value1 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField1);
                Object value2 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField2);
                Object value3 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField3);
                Object value4 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField4);
                Object value5 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField5);
                return constructor.apply(value1, value2, value3, value4, value5);
            }

            @Override
            public boolean readIsValid(ConfigurationSection config, String key) {
                ConfigurationSection section = config.getConfigurationSection(key);
                return section != null && RecordSettingSerializerBuilder.testSection(section, settingField1) && RecordSettingSerializerBuilder.testSection(section, settingField2) && RecordSettingSerializerBuilder.testSection(section, settingField3) && RecordSettingSerializerBuilder.testSection(section, settingField4) && RecordSettingSerializerBuilder.testSection(section, settingField5);
            }
        };
        return new Built(this);
    }

    <T1, T2, T3, T4, T5, T6> Built<O> build6(final Functions.Function6<T1, T2, T3, T4, T5, T6, O> constructor, final SettingField<O, T1> settingField1, final SettingField<O, T2> settingField2, final SettingField<O, T3> settingField3, final SettingField<O, T4> settingField4, final SettingField<O, T5> settingField5, final SettingField<O, T6> settingField6) {
        this.serializer = new BaseSettingSerializer<O>(this.type){

            @Override
            public void write(ConfigurationSection config, String key, O value, String ... comments) {
                ConfigurationSection section = SettingSerializerFactories.getOrCreateSection(config, key, comments);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField1, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField2, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField3, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField4, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField5, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField6, value, false);
            }

            @Override
            public void writeWithDefault(ConfigurationSection config, String key, O value, String ... comments) {
                ConfigurationSection section = SettingSerializerFactories.getOrCreateSection(config, key, comments);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField1, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField2, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField3, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField4, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField5, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField6, value, true);
            }

            @Override
            public O read(ConfigurationSection config, String key) {
                ConfigurationSection section = config.getConfigurationSection(key);
                if (section == null) {
                    return null;
                }
                Object value1 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField1);
                Object value2 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField2);
                Object value3 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField3);
                Object value4 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField4);
                Object value5 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField5);
                Object value6 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField6);
                return constructor.apply(value1, value2, value3, value4, value5, value6);
            }

            @Override
            public boolean readIsValid(ConfigurationSection config, String key) {
                ConfigurationSection section = config.getConfigurationSection(key);
                return section != null && RecordSettingSerializerBuilder.testSection(section, settingField1) && RecordSettingSerializerBuilder.testSection(section, settingField2) && RecordSettingSerializerBuilder.testSection(section, settingField3) && RecordSettingSerializerBuilder.testSection(section, settingField4) && RecordSettingSerializerBuilder.testSection(section, settingField5) && RecordSettingSerializerBuilder.testSection(section, settingField6);
            }
        };
        return new Built(this);
    }

    <T1, T2, T3, T4, T5, T6, T7> Built<O> build7(final Functions.Function7<T1, T2, T3, T4, T5, T6, T7, O> constructor, final SettingField<O, T1> settingField1, final SettingField<O, T2> settingField2, final SettingField<O, T3> settingField3, final SettingField<O, T4> settingField4, final SettingField<O, T5> settingField5, final SettingField<O, T6> settingField6, final SettingField<O, T7> settingField7) {
        this.serializer = new BaseSettingSerializer<O>(this.type){

            @Override
            public void write(ConfigurationSection config, String key, O value, String ... comments) {
                ConfigurationSection section = SettingSerializerFactories.getOrCreateSection(config, key, comments);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField1, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField2, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField3, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField4, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField5, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField6, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField7, value, false);
            }

            @Override
            public void writeWithDefault(ConfigurationSection config, String key, O value, String ... comments) {
                ConfigurationSection section = SettingSerializerFactories.getOrCreateSection(config, key, comments);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField1, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField2, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField3, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField4, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField5, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField6, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField7, value, true);
            }

            @Override
            public O read(ConfigurationSection config, String key) {
                ConfigurationSection section = config.getConfigurationSection(key);
                if (section == null) {
                    return null;
                }
                Object value1 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField1);
                Object value2 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField2);
                Object value3 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField3);
                Object value4 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField4);
                Object value5 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField5);
                Object value6 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField6);
                Object value7 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField7);
                return constructor.apply(value1, value2, value3, value4, value5, value6, value7);
            }

            @Override
            public boolean readIsValid(ConfigurationSection config, String key) {
                ConfigurationSection section = config.getConfigurationSection(key);
                return section != null && RecordSettingSerializerBuilder.testSection(section, settingField1) && RecordSettingSerializerBuilder.testSection(section, settingField2) && RecordSettingSerializerBuilder.testSection(section, settingField3) && RecordSettingSerializerBuilder.testSection(section, settingField4) && RecordSettingSerializerBuilder.testSection(section, settingField5) && RecordSettingSerializerBuilder.testSection(section, settingField6) && RecordSettingSerializerBuilder.testSection(section, settingField7);
            }
        };
        return new Built(this);
    }

    <T1, T2, T3, T4, T5, T6, T7, T8> Built<O> build8(final Functions.Function8<T1, T2, T3, T4, T5, T6, T7, T8, O> constructor, final SettingField<O, T1> settingField1, final SettingField<O, T2> settingField2, final SettingField<O, T3> settingField3, final SettingField<O, T4> settingField4, final SettingField<O, T5> settingField5, final SettingField<O, T6> settingField6, final SettingField<O, T7> settingField7, final SettingField<O, T8> settingField8) {
        this.serializer = new BaseSettingSerializer<O>(this.type){

            @Override
            public void write(ConfigurationSection config, String key, O value, String ... comments) {
                ConfigurationSection section = SettingSerializerFactories.getOrCreateSection(config, key, comments);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField1, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField2, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField3, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField4, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField5, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField6, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField7, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField8, value, false);
            }

            @Override
            public void writeWithDefault(ConfigurationSection config, String key, O value, String ... comments) {
                ConfigurationSection section = SettingSerializerFactories.getOrCreateSection(config, key, comments);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField1, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField2, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField3, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField4, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField5, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField6, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField7, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField8, value, true);
            }

            @Override
            public O read(ConfigurationSection config, String key) {
                ConfigurationSection section = config.getConfigurationSection(key);
                if (section == null) {
                    return null;
                }
                Object value1 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField1);
                Object value2 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField2);
                Object value3 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField3);
                Object value4 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField4);
                Object value5 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField5);
                Object value6 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField6);
                Object value7 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField7);
                Object value8 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField8);
                return constructor.apply(value1, value2, value3, value4, value5, value6, value7, value8);
            }

            @Override
            public boolean readIsValid(ConfigurationSection config, String key) {
                ConfigurationSection section = config.getConfigurationSection(key);
                return section != null && RecordSettingSerializerBuilder.testSection(section, settingField1) && RecordSettingSerializerBuilder.testSection(section, settingField2) && RecordSettingSerializerBuilder.testSection(section, settingField3) && RecordSettingSerializerBuilder.testSection(section, settingField4) && RecordSettingSerializerBuilder.testSection(section, settingField5) && RecordSettingSerializerBuilder.testSection(section, settingField6) && RecordSettingSerializerBuilder.testSection(section, settingField7) && RecordSettingSerializerBuilder.testSection(section, settingField8);
            }
        };
        return new Built(this);
    }

    <T1, T2, T3, T4, T5, T6, T7, T8, T9> Built<O> build9(final Functions.Function9<T1, T2, T3, T4, T5, T6, T7, T8, T9, O> constructor, final SettingField<O, T1> settingField1, final SettingField<O, T2> settingField2, final SettingField<O, T3> settingField3, final SettingField<O, T4> settingField4, final SettingField<O, T5> settingField5, final SettingField<O, T6> settingField6, final SettingField<O, T7> settingField7, final SettingField<O, T8> settingField8, final SettingField<O, T9> settingField9) {
        this.serializer = new BaseSettingSerializer<O>(this.type){

            @Override
            public void write(ConfigurationSection config, String key, O value, String ... comments) {
                ConfigurationSection section = SettingSerializerFactories.getOrCreateSection(config, key, comments);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField1, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField2, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField3, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField4, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField5, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField6, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField7, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField8, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField9, value, false);
            }

            @Override
            public void writeWithDefault(ConfigurationSection config, String key, O value, String ... comments) {
                ConfigurationSection section = SettingSerializerFactories.getOrCreateSection(config, key, comments);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField1, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField2, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField3, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField4, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField5, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField6, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField7, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField8, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField9, value, true);
            }

            @Override
            public O read(ConfigurationSection config, String key) {
                ConfigurationSection section = config.getConfigurationSection(key);
                if (section == null) {
                    return null;
                }
                Object value1 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField1);
                Object value2 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField2);
                Object value3 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField3);
                Object value4 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField4);
                Object value5 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField5);
                Object value6 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField6);
                Object value7 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField7);
                Object value8 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField8);
                Object value9 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField9);
                return constructor.apply(value1, value2, value3, value4, value5, value6, value7, value8, value9);
            }

            @Override
            public boolean readIsValid(ConfigurationSection config, String key) {
                ConfigurationSection section = config.getConfigurationSection(key);
                return section != null && RecordSettingSerializerBuilder.testSection(section, settingField1) && RecordSettingSerializerBuilder.testSection(section, settingField2) && RecordSettingSerializerBuilder.testSection(section, settingField3) && RecordSettingSerializerBuilder.testSection(section, settingField4) && RecordSettingSerializerBuilder.testSection(section, settingField5) && RecordSettingSerializerBuilder.testSection(section, settingField6) && RecordSettingSerializerBuilder.testSection(section, settingField7) && RecordSettingSerializerBuilder.testSection(section, settingField8) && RecordSettingSerializerBuilder.testSection(section, settingField9);
            }
        };
        return new Built(this);
    }

    <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> Built<O> build10(final Functions.Function10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, O> constructor, final SettingField<O, T1> settingField1, final SettingField<O, T2> settingField2, final SettingField<O, T3> settingField3, final SettingField<O, T4> settingField4, final SettingField<O, T5> settingField5, final SettingField<O, T6> settingField6, final SettingField<O, T7> settingField7, final SettingField<O, T8> settingField8, final SettingField<O, T9> settingField9, final SettingField<O, T10> settingField10) {
        this.serializer = new BaseSettingSerializer<O>(this.type){

            @Override
            public void write(ConfigurationSection config, String key, O value, String ... comments) {
                ConfigurationSection section = SettingSerializerFactories.getOrCreateSection(config, key, comments);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField1, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField2, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField3, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField4, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField5, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField6, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField7, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField8, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField9, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField10, value, false);
            }

            @Override
            public void writeWithDefault(ConfigurationSection config, String key, O value, String ... comments) {
                ConfigurationSection section = SettingSerializerFactories.getOrCreateSection(config, key, comments);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField1, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField2, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField3, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField4, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField5, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField6, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField7, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField8, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField9, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField10, value, true);
            }

            @Override
            public O read(ConfigurationSection config, String key) {
                ConfigurationSection section = config.getConfigurationSection(key);
                if (section == null) {
                    return null;
                }
                Object value1 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField1);
                Object value2 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField2);
                Object value3 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField3);
                Object value4 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField4);
                Object value5 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField5);
                Object value6 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField6);
                Object value7 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField7);
                Object value8 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField8);
                Object value9 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField9);
                Object value10 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField10);
                return constructor.apply(value1, value2, value3, value4, value5, value6, value7, value8, value9, value10);
            }

            @Override
            public boolean readIsValid(ConfigurationSection config, String key) {
                ConfigurationSection section = config.getConfigurationSection(key);
                return section != null && RecordSettingSerializerBuilder.testSection(section, settingField1) && RecordSettingSerializerBuilder.testSection(section, settingField2) && RecordSettingSerializerBuilder.testSection(section, settingField3) && RecordSettingSerializerBuilder.testSection(section, settingField4) && RecordSettingSerializerBuilder.testSection(section, settingField5) && RecordSettingSerializerBuilder.testSection(section, settingField6) && RecordSettingSerializerBuilder.testSection(section, settingField7) && RecordSettingSerializerBuilder.testSection(section, settingField8) && RecordSettingSerializerBuilder.testSection(section, settingField9) && RecordSettingSerializerBuilder.testSection(section, settingField10);
            }
        };
        return new Built(this);
    }

    <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> Built<O> build11(final Functions.Function11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, O> constructor, final SettingField<O, T1> settingField1, final SettingField<O, T2> settingField2, final SettingField<O, T3> settingField3, final SettingField<O, T4> settingField4, final SettingField<O, T5> settingField5, final SettingField<O, T6> settingField6, final SettingField<O, T7> settingField7, final SettingField<O, T8> settingField8, final SettingField<O, T9> settingField9, final SettingField<O, T10> settingField10, final SettingField<O, T11> settingField11) {
        this.serializer = new BaseSettingSerializer<O>(this.type){

            @Override
            public void write(ConfigurationSection config, String key, O value, String ... comments) {
                ConfigurationSection section = SettingSerializerFactories.getOrCreateSection(config, key, comments);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField1, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField2, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField3, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField4, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField5, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField6, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField7, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField8, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField9, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField10, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField11, value, false);
            }

            @Override
            public void writeWithDefault(ConfigurationSection config, String key, O value, String ... comments) {
                ConfigurationSection section = SettingSerializerFactories.getOrCreateSection(config, key, comments);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField1, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField2, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField3, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField4, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField5, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField6, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField7, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField8, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField9, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField10, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField11, value, true);
            }

            @Override
            public O read(ConfigurationSection config, String key) {
                ConfigurationSection section = config.getConfigurationSection(key);
                if (section == null) {
                    return null;
                }
                Object value1 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField1);
                Object value2 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField2);
                Object value3 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField3);
                Object value4 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField4);
                Object value5 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField5);
                Object value6 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField6);
                Object value7 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField7);
                Object value8 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField8);
                Object value9 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField9);
                Object value10 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField10);
                Object value11 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField11);
                return constructor.apply(value1, value2, value3, value4, value5, value6, value7, value8, value9, value10, value11);
            }

            @Override
            public boolean readIsValid(ConfigurationSection config, String key) {
                ConfigurationSection section = config.getConfigurationSection(key);
                return section != null && RecordSettingSerializerBuilder.testSection(section, settingField1) && RecordSettingSerializerBuilder.testSection(section, settingField2) && RecordSettingSerializerBuilder.testSection(section, settingField3) && RecordSettingSerializerBuilder.testSection(section, settingField4) && RecordSettingSerializerBuilder.testSection(section, settingField5) && RecordSettingSerializerBuilder.testSection(section, settingField6) && RecordSettingSerializerBuilder.testSection(section, settingField7) && RecordSettingSerializerBuilder.testSection(section, settingField8) && RecordSettingSerializerBuilder.testSection(section, settingField9) && RecordSettingSerializerBuilder.testSection(section, settingField10) && RecordSettingSerializerBuilder.testSection(section, settingField11);
            }
        };
        return new Built(this);
    }

    <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> Built<O> build12(final Functions.Function12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, O> constructor, final SettingField<O, T1> settingField1, final SettingField<O, T2> settingField2, final SettingField<O, T3> settingField3, final SettingField<O, T4> settingField4, final SettingField<O, T5> settingField5, final SettingField<O, T6> settingField6, final SettingField<O, T7> settingField7, final SettingField<O, T8> settingField8, final SettingField<O, T9> settingField9, final SettingField<O, T10> settingField10, final SettingField<O, T11> settingField11, final SettingField<O, T12> settingField12) {
        this.serializer = new BaseSettingSerializer<O>(this.type){

            @Override
            public void write(ConfigurationSection config, String key, O value, String ... comments) {
                ConfigurationSection section = SettingSerializerFactories.getOrCreateSection(config, key, comments);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField1, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField2, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField3, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField4, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField5, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField6, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField7, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField8, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField9, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField10, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField11, value, false);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField12, value, false);
            }

            @Override
            public void writeWithDefault(ConfigurationSection config, String key, O value, String ... comments) {
                ConfigurationSection section = SettingSerializerFactories.getOrCreateSection(config, key, comments);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField1, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField2, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField3, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField4, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField5, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField6, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField7, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField8, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField9, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField10, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField11, value, true);
                RecordSettingSerializerBuilder.writeConfigurationField(section, settingField12, value, true);
            }

            @Override
            public O read(ConfigurationSection config, String key) {
                ConfigurationSection section = config.getConfigurationSection(key);
                if (section == null) {
                    return null;
                }
                Object value1 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField1);
                Object value2 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField2);
                Object value3 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField3);
                Object value4 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField4);
                Object value5 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField5);
                Object value6 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField6);
                Object value7 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField7);
                Object value8 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField8);
                Object value9 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField9);
                Object value10 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField10);
                Object value11 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField11);
                Object value12 = RecordSettingSerializerBuilder.getValueOrDefault(section, settingField12);
                return constructor.apply(value1, value2, value3, value4, value5, value6, value7, value8, value9, value10, value11, value12);
            }

            @Override
            public boolean readIsValid(ConfigurationSection config, String key) {
                ConfigurationSection section = config.getConfigurationSection(key);
                return section != null && RecordSettingSerializerBuilder.testSection(section, settingField1) && RecordSettingSerializerBuilder.testSection(section, settingField2) && RecordSettingSerializerBuilder.testSection(section, settingField3) && RecordSettingSerializerBuilder.testSection(section, settingField4) && RecordSettingSerializerBuilder.testSection(section, settingField5) && RecordSettingSerializerBuilder.testSection(section, settingField6) && RecordSettingSerializerBuilder.testSection(section, settingField7) && RecordSettingSerializerBuilder.testSection(section, settingField8) && RecordSettingSerializerBuilder.testSection(section, settingField9) && RecordSettingSerializerBuilder.testSection(section, settingField10) && RecordSettingSerializerBuilder.testSection(section, settingField11) && RecordSettingSerializerBuilder.testSection(section, settingField12);
            }
        };
        return new Built(this);
    }

    public static class Built<T> {
        private final RecordSettingSerializerBuilder<T> instance;

        private Built(RecordSettingSerializerBuilder<T> instance) {
            this.instance = instance;
        }

        private RecordSettingSerializerBuilder<T> instance() {
            return this.instance;
        }
    }
}

