/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.config;

import dev.rosewood.rosestacker.lib.rosegarden.config.BasicRoseConfig;
import dev.rosewood.rosestacker.lib.rosegarden.config.CommentedFileConfiguration;
import dev.rosewood.rosestacker.lib.rosegarden.config.RoseSetting;
import dev.rosewood.rosestacker.lib.rosegarden.config.SettingHolder;
import dev.rosewood.rosestacker.lib.rosegarden.config.SettingSerializer;
import java.io.File;
import java.util.List;
import java.util.function.Supplier;

public interface RoseConfig {
    public List<RoseSetting<?>> getSettings();

    public <T> T get(RoseSetting<T> var1);

    default public <T> T get(String key, SettingSerializer<T> serializer) {
        return this.get(key, serializer, (T)null);
    }

    default public <T> T get(String key, SettingSerializer<T> serializer, T defaultValue) {
        return this.get(RoseSetting.ofValue(key, serializer, defaultValue, new String[0]));
    }

    default public <T> T get(String key, SettingSerializer<T> serializer, Supplier<T> defaultValueSupplier) {
        return this.get(RoseSetting.of(key, serializer, defaultValueSupplier, new String[0]));
    }

    public <T> void set(RoseSetting<T> var1, T var2);

    default public <T> void set(String key, SettingSerializer<T> serializer, T value) {
        this.set(RoseSetting.ofValue(key, serializer, value, new String[0]), value);
    }

    default public <T> void set(String key, SettingSerializer<T> serializer, Supplier<T> valueSupplier) {
        this.set(RoseSetting.of(key, serializer, valueSupplier, new String[0]), valueSupplier.get());
    }

    public File getFile();

    public CommentedFileConfiguration getBaseConfig();

    public void reload();

    default public void save() {
        this.getBaseConfig().save(this.getFile());
    }

    public static Builder builder(File file) {
        return new BasicRoseConfig.Builder(file);
    }

    public static interface Builder {
        public Builder header(String ... var1);

        public Builder settings(List<RoseSetting<?>> var1);

        public Builder settings(SettingHolder var1);

        public Builder writeDefaultValueComments();

        public RoseConfig build();
    }
}

