/*
 * Decompiled with CFR 0.152.
 */
package dev.rosewood.rosestacker.lib.rosegarden.config;

import dev.rosewood.rosestacker.lib.rosegarden.RosePlugin;
import dev.rosewood.rosestacker.lib.rosegarden.config.BackedRoseSetting;
import dev.rosewood.rosestacker.lib.rosegarden.config.BasicRoseSetting;
import dev.rosewood.rosestacker.lib.rosegarden.config.RoseConfig;
import dev.rosewood.rosestacker.lib.rosegarden.config.SettingSerializer;
import dev.rosewood.rosestacker.lib.rosegarden.config.SettingSerializers;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.bukkit.configuration.ConfigurationSection;

public interface RoseSetting<T> {
    public void write(ConfigurationSection var1);

    public void writeWithDefault(ConfigurationSection var1);

    public T read(ConfigurationSection var1);

    public void readDefault(ConfigurationSection var1);

    public boolean readIsValid(ConfigurationSection var1);

    public SettingSerializer<T> getSerializer();

    public String getKey();

    public T getDefaultValue();

    public String[] getComments();

    default public T get() {
        throw new UnsupportedOperationException("get() is not supported for this setting, missing backing config");
    }

    default public T get(RoseConfig config) {
        return config.get(this);
    }

    default public boolean isBacked() {
        return false;
    }

    public boolean isHidden();

    public RoseSetting<T> copy(T var1, String ... var2);

    public RoseSetting<T> copy(Supplier<T> var1, String ... var2);

    public static RoseSetting<Boolean> ofBoolean(String name, boolean defaultValue, String ... comments) {
        return RoseSetting.of(name, SettingSerializers.BOOLEAN, () -> defaultValue, comments);
    }

    public static RoseSetting<Integer> ofInteger(String name, int defaultValue, String ... comments) {
        return RoseSetting.of(name, SettingSerializers.INTEGER, () -> defaultValue, comments);
    }

    public static RoseSetting<Long> ofLong(String name, long defaultValue, String ... comments) {
        return RoseSetting.of(name, SettingSerializers.LONG, () -> defaultValue, comments);
    }

    public static RoseSetting<Short> ofShort(String name, short defaultValue, String ... comments) {
        return RoseSetting.of(name, SettingSerializers.SHORT, () -> defaultValue, comments);
    }

    public static RoseSetting<Byte> ofByte(String name, byte defaultValue, String ... comments) {
        return RoseSetting.of(name, SettingSerializers.BYTE, () -> defaultValue, comments);
    }

    public static RoseSetting<Double> ofDouble(String name, double defaultValue, String ... comments) {
        return RoseSetting.of(name, SettingSerializers.DOUBLE, () -> defaultValue, comments);
    }

    public static RoseSetting<Float> ofFloat(String name, float defaultValue, String ... comments) {
        return RoseSetting.of(name, SettingSerializers.FLOAT, () -> Float.valueOf(defaultValue), comments);
    }

    public static RoseSetting<Character> ofCharacter(String name, char defaultValue, String ... comments) {
        return RoseSetting.of(name, SettingSerializers.CHAR, () -> Character.valueOf(defaultValue), comments);
    }

    public static RoseSetting<String> ofString(String name, String defaultValue, String ... comments) {
        return RoseSetting.of(name, SettingSerializers.STRING, () -> defaultValue, comments);
    }

    public static RoseSetting<List<String>> ofStringList(String name, List<String> defaultValue, String ... comments) {
        return RoseSetting.of(name, SettingSerializers.ofList(SettingSerializers.STRING), () -> new ArrayList(defaultValue), comments);
    }

    public static <T extends Enum<T>> RoseSetting<T> ofEnum(String name, Class<T> enumClass, T defaultValue, String ... comments) {
        return RoseSetting.of(name, SettingSerializers.ofEnum(enumClass), () -> defaultValue, comments);
    }

    public static RoseSetting<ConfigurationSection> ofSection(String name, String ... comments) {
        return RoseSetting.ofValue(name, SettingSerializers.SECTION, null, comments);
    }

    public static <T> RoseSetting<T> ofValue(String name, SettingSerializer<T> serializer, T defaultValue, String ... comments) {
        return new BasicRoseSetting<Object>(serializer, name.toLowerCase(), () -> defaultValue, false, comments != null ? comments : new String[]{});
    }

    public static <T> RoseSetting<T> of(String name, SettingSerializer<T> serializer, Supplier<T> defaultValueSupplier, String ... comments) {
        return new BasicRoseSetting<T>(serializer, name.toLowerCase(), defaultValueSupplier, false, comments != null ? comments : new String[]{});
    }

    public static <T> RoseSetting<T> ofHiddenValue(String name, SettingSerializer<T> serializer, T defaultValue) {
        return new BasicRoseSetting<Object>(serializer, name.toLowerCase(), () -> defaultValue, true, new String[0]);
    }

    public static <T> RoseSetting<T> ofHidden(String name, SettingSerializer<T> serializer, Supplier<T> defaultValueSupplier) {
        return new BasicRoseSetting<T>(serializer, name.toLowerCase(), defaultValueSupplier, true, new String[0]);
    }

    public static <T> RoseSetting<T> ofBacked(String name, RosePlugin backing, SettingSerializer<T> serializer, Supplier<T> defaultValueSupplier, String ... comments) {
        return new BackedRoseSetting<T>(backing, serializer, name.toLowerCase(), defaultValueSupplier, comments);
    }

    public static <T> RoseSetting<T> ofBackedValue(String name, RosePlugin backing, SettingSerializer<T> serializer, T defaultValue, String ... comments) {
        return new BackedRoseSetting<Object>(backing, serializer, name.toLowerCase(), () -> defaultValue, comments);
    }

    public static RoseSetting<ConfigurationSection> ofBackedSection(String name, RosePlugin backing, String ... comments) {
        return RoseSetting.ofBackedValue(name, backing, SettingSerializers.SECTION, null, comments);
    }
}

